/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.model.LicenseStore;

public abstract class AbstractLicenseNameMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.licenseResolver")
    private String licenseResolver;
    @Parameter(property="license.keepBackup", defaultValue="false")
    private boolean keepBackup;
    @Parameter(property="license.licenseName")
    private String licenseName;
    private License license;
    private LicenseStore licenseStore;

    public abstract boolean isSkip();

    public abstract void setSkip(boolean var1);

    protected boolean checkSkip() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skip flag is on, will skip goal.");
            return false;
        }
        return super.checkSkip();
    }

    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        this.licenseStore = LicenseStore.createLicenseStore(this.getLog(), this.getLicenseResolver());
        this.license = this.getLicense(this.licenseName, true);
    }

    public License getLicense(String licenseName, boolean checkIfExists) {
        if (StringUtils.isEmpty((CharSequence)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        LicenseStore licenseStore = this.getLicenseStore();
        if (licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License license = licenseStore.getLicense(licenseName);
        if (checkIfExists && license == null) {
            throw new IllegalArgumentException("License named '" + licenseName + "' is unknown, use one of " + Arrays.toString(licenseStore.getLicenseNames()));
        }
        return license;
    }

    public boolean isKeepBackup() {
        return this.keepBackup;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getLicenseResolver() {
        return this.licenseResolver;
    }

    public LicenseStore getLicenseStore() {
        return this.licenseStore;
    }

    public License getLicense() {
        return this.license;
    }
}

