/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseNameMojo;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderFilter;
import org.codehaus.mojo.license.header.FileHeaderProcessor;
import org.codehaus.mojo.license.header.FileHeaderProcessorConfiguration;
import org.codehaus.mojo.license.header.InvalideFileHeaderException;
import org.codehaus.mojo.license.header.UpdateFileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.JavaFileHeaderTransformer;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.nuiton.processor.Processor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileHeaderMojo
extends AbstractLicenseNameMojo
implements FileHeaderProcessorConfiguration {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    public static final String[] DEFAULT_EXCLUDES = new String[]{"**/*.zargo", "**/*.uml", "**/*.umldi", "**/*.xmi", "**/*.img", "**/*.png", "**/*.jpg", "**/*.jpeg", "**/*.gif", "**/*.zip", "**/*.jar", "**/*.war", "**/*.ear", "**/*.tgz", "**/*.gz"};
    public static final String[] DEFAULT_ROOTS = new String[]{"src", "target/generated-sources", "target/processed-sources"};
    @Parameter(property="license.projectName", defaultValue="${project.name}", required=true)
    protected String projectName;
    @Parameter(property="license.organizationName", defaultValue="${project.organization.name}", required=true)
    protected String organizationName;
    @Parameter(property="license.inceptionYear", defaultValue="${project.inceptionYear}", required=true)
    protected String inceptionYear;
    @Parameter(property="license.processStartTag")
    protected String processStartTag;
    @Parameter(property="license.processEndTag")
    protected String processEndTag;
    @Parameter(property="license.sectionDelimiter")
    protected String sectionDelimiter;
    @Parameter(property="license.addSvnKeyWords", defaultValue="false")
    protected boolean addSvnKeyWords;
    @Parameter(property="license.canUpdateDescription", defaultValue="false")
    protected boolean canUpdateDescription;
    @Parameter(property="license.canUpdateCopyright", defaultValue="false")
    protected boolean canUpdateCopyright;
    @Parameter(property="license.canUpdateLicense", defaultValue="true")
    protected boolean canUpdateLicense;
    @Parameter(property="license.ignoreTag")
    protected String ignoreTag;
    @Parameter(property="license.clearAfterOperation", defaultValue="true")
    protected boolean clearAfterOperation;
    @Parameter(property="license.addJavaLicenseAfterPackage", defaultValue="true")
    protected boolean addJavaLicenseAfterPackage;
    @Parameter(property="license.roots")
    protected String[] roots;
    @Parameter(property="license.includes")
    protected String[] includes;
    @Parameter(property="license.excludes")
    protected String[] excludes;
    @Parameter
    protected Map<String, String> extraExtensions;
    @Parameter(property="license.descriptionTemplate", defaultValue="/org/codehaus/mojo/license/default-file-header-description.ftl")
    protected String descriptionTemplate;
    @Component(role=Processor.class, hint="file-header")
    private FileHeaderProcessor processor;
    @Component(role=FileHeaderFilter.class, hint="update-file-header")
    private UpdateFileHeaderFilter filter;
    @Component(role=FileHeaderTransformer.class)
    private Map<String, FileHeaderTransformer> transformers;
    @Component(role=FreeMarkerHelper.class)
    private FreeMarkerHelper freeMarkerHelper;
    private FileHeaderTransformer transformer;
    private FileHeader header;
    private long timestamp;
    private Map<String, String> extensionToCommentStyle;
    private Template descriptionTemplate0;
    private Set<File> processedFiles;
    private EnumMap<FileState, Set<File>> result;
    private Map<String, List<File>> filesToTreateByCommentStyle;

    protected abstract boolean isDryRun();

    protected abstract boolean isFailOnMissingHeader();

    protected abstract boolean isFailOnNotUptodateHeader();

    @Override
    public void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.ignoreTag)) {
            this.ignoreTag = "%%Ignore-License";
        }
        if (!this.isDryRun()) {
            if (this.isFailOnMissingHeader()) {
                this.getLog().warn((CharSequence)"The failOnMissingHeader has no effect if the property dryRun is not setted.");
            }
            if (this.isFailOnNotUptodateHeader()) {
                this.getLog().warn((CharSequence)"The failOnNotUptodateHeader has no effect if the property dryRun is not setted.");
            }
        }
        if (this.isVerbose()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("config - available comment styles :");
            String string = "\n  * %1$s (%2$s)";
            for (String transformerName : this.transformers.keySet()) {
                FileHeaderTransformer aTransformer = this.getTransformer(transformerName);
                String str = String.format(string, aTransformer.getName(), aTransformer.getDescription());
                buffer.append(str);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        this.timestamp = System.nanoTime();
        this.filter.setUpdateCopyright(this.canUpdateCopyright);
        this.filter.setUpdateDescription(this.canUpdateDescription);
        this.filter.setUpdateLicense(this.canUpdateLicense);
        this.filter.setLog(this.getLog());
        this.processor.setConfiguration(this);
        this.processor.setFilter(this.filter);
        super.init();
        if (this.roots == null || this.roots.length == 0) {
            this.roots = DEFAULT_ROOTS;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default roots " + Arrays.toString(this.roots)));
            }
        }
        if (this.includes == null || this.includes.length == 0) {
            this.includes = DEFAULT_INCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default includes " + Arrays.toString(this.includes)));
            }
        }
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = DEFAULT_EXCLUDES;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Will use default excludes" + Arrays.toString(this.excludes)));
            }
        }
        this.extensionToCommentStyle = new TreeMap<String, String>();
        this.processStartTag = this.cleanHeaderConfiguration(this.processStartTag, "#%L");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will use processStartTag: " + this.processEndTag));
        }
        this.processEndTag = this.cleanHeaderConfiguration(this.processEndTag, "#L%");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will use processEndTag: " + this.processEndTag));
        }
        this.sectionDelimiter = this.cleanHeaderConfiguration(this.sectionDelimiter, "%%");
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Will use sectionDelimiter: " + this.sectionDelimiter));
        }
        for (Map.Entry<String, FileHeaderTransformer> entry : this.transformers.entrySet()) {
            String[] extensions;
            String commentStyle = entry.getKey();
            FileHeaderTransformer aTransformer = entry.getValue();
            aTransformer.setProcessStartTag(this.processStartTag);
            aTransformer.setProcessEndTag(this.processEndTag);
            aTransformer.setSectionDelimiter(this.sectionDelimiter);
            if (aTransformer instanceof JavaFileHeaderTransformer) {
                ((JavaFileHeaderTransformer)aTransformer).setAddJavaLicenseAfterPackage(this.addJavaLicenseAfterPackage);
            }
            for (String extension : extensions = aTransformer.getDefaultAcceptedExtensions()) {
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension " + extension + " to comment style " + commentStyle));
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        if (this.extraExtensions != null) {
            for (Map.Entry<String, Object> entry : this.extraExtensions.entrySet()) {
                String extension = entry.getKey();
                if (this.extensionToCommentStyle.containsKey(extension)) {
                    this.getLog().warn((CharSequence)("The extension " + extension + " is already accepted for comment style " + this.extensionToCommentStyle.get(extension)));
                }
                String commentStyle = (String)entry.getValue();
                this.getTransformer(commentStyle);
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Associate extension '" + extension + "' to comment style '" + commentStyle + "'"));
                }
                this.extensionToCommentStyle.put(extension, commentStyle);
            }
        }
        this.filesToTreateByCommentStyle = this.obtainFilesToProcessByCommentStyle();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use description template : " + this.descriptionTemplate));
        }
        this.descriptionTemplate0 = this.freeMarkerHelper.getTemplate(this.descriptionTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction() throws Exception {
        long t0 = System.nanoTime();
        this.clear();
        this.processedFiles = new HashSet<File>();
        this.result = new EnumMap(FileState.class);
        try {
            for (Map.Entry<String, List<File>> commentStyleFiles : this.filesToTreateByCommentStyle.entrySet()) {
                String commentStyle = commentStyleFiles.getKey();
                List<File> files = commentStyleFiles.getValue();
                this.processCommentStyle(commentStyle, files);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.checkResults(this.result);
            int nbFiles = this.processedFiles.size();
            if (nbFiles == 0) {
                this.getLog().warn((CharSequence)"No file to scan.");
            } else {
                String delay = MojoHelper.convertTime(System.nanoTime() - t0);
                String message = String.format("Scan %s file%s header done in %s.", nbFiles, nbFiles > 1 ? "s" : "", delay);
                this.getLog().info((CharSequence)message);
            }
            Set<FileState> states = this.result.keySet();
            if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
                this.getLog().info((CharSequence)"All files are up-to-date.");
            } else {
                StringBuilder buffer = new StringBuilder();
                for (FileState state : FileState.values()) {
                    this.reportType(state, buffer);
                }
                this.getLog().info((CharSequence)buffer.toString());
            }
            if (this.clearAfterOperation) {
                this.clear();
            }
            throw throwable;
        }
        this.checkResults(this.result);
        int nbFiles = this.processedFiles.size();
        if (nbFiles == 0) {
            this.getLog().warn((CharSequence)"No file to scan.");
        } else {
            String delay = MojoHelper.convertTime(System.nanoTime() - t0);
            String message = String.format("Scan %s file%s header done in %s.", nbFiles, nbFiles > 1 ? "s" : "", delay);
            this.getLog().info((CharSequence)message);
        }
        Set<FileState> states = this.result.keySet();
        if (states.size() == 1 && states.contains((Object)FileState.uptodate)) {
            this.getLog().info((CharSequence)"All files are up-to-date.");
        } else {
            StringBuilder buffer = new StringBuilder();
            for (FileState state : FileState.values()) {
                this.reportType(state, buffer);
            }
            this.getLog().info((CharSequence)buffer.toString());
        }
        if (this.clearAfterOperation) {
            this.clear();
        }
    }

    @Override
    public FileHeader getFileHeader() {
        return this.header;
    }

    @Override
    public FileHeaderTransformer getTransformer() {
        return this.transformer;
    }

    protected Map<String, List<File>> obtainFilesToProcessByCommentStyle() {
        HashMap<String, List<File>> results = new HashMap<String, List<File>>();
        for (String commentStyle : this.transformers.keySet()) {
            results.put(commentStyle, new ArrayList());
        }
        ArrayList<String> rootsList = new ArrayList<String>(this.roots.length);
        for (String string : this.roots) {
            File f = new File(string);
            if (f.isAbsolute()) {
                rootsList.add(f.getAbsolutePath());
            } else {
                f = new File(this.getProject().getBasedir(), string);
            }
            if (f.exists()) {
                this.getLog().info((CharSequence)("Will search files to update from root " + f));
                rootsList.add(f.getAbsolutePath());
                continue;
            }
            if (!this.isVerbose()) continue;
            this.getLog().info((CharSequence)("Skip not found root " + f));
        }
        HashMap<File, String[]> allFiles = new HashMap<File, String[]>();
        this.getFilesToTreateForRoots(this.includes, this.excludes, rootsList, allFiles);
        for (Map.Entry entry : allFiles.entrySet()) {
            String[] filesPath;
            File file = (File)entry.getKey();
            for (String path : filesPath = (String[])entry.getValue()) {
                String extension = FileUtils.extension((String)path);
                String commentStyle = this.extensionToCommentStyle.get(extension);
                if (StringUtils.isEmpty((CharSequence)commentStyle)) continue;
                File file2 = new File(file, path);
                List files = (List)results.get(commentStyle);
                files.add(file2);
            }
        }
        return results;
    }

    protected void checkResults(EnumMap<FileState, Set<File>> result) throws MojoFailureException {
        String message;
        List<File> files;
        Set<FileState> states = result.keySet();
        StringBuilder builder = new StringBuilder();
        if (this.isDryRun() && this.isFailOnMissingHeader() && states.contains((Object)FileState.add)) {
            files = FileUtil.orderFiles((Collection<File>)result.get((Object)FileState.add));
            builder.append("There is ").append(files.size()).append(" file(s) with no header :");
            for (File file : files) {
                builder.append("\n").append(file);
            }
        }
        if (this.isDryRun() && this.isFailOnNotUptodateHeader() && states.contains((Object)FileState.update)) {
            files = FileUtil.orderFiles((Collection<File>)result.get((Object)FileState.update));
            builder.append("\nThere is ").append(files.size()).append(" file(s) with header to update:");
            for (File file : files) {
                builder.append("\n").append(file);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(message = builder.toString()))) {
            throw new MojoFailureException(builder.toString());
        }
    }

    protected void processCommentStyle(String commentStyle, List<File> filesToTreat) throws IOException {
        License license = this.getLicense(this.getLicenseName(), true);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Process header '" + commentStyle + "'"));
            this.getLog().info((CharSequence)(" - using " + license.getDescription()));
        }
        this.transformer = this.getTransformer(commentStyle);
        this.header = this.buildDefaultFileHeader(license, this.getEncoding());
        this.processor.populateFilter();
        for (File file : filesToTreat) {
            this.processFile(file);
        }
        filesToTreat.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processFile(File file) throws IOException {
        if (this.processedFiles.contains(file)) {
            this.getLog().info((CharSequence)(" - skip already processed file " + file));
            return;
        }
        File processFile = new File(file.getAbsolutePath() + "_" + this.timestamp);
        boolean doFinalize = false;
        try {
            try {
                doFinalize = this.processFile(file, processFile);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("skip failed file : " + e.getMessage() + (e.getCause() == null ? "" : " Cause : " + e.getCause().getMessage())), (Throwable)e);
                FileState.fail.addFile(file, this.result);
                doFinalize = false;
                Object var6_5 = null;
                this.processor.reset();
                this.processedFiles.add(file);
                if (doFinalize) {
                    this.finalizeFile(file, processFile);
                    return;
                }
                FileUtil.deleteFile(processFile);
                return;
            }
            Object var6_4 = null;
            this.processor.reset();
            this.processedFiles.add(file);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.processor.reset();
            this.processedFiles.add(file);
            if (doFinalize) {
                this.finalizeFile(file, processFile);
                throw throwable;
            }
            FileUtil.deleteFile(processFile);
            throw throwable;
        }
        if (doFinalize) {
            this.finalizeFile(file, processFile);
            return;
        }
        FileUtil.deleteFile(processFile);
    }

    protected boolean processFile(File file, File processFile) throws IOException {
        String content;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)(" - process file " + file));
            this.getLog().debug((CharSequence)(" - will process into file " + processFile));
        }
        this.updateFileHeaderDescription(file);
        try {
            content = FileUtil.readAsString(file, this.getEncoding());
        }
        catch (IOException e) {
            throw new IOException("Could not obtain content of file " + file);
        }
        if (content.contains(this.ignoreTag)) {
            this.getLog().info((CharSequence)(" - ignore file (detected " + this.ignoreTag + ") " + file));
            FileState.ignore.addFile(file, this.result);
            return false;
        }
        try {
            this.processor.process(file, processFile);
        }
        catch (IllegalStateException e) {
            throw new InvalideFileHeaderException("Could not extract header on file " + file + " for reason " + e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof InvalideFileHeaderException) {
                throw (InvalideFileHeaderException)e;
            }
            throw new IOException("Could not process file " + file + " for reason " + e.getMessage());
        }
        if (this.processor.isTouched()) {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)(" - header was updated for " + file));
            }
            if (this.processor.isModified()) {
                FileState.update.addFile(file, this.result);
                return true;
            }
            FileState.uptodate.addFile(file, this.result);
            return false;
        }
        if (this.processor.isDetectHeader()) {
            throw new InvalideFileHeaderException("Could not find header end on file " + file);
        }
        this.getLog().info((CharSequence)(" - adding license header on file " + file));
        content = this.getTransformer().addHeader(this.filter.getFullHeaderContent(), content);
        if (!this.isDryRun()) {
            FileUtil.writeString(processFile, content, this.getEncoding());
        }
        FileState.add.addFile(file, this.result);
        return true;
    }

    protected void finalizeFile(File file, File processFile) throws IOException {
        if (this.isKeepBackup() && !this.isDryRun()) {
            File backupFile = FileUtil.getBackupFile(file);
            if (backupFile.exists()) {
                FileUtil.deleteFile(backupFile);
            }
            if (this.isVerbose()) {
                this.getLog().debug((CharSequence)(" - backup original file " + file));
            }
            FileUtil.renameFile(file, backupFile);
        }
        if (this.isDryRun()) {
            FileUtil.deleteFile(processFile);
        } else {
            try {
                FileUtil.renameFile(processFile, file);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
                FileUtils.copyFile((File)processFile, (File)file);
                FileUtil.deleteFile(processFile);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }

    protected void clear() {
        if (this.processedFiles != null) {
            this.processedFiles.clear();
        }
        if (this.result != null) {
            for (Set<File> fileSet : this.result.values()) {
                fileSet.clear();
            }
            this.result.clear();
        }
    }

    protected void reportType(FileState state, StringBuilder buffer) {
        String operation = state.name();
        Set<File> set = this.getFiles(state);
        if (set == null || set.isEmpty()) {
            if (this.isVerbose()) {
                buffer.append("\n * no header to ");
                buffer.append(operation);
                buffer.append(".");
            }
            return;
        }
        buffer.append("\n * ").append(operation).append(" header on ");
        buffer.append(set.size());
        if (set.size() == 1) {
            buffer.append(" file.");
        } else {
            buffer.append(" files.");
        }
        if (this.isVerbose()) {
            for (File file : set) {
                buffer.append("\n   - ").append(file);
            }
        }
    }

    protected FileHeader buildDefaultFileHeader(License license, String encoding) throws IOException {
        FileHeader defaultFileHeader = new FileHeader();
        String licenseContent = license.getHeaderContent(encoding);
        defaultFileHeader.setLicense(licenseContent);
        Integer firstYear = Integer.valueOf(this.inceptionYear);
        defaultFileHeader.setCopyrightFirstYear(firstYear);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        if (firstYear < lastYear) {
            defaultFileHeader.setCopyrightLastYear(lastYear);
        }
        defaultFileHeader.setCopyrightHolder(this.organizationName);
        return defaultFileHeader;
    }

    protected void updateFileHeaderDescription(File file) throws IOException {
        HashMap<String, Object> descriptionParameters = new HashMap<String, Object>();
        descriptionParameters.put("project", this.getProject());
        descriptionParameters.put("addSvnKeyWords", this.addSvnKeyWords);
        descriptionParameters.put("projectName", this.projectName);
        descriptionParameters.put("inceptionYear", this.inceptionYear);
        descriptionParameters.put("organizationName", this.organizationName);
        descriptionParameters.put("file", file);
        String description = this.freeMarkerHelper.renderTemplate(this.descriptionTemplate0, descriptionParameters);
        this.header.setDescription(description);
        this.filter.resetContent();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("header description : " + this.header.getDescription()));
        }
    }

    protected FileHeaderTransformer getTransformer(String transformerName) {
        if (StringUtils.isEmpty((CharSequence)transformerName)) {
            throw new IllegalArgumentException("transformerName can not be null, nor empty!");
        }
        if (this.transformers == null) {
            throw new IllegalStateException("No transformers initialized!");
        }
        FileHeaderTransformer transformer = this.transformers.get(transformerName);
        if (transformer == null) {
            throw new IllegalArgumentException("transformerName " + transformerName + " is unknow, use one this one : " + this.transformers.keySet());
        }
        return transformer;
    }

    protected String cleanHeaderConfiguration(String value, String defaultValue) {
        String resultHeader = StringUtils.isEmpty((CharSequence)value) ? defaultValue : value.replaceAll("\\s", "");
        return resultHeader;
    }

    protected Set<File> getFiles(FileState state) {
        return this.result.get((Object)state);
    }

    protected void getFilesToTreateForRoots(String[] includes, String[] excludes, List<String> roots, Map<File, String[]> files) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setIncludes(includes);
        if (excludes != null) {
            ds.setExcludes(excludes);
        }
        for (String src : roots) {
            File f = new File(src);
            if (!f.exists()) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("discovering source files in " + src));
            }
            ds.setBasedir(f);
            ds.scan();
            String[] tmp = ds.getIncludedFiles();
            if (tmp.length < 1) continue;
            ArrayList toTreate = new ArrayList();
            Collections.addAll(toTreate, tmp);
            if (toTreate.isEmpty()) continue;
            files.put(f, toTreate.toArray(new String[toTreate.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileState {
        update,
        uptodate,
        add,
        ignore,
        fail;


        public void addFile(File file, EnumMap<FileState, Set<File>> results) {
            Set<File> fileSet = results.get((Object)this);
            if (fileSet == null) {
                fileSet = new HashSet<File>();
                results.put(this, fileSet);
            }
            fileSet.add(file);
        }
    }
}

