/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jpox;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jpox.AbstractJpoxMojo;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JpoxEnhancerMojo
extends AbstractJpoxMojo {
    private static final String TOOL_NAME_JPOX_ENHANCER = "org.jpox.enhancer.JPOXEnhancer";

    protected void executeJpoxTool(List pluginArtifacts, URL log4jProperties, List files) throws CommandLineException, MojoExecutionException {
        this.enhance(pluginArtifacts, log4jProperties, files);
    }

    private void enhance(List pluginArtifacts, URL log4jProperties, List files) throws CommandLineException, MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it = this.getUniqueClasspathElements().iterator();
        while (it.hasNext()) {
            cpBuffer.append((String)it.next());
            if (!it.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        it = pluginArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                cpBuffer.append(File.pathSeparator).append(artifact.getFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        cl.createArgument().setValue("-cp");
        cl.createArgument().setValue(cpBuffer.toString());
        cl.createArgument().setValue("-Dlog4j.configuration=" + log4jProperties);
        cl.createArgument().setValue(TOOL_NAME_JPOX_ENHANCER);
        cl.createArgument().setValue("-v");
        it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            cl.createArgument().setValue(file.getAbsolutePath());
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLog().debug((CharSequence)"Executing command line:");
        this.getLog().debug((CharSequence)cl.toString());
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        this.getLog().debug((CharSequence)("Exit code: " + exitCode));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().debug((CharSequence)" Standard output from the JPox enhancer tool:");
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().info((CharSequence)stdout.getOutput());
        this.getLog().debug((CharSequence)"--------------------");
        String stream = stderr.getOutput();
        if (stream.trim().length() > 0) {
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)" Standard error from the JPox enhancer tool:");
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)stderr.getOutput());
            this.getLog().error((CharSequence)"--------------------");
        }
        if (exitCode != 0) {
            throw new MojoExecutionException("The JPox enhancer tool exited with a non-null exit code.");
        }
    }

    protected String getToolName() {
        return TOOL_NAME_JPOX_ENHANCER;
    }
}

