/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jdepend;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.mojo.jdepend.ReportGenerator;
import org.codehaus.mojo.jdepend.objects.CyclePackage;
import org.codehaus.mojo.jdepend.objects.JDPackage;
import org.codehaus.mojo.jdepend.objects.Stats;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDependXMLReportParser
extends DefaultHandler {
    protected List<JDPackage> packages;
    protected JDPackage jdpackage;
    protected Stats stats;
    protected StringBuffer buffer = null;
    protected Stack<String> stack;
    protected List<CyclePackage> cycles;
    protected CyclePackage cyclePackage;
    ReportGenerator report;
    private boolean errFlag = false;

    public JDependXMLReportParser(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this.stack = new Stack();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(xmlFile, (DefaultHandler)this);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        this.stack.push(qName);
        this.buffer = new StringBuffer();
        if (qName.equals("Packages")) {
            this.packages = new ArrayList<JDPackage>();
        } else if (qName.equals("Package")) {
            if (this.isParentElement("Packages")) {
                this.jdpackage = new JDPackage();
                if (attrs != null) {
                    this.jdpackage.setPackageName(attrs.getValue(0));
                }
            } else if (this.isParentElement("Cycles")) {
                this.cyclePackage = new CyclePackage();
                if (attrs != null) {
                    this.cyclePackage.setName(attrs.getValue(0));
                }
            }
        } else if (qName.equals("Stats")) {
            this.stats = new Stats();
        } else if (qName.equals("Cycles")) {
            this.cycles = new ArrayList<CyclePackage>();
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        String elementValue;
        String string = elementValue = this.buffer != null ? this.buffer.toString().trim() : null;
        if (qName.equals("Package")) {
            if (this.isParentElement("Packages")) {
                if (!this.errFlag) {
                    this.jdpackage.setStats(this.stats);
                    this.packages.add(this.jdpackage);
                }
                this.errFlag = false;
            } else if (this.isParentElement("DependsUpon")) {
                this.jdpackage.addDependsUpon(elementValue);
            } else if (this.isParentElement("UsedBy")) {
                this.jdpackage.addUsedBy(elementValue);
            } else if (this.isParentElement("Package")) {
                this.cyclePackage.addPackageList(elementValue);
            } else if (this.isParentElement("Cycles")) {
                this.cycles.add(this.cyclePackage);
            }
        } else if (qName.equals("TotalClasses")) {
            this.stats.setTotalClasses(elementValue);
        } else if (qName.equals("ConcreteClasses")) {
            if (this.isParentElement("Stats")) {
                this.stats.setConcreteClasses(elementValue);
            }
        } else if (qName.equals("AbstractClasses")) {
            if (this.isParentElement("Stats")) {
                this.stats.setAbstractClasses(elementValue);
            }
        } else if (qName.equals("Ca")) {
            this.stats.setCa(elementValue);
        } else if (qName.equals("Ce")) {
            this.stats.setCe(elementValue);
        } else if (qName.equals("A")) {
            this.stats.setA(elementValue);
        } else if (qName.equals("I")) {
            this.stats.setI(elementValue);
        } else if (qName.equals("D")) {
            this.stats.setD(elementValue);
        } else if (qName.equals("V")) {
            this.stats.setV(elementValue);
        } else if (qName.equals("Class")) {
            if (this.isParentElement("AbstractClasses")) {
                this.jdpackage.addAbstractClasses(elementValue);
            } else if (this.isParentElement("ConcreteClasses")) {
                this.jdpackage.addConcreteClasses(elementValue);
            }
        } else if (qName.equals("error") && this.isParentElement("Package")) {
            this.errFlag = true;
        }
        if (this.stack.size() != 0) {
            this.stack.pop();
        }
        this.buffer = null;
    }

    @Override
    public void characters(char[] buff, int offset, int len) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(buff, offset, len);
        }
    }

    public List<JDPackage> getPackages() {
        return this.packages;
    }

    public Stats getStats() {
        return this.stats;
    }

    private int getParentIndex() {
        int parentIndex = 0;
        parentIndex = this.stack.size() - 2;
        return parentIndex;
    }

    private boolean isParentElement(String parentElement) {
        boolean isParent = false;
        isParent = ((String)this.stack.get(this.getParentIndex())).toString().equals(parentElement);
        return isParent;
    }
}

