/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jboss.AbstractJBossServerMojo;
import org.codehaus.plexus.util.FileUtils;

public class HardUnDeployMojo
extends AbstractJBossServerMojo {
    protected File[] fileNames;
    protected File fileName;

    public void execute() throws MojoExecutionException {
        this.checkConfig();
        if (this.fileNames == null || this.fileNames.length == 0) {
            this.fileNames = new File[1];
            this.fileNames[0] = this.fileName;
        }
        for (int i = 0; i < this.fileNames.length; ++i) {
            File nextFile = new File(this.jbossHome + "/server/" + this.serverName + "/deploy/" + this.fileNames[i].getName());
            this.getLog().debug((CharSequence)("Undeploy file: " + nextFile.getName()));
            if (!nextFile.exists()) {
                this.getLog().info((CharSequence)("File " + nextFile.getAbsolutePath() + " doesn't exist!"));
                return;
            }
            if (nextFile.isFile()) {
                if (nextFile.delete()) {
                    this.getLog().info((CharSequence)("File " + nextFile.getName() + " undeployed."));
                    continue;
                }
                this.getLog().warn((CharSequence)("Unable to delete file: " + nextFile));
                continue;
            }
            if (!nextFile.isDirectory()) continue;
            try {
                FileUtils.deleteDirectory((File)nextFile);
                this.getLog().info((CharSequence)("Directory " + nextFile.getName() + " undeployed."));
                continue;
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to delete directory: " + nextFile));
                this.getLog().warn((CharSequence)e.getMessage());
            }
        }
    }
}

