/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.text.SimpleDateFormat;
import java.util.ResourceBundle;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.ChartUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public final class SummaryGCChartSource
implements ChartSource {
    private GCSamples samples;

    public SummaryGCChartSource(GCSamples samples) {
        this.samples = samples;
    }

    public boolean isEnabled(ReportConfig config) {
        return config.isShowgc() && config.isShowsummary() && this.samples.getSampleCount() > 0;
    }

    public String getFileName(ReportConfig config) {
        return "gc-" + config.getId();
    }

    public JFreeChart getChart(ResourceBundle bundle, ReportConfig config) {
        String beforeLabel = bundle.getString("chronos.label.gc.before");
        String afterLabel = bundle.getString("chronos.label.gc.after");
        TimeSeriesCollection dataset1 = new TimeSeriesCollection();
        TimeSeries heapBeforeSeries = new TimeSeries((Comparable)((Object)beforeLabel), Millisecond.class);
        this.samples.extractHeapBefore(heapBeforeSeries);
        TimeSeries heapAfterSeries = new TimeSeries((Comparable)((Object)afterLabel), Millisecond.class);
        this.samples.extractHeapAfter(heapAfterSeries);
        dataset1.addSeries(heapBeforeSeries);
        dataset1.addSeries(heapAfterSeries);
        TimeSeriesCollection dataset = dataset1;
        String title = bundle.getString("chronos.label.gc");
        String timeLabel = bundle.getString("chronos.label.gc.time");
        String valueLabel = bundle.getString("chronos.label.gc.mem");
        JFreeChart chart = ChartUtil.createTimeSeriesChart((XYDataset)dataset, title, timeLabel, valueLabel);
        ChartUtil.setupXYPlot(chart, new SimpleDateFormat("HH:mm:ss"));
        return chart;
    }
}

