/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class SignatureChecker
extends ClassFileVisitor {
    public static final String ANNOTATION_FQN = "org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement";
    public static final String PREVIOUS_ANNOTATION_FQN = "org.jvnet.animal_sniffer.IgnoreJRERequirement";
    private final Map<String, Clazz> classes;
    private final Logger logger;
    private final List<MatchRule> ignoredPackageRules;
    private final Set<String> ignoredPackages;
    private final Set<String> ignoredOuterClassesOrMethods = new HashSet<String>();
    private boolean hadError = false;
    private List<File> sourcePath;
    private Collection<String> annotationDescriptors;

    public static void main(String[] args) throws Exception {
        HashSet<String> ignoredPackages = new HashSet<String>();
        ignoredPackages.add("org.jvnet.animal_sniffer.*");
        ignoredPackages.add("org.codehaus.mojo.animal_sniffer.*");
        ignoredPackages.add("org.objectweb.*");
        new SignatureChecker(new FileInputStream("signature"), ignoredPackages, (Logger)new PrintWriterLogger(System.out)).process(new File("target/classes"));
    }

    public SignatureChecker(InputStream in, Set<String> ignoredPackages, Logger logger) throws IOException {
        this(SignatureChecker.loadClasses(in), ignoredPackages, logger);
    }

    public SignatureChecker(Map<String, Clazz> classes, Set<String> ignoredPackages, Logger logger) throws IOException {
        this.classes = classes;
        this.ignoredPackages = new HashSet<String>();
        this.ignoredPackageRules = new LinkedList<MatchRule>();
        for (String wildcard : ignoredPackages) {
            if (wildcard.indexOf(42) == -1 && wildcard.indexOf(63) == -1) {
                this.ignoredPackages.add(wildcard.replace('.', '/'));
                continue;
            }
            this.ignoredPackageRules.add(this.newMatchRule(wildcard.replace('.', '/')));
        }
        this.annotationDescriptors = new HashSet<String>();
        this.annotationDescriptors.add(SignatureChecker.toAnnotationDescriptor(ANNOTATION_FQN));
        this.annotationDescriptors.add(SignatureChecker.toAnnotationDescriptor(PREVIOUS_ANNOTATION_FQN));
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Clazz> loadClasses(InputStream in) throws IOException {
        HashMap<String, Clazz> classes = new HashMap<String, Clazz>();
        try (ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(in));){
            while (true) {
                Clazz c;
                if ((c = (Clazz)ois.readObject()) == null) {
                    HashMap<String, Clazz> hashMap = classes;
                    return hashMap;
                }
                classes.put(c.getName(), c);
            }
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public void setSourcePath(List<File> sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setAnnotationTypes(Collection<String> annotationTypes) {
        this.annotationDescriptors.clear();
        for (String annotationType : annotationTypes) {
            this.annotationDescriptors.add(SignatureChecker.toAnnotationDescriptor(annotationType));
        }
    }

    @Override
    protected void process(String name, InputStream image) throws IOException {
        ClassReader cr = new ClassReader(image);
        try {
            cr.accept((ClassVisitor)new CheckingVisitor(name), 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Bad class file " + name);
            throw new IOException("Bad class file " + name, e);
        }
    }

    private MatchRule newMatchRule(String matcher) {
        int i = matcher.indexOf(42);
        if (i == -1) {
            return new ExactMatchRule(matcher);
        }
        if (i == matcher.length() - 1) {
            return new PrefixMatchRule(matcher.substring(0, i));
        }
        return new RegexMatchRule(RegexUtils.compileWildcard(matcher));
    }

    public boolean isSignatureBroken() {
        return this.hadError;
    }

    static String toSourceForm(String type, String sig) {
        int rparen;
        String sourceType = SignatureChecker.toSourceType(type);
        if (sig == null) {
            return sourceType;
        }
        int hash = sig.indexOf(35);
        if (hash != -1) {
            return SignatureChecker.toSourceType(CharBuffer.wrap(sig, hash + 1, sig.length())) + " " + sourceType + "." + sig.substring(0, hash);
        }
        int lparen = sig.indexOf(40);
        if (lparen != -1 && (rparen = sig.indexOf(41)) != -1) {
            StringBuilder b = new StringBuilder();
            String returnType = sig.substring(rparen + 1);
            if (returnType.equals("V")) {
                b.append("void");
            } else {
                b.append(SignatureChecker.toSourceType(CharBuffer.wrap(returnType)));
            }
            b.append(' ');
            b.append(sourceType);
            b.append('.');
            b.append(sig.substring(0, lparen));
            b.append('(');
            boolean first = true;
            CharBuffer args = CharBuffer.wrap(sig, lparen + 1, rparen);
            while (args.hasRemaining()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(SignatureChecker.toSourceType(args));
            }
            b.append(')');
            return b.toString();
        }
        return "{" + type + ":" + sig + "}";
    }

    static String toAnnotationDescriptor(String classFqn) {
        return "L" + SignatureChecker.fromSourceType(classFqn) + ";";
    }

    private static String toSourceType(CharBuffer type) {
        switch (type.get()) {
            case 'L': {
                for (int i = type.position(); i < type.limit(); ++i) {
                    if (type.get(i) != ';') continue;
                    String text = type.subSequence(0, i - type.position()).toString();
                    type.position(i + 1);
                    return SignatureChecker.toSourceType(text);
                }
                return "{" + type + "}";
            }
            case '[': {
                return SignatureChecker.toSourceType(type) + "[]";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        return "{" + type + "}";
    }

    private static String toSourceType(String text) {
        return text.replaceFirst("^java/lang/([^/]+)$", "$1").replace('/', '.').replace('$', '.');
    }

    private static String fromSourceType(String text) {
        return text.replace('.', '/').replace('.', '$');
    }

    private static interface MatchRule {
        public boolean matches(String var1);
    }

    private class CheckingVisitor
    extends ClassVisitor {
        private final Set<String> ignoredPackageCache;
        private String packagePrefix;
        private int line;
        private String currentFieldName;
        private String name;
        private String internalName;
        private boolean ignoreClass;

        public CheckingVisitor(String name) {
            super(589824);
            this.currentFieldName = null;
            this.ignoreClass = false;
            this.ignoredPackageCache = new HashSet<String>(50 * SignatureChecker.this.ignoredPackageRules.size());
            this.name = name;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.internalName = name;
            this.packagePrefix = name.substring(0, name.lastIndexOf(47) + 1);
        }

        public void visitSource(String source, String debug) {
            for (File root : SignatureChecker.this.sourcePath) {
                File s = new File(root, this.packagePrefix + source);
                if (!s.isFile()) continue;
                this.name = s.getAbsolutePath();
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            if (SignatureChecker.this.ignoredOuterClassesOrMethods.contains(owner) || name != null && SignatureChecker.this.ignoredOuterClassesOrMethods.contains(owner + "#" + name + desc)) {
                this.ignoreClass = true;
            }
        }

        public boolean isIgnoreAnnotation(String desc) {
            for (String annoDesc : SignatureChecker.this.annotationDescriptors) {
                if (!desc.equals(annoDesc)) continue;
                return true;
            }
            return false;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.isIgnoreAnnotation(desc)) {
                this.ignoreClass = true;
                SignatureChecker.this.ignoredOuterClassesOrMethods.add(this.internalName);
            }
            return super.visitAnnotation(desc, visible);
        }

        public FieldVisitor visitField(int access, final String name, final String descriptor, String signature, Object value) {
            return new FieldVisitor(589824){
                boolean ignoreError;
                {
                    super(arg0);
                    this.ignoreError = CheckingVisitor.this.ignoreClass;
                }

                public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                    if (CheckingVisitor.this.isIgnoreAnnotation(annoDesc)) {
                        this.ignoreError = true;
                    }
                    return super.visitAnnotation(annoDesc, visible);
                }

                public void visitEnd() {
                    String fieldNamePrefix = CheckingVisitor.this.internalName.contains("$") ? CheckingVisitor.this.internalName.substring(CheckingVisitor.this.internalName.lastIndexOf(47) + 1) + '.' : "";
                    CheckingVisitor.this.currentFieldName = fieldNamePrefix + name;
                    CheckingVisitor.this.checkType(Type.getType((String)descriptor), this.ignoreError);
                    CheckingVisitor.this.currentFieldName = null;
                }
            };
        }

        public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
            this.line = 0;
            return new MethodVisitor(589824){
                boolean ignoreError;
                Label label;
                Map<Label, Set<String>> exceptions;
                private static final String LAMBDA_METAFACTORY = "java/lang/invoke/LambdaMetafactory";
                {
                    super(arg0);
                    this.ignoreError = CheckingVisitor.this.ignoreClass;
                    this.label = null;
                    this.exceptions = new HashMap<Label, Set<String>>();
                }

                public void visitEnd() {
                    CheckingVisitor.this.checkType(Type.getReturnType((String)desc), this.ignoreError);
                }

                public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                    if (CheckingVisitor.this.isIgnoreAnnotation(annoDesc)) {
                        this.ignoreError = true;
                        SignatureChecker.this.ignoredOuterClassesOrMethods.add(CheckingVisitor.this.internalName + "#" + name + desc);
                    }
                    return super.visitAnnotation(annoDesc, visible);
                }

                public void visitInvokeDynamicInsn(String name2, String desc2, Handle bsm, Object ... bsmArgs) {
                    if (LAMBDA_METAFACTORY.equals(bsm.getOwner()) && ("metafactory".equals(bsm.getName()) || "altMetafactory".equals(bsm.getName()))) {
                        Handle methodHandle = (Handle)bsmArgs[1];
                        CheckingVisitor.this.check(methodHandle.getOwner(), methodHandle.getName() + methodHandle.getDesc(), this.ignoreError);
                        CheckingVisitor.this.checkType(Type.getReturnType((String)desc2), this.ignoreError);
                    }
                }

                public void visitMethodInsn(int opcode, String owner, String name2, String desc2, boolean itf) {
                    CheckingVisitor.this.checkType(Type.getReturnType((String)desc2), this.ignoreError);
                    CheckingVisitor.this.check(owner, name2 + desc2, this.ignoreError);
                }

                public void visitTypeInsn(int opcode, String type) {
                    CheckingVisitor.this.checkType(type, this.ignoreError);
                }

                public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                    CheckingVisitor.this.check(owner, name2 + '#' + desc2, this.ignoreError);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    if (type != null) {
                        Set exceptionTypes = this.exceptions.computeIfAbsent(handler, k -> new HashSet());
                        exceptionTypes.add(type);
                    }
                }

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    Set<String> exceptionTypes = this.exceptions.remove(this.label);
                    if (exceptionTypes != null) {
                        for (String exceptionType : exceptionTypes) {
                            CheckingVisitor.this.checkType(exceptionType, this.ignoreError);
                        }
                        for (int i = 0; i < nStack; ++i) {
                            Object obj = stack[i];
                            if (!(obj instanceof String) || exceptionTypes.contains(obj)) continue;
                            CheckingVisitor.this.checkType(obj.toString(), this.ignoreError);
                        }
                    }
                }

                public void visitLineNumber(int line, Label start) {
                    CheckingVisitor.this.line = line;
                }

                public void visitLabel(Label label) {
                    this.label = label;
                }
            };
        }

        private void checkType(Type asmType, boolean ignoreError) {
            if (asmType == null) {
                return;
            }
            if (asmType.getSort() == 10) {
                this.checkType(asmType.getInternalName(), ignoreError);
            }
            if (asmType.getSort() == 9) {
                this.checkType(asmType.getElementType(), ignoreError);
            }
        }

        private void checkType(String type, boolean ignoreError) {
            if (this.shouldBeIgnored(type, ignoreError)) {
                return;
            }
            if (type.charAt(0) == '[') {
                return;
            }
            Clazz sigs = (Clazz)SignatureChecker.this.classes.get(type);
            if (sigs == null) {
                this.error(type, null);
            }
        }

        private void check(String owner, String sig, boolean ignoreError) {
            if (this.shouldBeIgnored(owner, ignoreError)) {
                return;
            }
            if (this.find((Clazz)SignatureChecker.this.classes.get(owner), sig)) {
                return;
            }
            this.error(owner, sig);
        }

        private boolean shouldBeIgnored(String type, boolean ignoreError) {
            if (ignoreError) {
                return true;
            }
            if (type.charAt(0) == '[') {
                return true;
            }
            if (SignatureChecker.this.ignoredPackages.contains(type) || this.ignoredPackageCache.contains(type)) {
                return true;
            }
            for (MatchRule rule : SignatureChecker.this.ignoredPackageRules) {
                if (!rule.matches(type)) continue;
                this.ignoredPackageCache.add(type);
                return true;
            }
            return false;
        }

        private boolean find(Clazz c, String sig) {
            if (c == null) {
                return false;
            }
            if (c.getSignatures().contains(sig)) {
                return true;
            }
            if (sig.startsWith("<")) {
                return false;
            }
            if (this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperClass()), sig)) {
                return true;
            }
            if (c.getSuperInterfaces() != null) {
                for (int i = 0; i < c.getSuperInterfaces().length; ++i) {
                    if (!this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperInterfaces()[i]), sig)) continue;
                    return true;
                }
            }
            return false;
        }

        private void error(String type, String sig) {
            SignatureChecker.this.hadError = true;
            String location = "";
            if (this.currentFieldName != null) {
                location = ": Field " + this.currentFieldName;
            } else if (this.line > 0) {
                location = ":" + this.line;
            }
            SignatureChecker.this.logger.error(this.name + location + ": Undefined reference: " + SignatureChecker.toSourceForm(type, sig));
        }
    }

    private static class ExactMatchRule
    implements MatchRule {
        private final String match;

        public ExactMatchRule(String match) {
            this.match = match;
        }

        @Override
        public boolean matches(String text) {
            return this.match.equals(text);
        }
    }

    private static class PrefixMatchRule
    implements MatchRule {
        private final String prefix;

        public PrefixMatchRule(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean matches(String text) {
            return text.startsWith(this.prefix);
        }
    }

    private static class RegexMatchRule
    implements MatchRule {
        private final Pattern regex;

        public RegexMatchRule(Pattern regex) {
            this.regex = regex;
        }

        @Override
        public boolean matches(String text) {
            return this.regex.matcher(text).matches();
        }
    }
}

