/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SignatureChecker
extends ClassFileVisitor {
    private final Map classes = new HashMap();
    private final Logger logger;
    private final List ignoredPackageRules;
    private final Set ignoredPackages;
    private final Set ignoredOuterClassesOrMethods = new HashSet();
    private boolean hadError = false;
    private List sourcePath;

    public static void main(String[] args) throws Exception {
        HashSet<String> ignoredPackages = new HashSet<String>();
        ignoredPackages.add("org.jvnet.animal_sniffer.*");
        ignoredPackages.add("org.codehaus.mojo.animal_sniffer.*");
        ignoredPackages.add("org.objectweb.*");
        new SignatureChecker(new FileInputStream("signature"), ignoredPackages, new PrintWriterLogger(System.out)).process(new File("target/classes"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureChecker(InputStream in, Set ignoredPackages, Logger logger) throws IOException {
        this.ignoredPackages = new HashSet();
        this.ignoredPackageRules = new LinkedList();
        for (String wildcard : ignoredPackages) {
            if (wildcard.indexOf(42) == -1 && wildcard.indexOf(63) == -1) {
                this.ignoredPackages.add(wildcard.replace('.', '/'));
                continue;
            }
            this.ignoredPackageRules.add(this.newMatchRule(wildcard.replace('.', '/')));
        }
        this.logger = logger;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new GZIPInputStream(in));
            while (true) {
                Clazz c;
                if ((c = (Clazz)ois.readObject()) == null) {
                    return;
                }
                this.classes.put(c.getName(), c);
                continue;
                break;
            }
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setSourcePath(List sourcePath) {
        this.sourcePath = sourcePath;
    }

    protected void process(String name, InputStream image) throws IOException {
        ClassReader cr = new ClassReader(image);
        try {
            cr.accept((ClassVisitor)new CheckingVisitor(name), 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logger.error("Bad class file " + name);
            IOException ioException = new IOException("Bad class file " + name);
            ioException.initCause(e);
            throw ioException;
        }
    }

    private MatchRule newMatchRule(String matcher) {
        int i = matcher.indexOf(42);
        if (i == -1) {
            return new ExactMatchRule(matcher);
        }
        if (i == matcher.length() - 1) {
            return new PrefixMatchRule(matcher.substring(0, i));
        }
        return new RegexMatchRule(RegexUtils.compileWildcard(matcher));
    }

    public boolean isSignatureBroken() {
        return this.hadError;
    }

    static String toSourceForm(String type, String sig) {
        int rparen;
        String sourceType = SignatureChecker.toSourceType(type);
        if (sig == null) {
            return sourceType;
        }
        int hash = sig.indexOf(35);
        if (hash != -1) {
            return SignatureChecker.toSourceType(CharBuffer.wrap(sig, hash + 1, sig.length())) + " " + sourceType + "." + sig.substring(0, hash);
        }
        int lparen = sig.indexOf(40);
        if (lparen != -1 && (rparen = sig.indexOf(41)) != -1) {
            StringBuffer b = new StringBuffer();
            String returnType = sig.substring(rparen + 1);
            if (returnType.equals("V")) {
                b.append("void");
            } else {
                b.append(SignatureChecker.toSourceType(CharBuffer.wrap(returnType)));
            }
            b.append(' ');
            b.append(sourceType);
            b.append('.');
            b.append(sig.substring(0, lparen));
            b.append('(');
            boolean first = true;
            CharBuffer args = CharBuffer.wrap(sig, lparen + 1, rparen);
            while (args.hasRemaining()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(SignatureChecker.toSourceType(args));
            }
            b.append(')');
            return b.toString();
        }
        return "{" + type + ":" + sig + "}";
    }

    private static String toSourceType(CharBuffer type) {
        switch (type.get()) {
            case 'L': {
                for (int i = type.position(); i < type.limit(); ++i) {
                    if (type.get(i) != ';') continue;
                    String text = type.subSequence(0, i - type.position()).toString();
                    type.position(i + 1);
                    return SignatureChecker.toSourceType(text);
                }
                return "{" + type + "}";
            }
            case '[': {
                return SignatureChecker.toSourceType(type) + "[]";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        return "{" + type + "}";
    }

    private static String toSourceType(String text) {
        return text.replaceFirst("^java/lang/([^/]+)$", "$1").replace('/', '.').replace('$', '.');
    }

    private class CheckingVisitor
    extends ClassVisitor {
        private final Set ignoredPackageCache;
        private String packagePrefix;
        private int line;
        private String name;
        private String internalName;
        private boolean ignoreClass;

        public CheckingVisitor(String name) {
            super(262144);
            this.ignoreClass = false;
            this.ignoredPackageCache = new HashSet(50 * SignatureChecker.this.ignoredPackageRules.size());
            this.name = name;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.internalName = name;
            this.packagePrefix = name.substring(0, name.lastIndexOf(47) + 1);
        }

        public void visitSource(String source, String debug) {
            for (File root : SignatureChecker.this.sourcePath) {
                File s = new File(root, this.packagePrefix + source);
                if (!s.isFile()) continue;
                this.name = s.getAbsolutePath();
            }
        }

        public void visitOuterClass(String owner, String name, String desc) {
            if (SignatureChecker.this.ignoredOuterClassesOrMethods.contains(owner) || name != null && SignatureChecker.this.ignoredOuterClassesOrMethods.contains(owner + "#" + name + desc)) {
                this.ignoreClass = true;
            }
        }

        public boolean isIgnoreAnnotation(String desc) {
            return desc.equals("Lorg/jvnet/animal_sniffer/IgnoreJRERequirement;") || desc.equals("Lorg/codehaus/mojo/animal_sniffer/IgnoreJRERequirement;");
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.isIgnoreAnnotation(desc)) {
                this.ignoreClass = true;
                SignatureChecker.this.ignoredOuterClassesOrMethods.add(this.internalName);
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
            return new MethodVisitor(262144){
                boolean ignoreError;
                {
                    super(x0);
                    this.ignoreError = CheckingVisitor.this.ignoreClass;
                }

                public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                    if (CheckingVisitor.this.isIgnoreAnnotation(annoDesc)) {
                        this.ignoreError = true;
                        SignatureChecker.this.ignoredOuterClassesOrMethods.add(CheckingVisitor.this.internalName + "#" + name + desc);
                    }
                    return super.visitAnnotation(annoDesc, visible);
                }

                public void visitMethodInsn(int opcode, String owner, String name2, String desc2) {
                    this.check(owner, name2 + desc2);
                }

                public void visitTypeInsn(int opcode, String type) {
                    if (this.shouldBeIgnored(type)) {
                        return;
                    }
                    if (type.charAt(0) == '[') {
                        return;
                    }
                    Clazz sigs = (Clazz)SignatureChecker.this.classes.get(type);
                    if (sigs == null) {
                        CheckingVisitor.this.error(type, null);
                    }
                }

                public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                    this.check(owner, name2 + '#' + desc2);
                }

                public void visitLineNumber(int line, Label start) {
                    CheckingVisitor.this.line = line;
                }

                private void check(String owner, String sig) {
                    if (this.shouldBeIgnored(owner)) {
                        return;
                    }
                    if (CheckingVisitor.this.find((Clazz)SignatureChecker.this.classes.get(owner), sig)) {
                        return;
                    }
                    CheckingVisitor.this.error(owner, sig);
                }

                private boolean shouldBeIgnored(String type) {
                    if (this.ignoreError) {
                        return true;
                    }
                    if (type.charAt(0) == '[') {
                        return true;
                    }
                    if (SignatureChecker.this.ignoredPackages.contains(type) || CheckingVisitor.this.ignoredPackageCache.contains(type)) {
                        return true;
                    }
                    for (MatchRule rule : SignatureChecker.this.ignoredPackageRules) {
                        if (!rule.matches(type)) continue;
                        CheckingVisitor.this.ignoredPackageCache.add(type);
                        return true;
                    }
                    return false;
                }
            };
        }

        private boolean find(Clazz c, String sig) {
            if (c == null) {
                return false;
            }
            if (c.getSignatures().contains(sig)) {
                return true;
            }
            if (sig.startsWith("<")) {
                return false;
            }
            if (this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperClass()), sig)) {
                return true;
            }
            if (c.getSuperInterfaces() != null) {
                for (int i = 0; i < c.getSuperInterfaces().length; ++i) {
                    if (!this.find((Clazz)SignatureChecker.this.classes.get(c.getSuperInterfaces()[i]), sig)) continue;
                    return true;
                }
            }
            return false;
        }

        private void error(String type, String sig) {
            SignatureChecker.this.hadError = true;
            SignatureChecker.this.logger.error(this.name + (this.line > 0 ? ":" + this.line : "") + ": Undefined reference: " + SignatureChecker.toSourceForm(type, sig));
        }
    }

    private static class RegexMatchRule
    implements MatchRule {
        private final Pattern regex;

        public RegexMatchRule(Pattern regex) {
            this.regex = regex;
        }

        public boolean matches(String text) {
            return this.regex.matcher(text).matches();
        }
    }

    private static class ExactMatchRule
    implements MatchRule {
        private final String match;

        public ExactMatchRule(String match) {
            this.match = match;
        }

        public boolean matches(String text) {
            return this.match.equals(text);
        }
    }

    private static class PrefixMatchRule
    implements MatchRule {
        private final String prefix;

        public PrefixMatchRule(String prefix) {
            this.prefix = prefix;
        }

        public boolean matches(String text) {
            return text.startsWith(this.prefix);
        }
    }

    private static interface MatchRule {
        public boolean matches(String var1);
    }
}

