/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console.file;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.file.AbstractFileField;
import com.izforge.izpack.panels.userinput.field.file.FileFieldView;
import com.izforge.izpack.util.Console;

public class AbstractConsoleFileField
extends ConsoleField {
    private final FileFieldView view;

    public AbstractConsoleFileField(FileFieldView view, Console console, Prompt prompt) {
        super(view.getField(), console, prompt);
        this.view = view;
    }

    @Override
    public boolean display() {
        boolean result = false;
        this.printDescription();
        AbstractFileField field = this.getField();
        String initialValue = field.getInitialValue();
        String label = field.getLabel();
        if (label == null) {
            label = "";
        }
        if (this.isReadonly()) {
            this.println(label + (label.isEmpty() ? " " : "") + "[" + initialValue + "]");
            field.setValue(initialValue);
            result = true;
        } else {
            String prompt = label + (label.isEmpty() ? " " : "") + "[" + (initialValue != null ? initialValue : "") + "] ";
            String path = this.getConsole().promptLocation(prompt, "");
            if (path != null) {
                if ((path = path.trim()).isEmpty()) {
                    path = initialValue;
                }
                if (path != null && !path.isEmpty()) {
                    path = field.getAbsoluteFile(path).toString();
                }
                if (this.view.validate(path)) {
                    field.setValue(path);
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    public AbstractFileField getField() {
        return (AbstractFileField)super.getField();
    }
}

