/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.treepacks;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PackHelper;
import com.izforge.izpack.installer.web.WebAccessor;
import com.izforge.izpack.panels.packs.PacksModel;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.izforge.izpack.panels.treepacks.CheckBoxNode;
import com.izforge.izpack.panels.treepacks.CheckBoxNodeRenderer;
import com.izforge.izpack.panels.treepacks.CheckTreeController;
import com.izforge.izpack.util.IoHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.IOUtils;

public class TreePacksPanel
extends IzPanel {
    private static final long serialVersionUID = 5684716698930628262L;
    private static final transient Logger logger = Logger.getLogger(TreePacksPanel.class.getName());
    protected JLabel requiredSpaceLabel;
    protected JLabel freeSpaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTree packsTree;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Messages messages;
    private final Map<String, Pack> namesToPacks;
    private final Map<Pack, Integer> packsToRowNumbers;
    private final Map<String, List<String>> treeData;
    private CheckTreeController checkTreeController;
    private HashMap<String, CheckBoxNode> nameToCheckBox = new HashMap();

    public TreePacksPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, Locales locales, RulesEngine rules) {
        super(panel, parent, installData, resources);
        this.messages = this.getAvailableStrings(locales);
        this.packsModel = new PacksModel((InstallData)installData);
        this.namesToPacks = this.packsModel.getNameToPack();
        this.packsToRowNumbers = this.packsModel.getPacksToRowNumbers();
        this.treeData = this.createTreeData();
        this.createNormalLayout();
    }

    private void createNormalLayout() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.createLabel("PacksPanel.info", "preferences", null, null);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        this.createLabel("PacksPanel.tip", "tip", null, null);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.tableScroller = new JScrollPane();
        this.tableScroller.setColumnHeaderView(null);
        this.tableScroller.setColumnHeader(null);
        this.packsTree = this.createPacksTree(300, this.tableScroller, null, null);
        if (this.packsModel.dependenciesExist()) {
            this.dependencyArea = this.createTextArea("PacksPanel.dependencyList", null, null, null);
        }
        this.descriptionArea = this.createTextArea("PacksPanel.description", null, null, null);
        this.requiredSpaceLabel = this.createPanelWithLabel("PacksPanel.space", null, null);
        if (IoHelper.supported((String)"getFreeSpace")) {
            this.add(Box.createRigidArea(new Dimension(0, 3)));
            this.freeSpaceLabel = this.createPanelWithLabel("PacksPanel.freespace", null, null);
        }
    }

    private JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create((String)this.getString(msgId), (Icon)((Icon)this.parent.getIcons().get((Object)iconId)), (int)11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add(label);
        return label;
    }

    private JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create((String)this.getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add(panel);
        return label;
    }

    private JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.getString(msgId)));
        area.setFont(this.getControlTextFont());
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add(scroller);
        } else {
            this.add(area);
        }
        return area;
    }

    private JTree createPacksTree(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTree tree;
        this.packsTree = tree = new JTree(this.populateTreePacks(null));
        tree.setCellRenderer(new CheckBoxNodeRenderer(this));
        tree.setEditable(false);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        this.checkTreeController = new CheckTreeController(this);
        tree.addMouseListener(this.checkTreeController);
        tree.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        tree.setBackground(Color.white);
        tree.setToggleClickCount(0);
        scroller.setViewportView(tree);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.installData.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add(scroller);
        return tree;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public LocaleDatabase getLangpack() {
        return (LocaleDatabase)this.messages;
    }

    private void updateRequiredSpaceLabel() {
        if (this.requiredSpaceLabel != null) {
            this.requiredSpaceLabel.setText(Pack.toByteUnitsString((long)this.packsModel.getTotalByteSize()));
        }
    }

    private long getAvaiableBytes() {
        return IoHelper.getFreeSpace((String)IoHelper.existingParent((File)new File(this.installData.getInstallPath())).getAbsolutePath());
    }

    private void showFreeSpace() {
        if (IoHelper.supported((String)"getFreeSpace") && this.freeSpaceLabel != null) {
            String msg = null;
            long freeBytes = this.getAvaiableBytes();
            msg = freeBytes < 0L ? this.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString((long)freeBytes);
            this.freeSpaceLabel.setText(msg);
        }
    }

    public boolean isValidated() {
        this.packsModel.updatePacksToInstall();
        long freeBytes = this.getAvaiableBytes();
        if (IoHelper.supported((String)"getFreeSpace") && freeBytes >= 0L && freeBytes <= this.packsModel.getTotalByteSize()) {
            JOptionPane.showMessageDialog((Component)((Object)this), this.getString("PacksPanel.notEnoughSpace"), this.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void createInstallationRecord(IXMLElement panelRoot) {
        new PacksPanelAutomationHelper().createInstallationRecord((InstallData)this.installData, panelRoot);
    }

    private String getI18NPackName(Pack pack) {
        return PackHelper.getPackName((Pack)pack, (Messages)this.messages);
    }

    private String getI18NPackName(String name) {
        Pack pack = this.namesToPacks.get(name);
        if (pack == null) {
            return name;
        }
        return this.getI18NPackName(pack);
    }

    public void updateViewFromModel(JTree tree) {
        TreeModel model = this.packsTree.getModel();
        CheckBoxNode root = (CheckBoxNode)model.getRoot();
        this.syncCheckboxesWithModel(root);
        this.updateRequiredSpaceLabel();
        this.showFreeSpace();
        this.syncPackSizes();
        tree.treeDidChange();
    }

    private int getRowIndex(Pack pack) {
        Integer rowNumber = this.packsToRowNumbers.get(pack);
        if (rowNumber == null) {
            return -1;
        }
        return rowNumber;
    }

    private void syncCheckboxesWithModel(CheckBoxNode rootNode) {
        Enumeration<TreeNode> e = rootNode.children();
        while (e.hasMoreElements()) {
            CheckBoxNode node = (CheckBoxNode)e.nextElement();
            String nodeText = node.getId();
            Pack nodePack = this.namesToPacks.get(nodeText);
            int childRowIndex = this.getRowIndex(nodePack);
            if (childRowIndex >= 0) {
                PacksModel.CbSelectionState state = (PacksModel.CbSelectionState)((Object)this.packsModel.getValueAt(childRowIndex, 0));
                node.setEnabled(state.isSelectable());
                node.setPartial(this.packsModel.isPartiallyChecked(childRowIndex));
                node.setSelected(this.packsModel.isChecked(childRowIndex));
            }
            this.syncCheckboxesWithModel(node);
        }
    }

    public void setModelValue(CheckBoxNode checkbox) {
        String name = checkbox.getId();
        Pack pack = this.namesToPacks.get(name);
        int row = this.getRowIndex(pack);
        this.packsModel.toggleValueAt(row);
    }

    private Map<String, List<String>> createTreeData() {
        HashMap<String, List<String>> treeData = new HashMap<String, List<String>>();
        for (Pack pack : this.packsModel.getVisiblePacks()) {
            if (pack.getParent() == null) continue;
            List<String> kids = null;
            kids = treeData.containsKey(pack.getParent()) ? (List)treeData.get(pack.getParent()) : new ArrayList<String>();
            kids.add(pack.getName());
            treeData.put(pack.getParent(), kids);
        }
        return treeData;
    }

    public void updateDescriptionArea(String id) {
        if (this.descriptionArea != null) {
            Pack pack = this.namesToPacks.get(id);
            String desc = PackHelper.getPackDescription((Pack)pack, (Messages)this.messages);
            desc = this.installData.getVariables().replace(desc);
            this.descriptionArea.setText(desc);
        }
    }

    public void updateDependencyArea(String id) {
        if (this.dependencyArea != null) {
            Pack pack = this.namesToPacks.get(id);
            List dep = pack.getDependencies();
            String list = "";
            if (dep != null) {
                list = list + (this.messages == null ? "Dependencies: " : this.messages.get("PacksPanel.dependencies", new Object[0]));
            }
            for (int j = 0; dep != null && j < dep.size(); ++j) {
                String name = (String)dep.get(j);
                list = list + this.getI18NPackName(this.namesToPacks.get(name));
                if (j == dep.size() - 1) continue;
                list = list + ", ";
            }
            String excludesList = this.messages == null ? "Excludes: " : this.messages.get("PacksPanel.excludes", new Object[0]);
            int numExcludes = 0;
            int i = this.getRowIndex(pack);
            if (pack.getExcludeGroup() != null) {
                for (int q = 0; q < this.packsModel.getVisiblePacks().size(); ++q) {
                    Pack otherPack = this.packsModel.getVisiblePacks().get(q);
                    String exGroup = otherPack.getExcludeGroup();
                    if (exGroup == null || q == i || !pack.getExcludeGroup().equals(exGroup)) continue;
                    excludesList = excludesList + this.getI18NPackName(otherPack) + ", ";
                    ++numExcludes;
                }
            }
            if (dep != null) {
                excludesList = "    " + excludesList;
            }
            if (numExcludes > 0) {
                list = list + excludesList;
            }
            if (list.endsWith(", ")) {
                list = list.substring(0, list.length() - 2);
            }
            this.dependencyArea.setText(list);
        }
    }

    private TreeNode populateTreePacks(String parent) {
        if (parent == null) {
            ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>();
            for (Pack pack : this.packsModel.getVisiblePacks()) {
                if (pack.getParent() != null) continue;
                rootNodes.add(this.populateTreePacks(pack.getName()));
            }
            CheckBoxNode treeNode = new CheckBoxNode("Root", "Root", rootNodes.toArray(), true);
            return treeNode;
        }
        ArrayList<TreeNode> links = new ArrayList<TreeNode>();
        List<String> kids = this.treeData.get(parent);
        Pack pack = this.namesToPacks.get(parent);
        String translated = this.getI18NPackName(parent);
        if (kids != null) {
            for (String kidId : kids) {
                links.add(this.populateTreePacks(kidId));
            }
            CheckBoxNode checkBoxNode = new CheckBoxNode(parent, translated, links.toArray(), true);
            this.nameToCheckBox.put(checkBoxNode.getId(), checkBoxNode);
            checkBoxNode.setPack(pack);
            checkBoxNode.setTotalSize(pack.getSize());
            return checkBoxNode;
        }
        CheckBoxNode checkBoxNode = new CheckBoxNode(parent, translated, true);
        this.nameToCheckBox.put(checkBoxNode.getId(), checkBoxNode);
        checkBoxNode.setPack(pack);
        checkBoxNode.setTotalSize(pack.getSize());
        return checkBoxNode;
    }

    public void panelActivate() {
        this.packsModel.updateTable();
        this.updateViewFromModel(this.getTree());
    }

    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        boolean first = true;
        for (Pack pack : this.installData.getSelectedPacks()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            retval.append(this.getI18NPackName(pack));
        }
        return retval.toString();
    }

    public JTree getTree() {
        return this.packsTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Messages getAvailableStrings(Locales locales) {
        Messages messages = this.installData.getMessages();
        try {
            String webDir = this.installData.getInfo().getWebDirURL();
            boolean fallback = true;
            if (webDir != null) {
                InputStream langPackStream = null;
                try {
                    URL url = new URL(webDir + "/langpacks/" + "packsLang.xml" + this.installData.getLocaleISO3());
                    langPackStream = new WebAccessor(null).openInputStream(url);
                    messages = new LocaleDatabase(langPackStream, messages, locales);
                    fallback = false;
                }
                catch (Exception e) {
                    IOUtils.closeQuietly(langPackStream);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(langPackStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)langPackStream);
            }
            if (fallback) {
                messages = messages.newMessages("packsLang.xml");
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, t.toString(), t);
        }
        return messages;
    }

    private void syncPackSizes() {
        for (Pack pack : this.packsModel.getVisiblePacks()) {
            CheckBoxNode node;
            long old;
            long bytes = pack.getSize();
            if (pack.hasChildren()) {
                for (String childPackName : pack.getChildren()) {
                    Pack childPack = this.packsModel.getPack(childPackName);
                    int row = this.packsModel.getNameToRow().get(childPackName);
                    if (!this.packsModel.isChecked(row) && !this.packsModel.isPartiallyChecked(row)) continue;
                    bytes += childPack.getSize();
                }
            }
            if ((old = (node = this.nameToCheckBox.get(pack.getName())).getTotalSize()) > 0L && old != bytes) {
                node.setTotalSizeChanged(true);
            } else {
                node.setTotalSizeChanged(false);
            }
            node.setTotalSize(bytes);
        }
    }
}

