/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.simplefinish;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import java.awt.LayoutManager2;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;

public class SimpleFinishPanel
extends IzPanel {
    private static final long serialVersionUID = 3689911781942572085L;
    private UninstallDataWriter uninstallDataWriter;
    private final Log log;

    public SimpleFinishPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, UninstallDataWriter uninstallDataWriter, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.uninstallDataWriter = uninstallDataWriter;
        this.log = log;
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.installData.isInstallSuccess()) {
            this.add(LabelFactory.create((Icon)((Icon)this.parent.getIcons().get((Object)"check"))));
            this.add(IzPanelLayout.createVerticalStrut((int)5));
            JLabel jLabel = LabelFactory.create((String)this.getString("FinishPanel.success"), (Icon)((Icon)this.parent.getIcons().get((Object)"preferences")), (int)10);
            jLabel.setName(GuiId.SIMPLE_FINISH_LABEL.id);
            this.add(jLabel, "nextLine");
            this.add(IzPanelLayout.createVerticalStrut((int)5));
            if (this.uninstallDataWriter.isUninstallRequired()) {
                String path = this.translatePath(this.installData.getInfo().getUninstallerPath());
                JLabel uninstallJLabel = LabelFactory.create((String)this.getString("FinishPanel.uninst.info"), (Icon)((Icon)this.parent.getIcons().get((Object)"preferences")), (int)10);
                uninstallJLabel.setName(GuiId.SIMPLE_FINISH_UNINSTALL_LABEL.id);
                this.add(uninstallJLabel, "nextLine");
                this.add(LabelFactory.create((String)path, (Icon)((Icon)this.parent.getIcons().get((Object)"empty")), (int)10), "nextLine");
            }
        } else {
            this.add(LabelFactory.create((String)this.getString("FinishPanel.fail"), (Icon)((Icon)this.parent.getIcons().get((Object)"stop")), (int)10));
        }
        this.getLayoutHelper().completeLayout();
        this.log.informUser();
    }

    private String translatePath(String destination) {
        destination = this.installData.getVariables().replace(destination);
        return destination.replace('/', File.separatorChar);
    }
}

