/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.htmllicence;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.log.Log;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.panels.licence.AbstractLicencePanel;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLLicencePanel
extends AbstractLicencePanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = 3256728385458746416L;
    private JEditorPane textArea;
    private final JRadioButton yesRadio;
    private final JRadioButton noRadio;

    public HTMLLicencePanel(Panel panel, final InstallerFrame parent, GUIInstallData installData, Resources resources, Log log) {
        super(panel, parent, installData, (LayoutManager2)new IzPanelLayout(log), resources);
        this.add(LabelFactory.create((String)this.getString("LicencePanel.info"), (Icon)((Icon)parent.getIcons().get((Object)"history")), (int)10), "nextLine");
        try {
            this.textArea = new JEditorPane();
            this.textArea.setEditable(false);
            this.textArea.getDocument().putProperty("stream", null);
            this.textArea.addHyperlinkListener(this);
            JScrollPane scroller = new JScrollPane(this.textArea);
            this.textArea.setPage(this.loadLicence());
            ActionListener fireDefault = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton defaultButton = parent.getRootPane().getDefaultButton();
                    if (defaultButton != null && defaultButton.isEnabled()) {
                        defaultButton.doClick();
                    }
                }
            };
            this.textArea.registerKeyboardAction(fireDefault, null, KeyStroke.getKeyStroke(10, 0), 0);
            this.add(scroller, "nextLine");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        ButtonGroup group = new ButtonGroup();
        this.yesRadio = new JRadioButton(this.getString("LicencePanel.agree"), false);
        this.yesRadio.setName(GuiId.LICENCE_YES_RADIO.id);
        group.add(this.yesRadio);
        this.add(this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        this.noRadio = new JRadioButton(this.getString("LicencePanel.notagree"), true);
        this.noRadio.setName(GuiId.LICENCE_NO_RADIO.id);
        group.add(this.noRadio);
        this.add(this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        this.setInitialFocus(this.textArea);
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        try {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.textArea.setPage(e.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

