/*
 * Decompiled with CFR 0.152.
 */
package jsr166y.forkjoin;

import java.util.Comparator;
import jsr166y.forkjoin.ForkJoinWorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ops {
    private Ops() {
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalComparator(Class<T> type) {
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.compareTo(b);
            }
        };
    }

    public static <T extends Comparable<? super T>> Reducer<T> naturalMaxReducer(Class<T> type) {
        return new Reducer<T>(){

            @Override
            public T combine(T a, T b) {
                return a != null && (b == null || a.compareTo(b) >= 0) ? a : b;
            }
        };
    }

    public static <T extends Comparable<? super T>> Reducer<T> naturalMinReducer(Class<T> type) {
        return new Reducer<T>(){

            @Override
            public T combine(T a, T b) {
                return a != null && (b == null || a.compareTo(b) <= 0) ? a : b;
            }
        };
    }

    public static <T> Reducer<T> maxReducer(final Comparator<? super T> comparator) {
        return new Reducer<T>(){

            @Override
            public T combine(T a, T b) {
                return a != null && (b == null || comparator.compare(a, b) >= 0) ? a : b;
            }
        };
    }

    public static <T> Reducer<T> minReducer(final Comparator<? super T> comparator) {
        return new Reducer<T>(){

            @Override
            public T combine(T a, T b) {
                return a != null && (b == null || comparator.compare(a, b) <= 0) ? a : b;
            }
        };
    }

    public static Comparator<Object> castedComparator() {
        return RawComparator.cmp;
    }

    public static Reducer<Object> castedMaxReducer() {
        return RawMaxReducer.max;
    }

    public static Reducer<Object> castedMinReducer() {
        return RawMinReducer.min;
    }

    public static DoubleComparator naturalDoubleComparator() {
        return NaturalDoubleComparator.comparator;
    }

    public static DoubleReducer naturalDoubleMaxReducer() {
        return NaturalDoubleMaxReducer.max;
    }

    public static DoubleReducer naturalDoubleMinReducer() {
        return NaturalDoubleMinReducer.min;
    }

    public static DoubleReducer doubleMaxReducer(final DoubleComparator comparator) {
        return new DoubleReducer(){

            public double combine(double a, double b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
    }

    public static DoubleReducer doubleMinReducer(final DoubleComparator comparator) {
        return new DoubleReducer(){

            public double combine(double a, double b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
    }

    public static LongComparator naturalLongComparator() {
        return NaturalLongComparator.comparator;
    }

    public static LongReducer naturalLongMaxReducer() {
        return NaturalLongMaxReducer.max;
    }

    public static LongReducer naturalLongMinReducer() {
        return NaturalLongMinReducer.min;
    }

    public static LongReducer longMaxReducer(final LongComparator comparator) {
        return new LongReducer(){

            public long combine(long a, long b) {
                return comparator.compare(a, b) >= 0 ? a : b;
            }
        };
    }

    public static LongReducer longMinReducer(final LongComparator comparator) {
        return new LongReducer(){

            public long combine(long a, long b) {
                return comparator.compare(a, b) <= 0 ? a : b;
            }
        };
    }

    public static <T, U, V> Mapper<T, V> compoundMapper(final Mapper<? super T, ? extends U> first, final Mapper<? super U, ? extends V> second) {
        return new Mapper<T, V>(){

            @Override
            public final V map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T, V> Mapper<T, V> compoundMapper(final MapperToDouble<? super T> first, final MapperFromDouble<? extends V> second) {
        return new Mapper<T, V>(){

            @Override
            public final V map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T, V> Mapper<T, V> compoundMapper(final MapperToLong<? super T> first, final MapperFromLong<? extends V> second) {
        return new Mapper<T, V>(){

            @Override
            public final V map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T, V> MapperFromDouble<V> compoundMapper(final MapperFromDouble<? extends T> first, final Mapper<? super T, ? extends V> second) {
        return new MapperFromDouble<V>(){

            @Override
            public final V map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T, V> MapperFromLong<V> compoundMapper(final MapperFromLong<? extends T> first, final Mapper<? super T, ? extends V> second) {
        return new MapperFromLong<V>(){

            @Override
            public final V map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T, U> MapperToDouble<T> compoundMapper(final Mapper<? super T, ? extends U> first, final MapperToDouble<? super U> second) {
        return new MapperToDouble<T>(){

            @Override
            public final double map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T, U> MapperToLong<T> compoundMapper(final Mapper<? super T, ? extends U> first, final MapperToLong<? super U> second) {
        return new MapperToLong<T>(){

            @Override
            public final long map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperToDouble<T> compoundMapper(final MapperToDouble<? super T> first, final DoubleMapper second) {
        return new MapperToDouble<T>(){

            @Override
            public final double map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperToLong<T> compoundMapper(final MapperToDouble<? super T> first, final MapperFromDoubleToLong second) {
        return new MapperToLong<T>(){

            @Override
            public final long map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperToLong<T> compoundMapper(final MapperToLong<? super T> first, final LongMapper second) {
        return new MapperToLong<T>(){

            @Override
            public final long map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperToDouble<T> compoundMapper(final MapperToLong<? super T> first, final MapperFromLongToDouble second) {
        return new MapperToDouble<T>(){

            @Override
            public final double map(T t) {
                return second.map(first.map(t));
            }
        };
    }

    public static DoubleMapper compoundMapper(final DoubleMapper first, final DoubleMapper second) {
        return new DoubleMapper(){

            public final double map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static MapperFromDoubleToLong compoundMapper(final DoubleMapper first, final MapperFromDoubleToLong second) {
        return new MapperFromDoubleToLong(){

            public final long map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static MapperFromDoubleToLong compoundMapper(final MapperFromDoubleToLong first, final LongMapper second) {
        return new MapperFromDoubleToLong(){

            public final long map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperFromDouble<T> compoundMapper(final MapperFromDoubleToLong first, final MapperFromLong<? extends T> second) {
        return new MapperFromDouble<T>(){

            @Override
            public final T map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperFromLong<T> compoundMapper(final MapperFromLongToDouble first, final MapperFromDouble<? extends T> second) {
        return new MapperFromLong<T>(){

            @Override
            public final T map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static MapperFromLongToDouble compoundMapper(final LongMapper first, final MapperFromLongToDouble second) {
        return new MapperFromLongToDouble(){

            public final double map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static MapperFromLongToDouble compoundMapper(final MapperFromLongToDouble first, final DoubleMapper second) {
        return new MapperFromLongToDouble(){

            public final double map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperFromDouble<T> compoundMapper(final DoubleMapper first, final MapperFromDouble<? extends T> second) {
        return new MapperFromDouble<T>(){

            @Override
            public final T map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperFromLong<T> compoundMapper(final LongMapper first, final MapperFromLong<? extends T> second) {
        return new MapperFromLong<T>(){

            @Override
            public final T map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> DoubleMapper compoundMapper(final MapperFromDouble<? extends T> first, final MapperToDouble<? super T> second) {
        return new DoubleMapper(){

            public final double map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperFromLongToDouble compoundMapper(final MapperFromLong<? extends T> first, final MapperToDouble<? super T> second) {
        return new MapperFromLongToDouble(){

            public final double map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> MapperFromDoubleToLong compoundMapper(final MapperFromDouble<? extends T> first, final MapperToLong<? super T> second) {
        return new MapperFromDoubleToLong(){

            public final long map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> LongMapper compoundMapper(final MapperFromLong<? extends T> first, final MapperToLong<? super T> second) {
        return new LongMapper(){

            public final long map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static LongMapper compoundMapper(final LongMapper first, final LongMapper second) {
        return new LongMapper(){

            public final long map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static DoubleMapper compoundMapper(final MapperFromDoubleToLong first, final MapperFromLongToDouble second) {
        return new DoubleMapper(){

            public final double map(double t) {
                return second.map(first.map(t));
            }
        };
    }

    public static LongMapper compoundMapper(final MapperFromLongToDouble first, final MapperFromDoubleToLong second) {
        return new LongMapper(){

            public final long map(long t) {
                return second.map(first.map(t));
            }
        };
    }

    public static <T> Predicate<T> notPredicate(final Predicate<T> pred) {
        return new Predicate<T>(){

            @Override
            public final boolean evaluate(T x) {
                return !pred.evaluate(x);
            }
        };
    }

    public static DoublePredicate notPredicate(final DoublePredicate pred) {
        return new DoublePredicate(){

            public final boolean evaluate(double x) {
                return !pred.evaluate(x);
            }
        };
    }

    public static LongPredicate notPredicate(final LongPredicate pred) {
        return new LongPredicate(){

            public final boolean evaluate(long x) {
                return !pred.evaluate(x);
            }
        };
    }

    public static <S, T extends S> Predicate<T> andPredicate(final Predicate<S> first, final Predicate<? super T> second) {
        return new Predicate<T>(){

            @Override
            public final boolean evaluate(T x) {
                return first.evaluate(x) && second.evaluate(x);
            }
        };
    }

    public static <S, T extends S> Predicate<T> orPredicate(final Predicate<S> first, final Predicate<? super T> second) {
        return new Predicate<T>(){

            @Override
            public final boolean evaluate(T x) {
                return first.evaluate(x) || second.evaluate(x);
            }
        };
    }

    public static DoublePredicate andPredicate(final DoublePredicate first, final DoublePredicate second) {
        return new DoublePredicate(){

            public final boolean evaluate(double x) {
                return first.evaluate(x) && second.evaluate(x);
            }
        };
    }

    public static DoublePredicate orPredicate(final DoublePredicate first, final DoublePredicate second) {
        return new DoublePredicate(){

            public final boolean evaluate(double x) {
                return first.evaluate(x) || second.evaluate(x);
            }
        };
    }

    public static LongPredicate andPredicate(final LongPredicate first, final LongPredicate second) {
        return new LongPredicate(){

            public final boolean evaluate(long x) {
                return first.evaluate(x) && second.evaluate(x);
            }
        };
    }

    public static LongPredicate orPredicate(final LongPredicate first, final LongPredicate second) {
        return new LongPredicate(){

            public final boolean evaluate(long x) {
                return first.evaluate(x) || second.evaluate(x);
            }
        };
    }

    public static Predicate<Object> isNonNullPredicate() {
        return IsNonNullPredicate.predicate;
    }

    public static Predicate<Object> isNullPredicate() {
        return IsNullPredicate.predicate;
    }

    public static Predicate<Object> instanceofPredicate(final Class type) {
        return new Predicate<Object>(){

            @Override
            public final boolean evaluate(Object x) {
                return type.isInstance(x);
            }
        };
    }

    public static Predicate<Object> isAssignablePredicate(final Class type) {
        return new Predicate<Object>(){

            @Override
            public final boolean evaluate(Object x) {
                return type.isAssignableFrom(x.getClass());
            }
        };
    }

    public static DoubleReducer doubleAdder() {
        return DoubleAdder.adder;
    }

    public static LongReducer longAdder() {
        return LongAdder.adder;
    }

    public static IntReducer intAdder() {
        return IntAdder.adder;
    }

    public static DoubleGenerator doubleRandom() {
        return DoubleRandomGenerator.generator;
    }

    public static DoubleGenerator doubleRandom(double bound) {
        return new DoubleBoundedRandomGenerator(bound);
    }

    public static DoubleGenerator doubleRandom(double least, double bound) {
        return new DoubleIntervalRandomGenerator(least, bound);
    }

    public static LongGenerator longRandom() {
        return LongRandomGenerator.generator;
    }

    public static LongGenerator longRandom(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException();
        }
        return new LongBoundedRandomGenerator(bound);
    }

    public static LongGenerator longRandom(long least, long bound) {
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return new LongIntervalRandomGenerator(least, bound);
    }

    public static IntGenerator intRandom() {
        return IntRandomGenerator.generator;
    }

    public static IntGenerator intRandom(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException();
        }
        return new IntBoundedRandomGenerator(bound);
    }

    public static IntGenerator intRandom(int least, int bound) {
        if (least >= bound) {
            throw new IllegalArgumentException();
        }
        return new IntIntervalRandomGenerator(least, bound);
    }

    static final class IntIntervalRandomGenerator
    implements IntGenerator {
        final int least;
        final int range;

        IntIntervalRandomGenerator(int least, int bound) {
            this.least = least;
            this.range = bound - least;
        }

        public int generate() {
            return ForkJoinWorkerThread.nextRandomInt(this.range) + this.least;
        }
    }

    static final class IntBoundedRandomGenerator
    implements IntGenerator {
        final int bound;

        IntBoundedRandomGenerator(int bound) {
            this.bound = bound;
        }

        public int generate() {
            return ForkJoinWorkerThread.nextRandomInt(this.bound);
        }
    }

    static final class IntRandomGenerator
    implements IntGenerator {
        static final IntRandomGenerator generator = new IntRandomGenerator();

        IntRandomGenerator() {
        }

        public int generate() {
            return ForkJoinWorkerThread.nextRandomInt();
        }
    }

    static final class LongIntervalRandomGenerator
    implements LongGenerator {
        final long least;
        final long range;

        LongIntervalRandomGenerator(long least, long bound) {
            this.least = least;
            this.range = bound - least;
        }

        public long generate() {
            return ForkJoinWorkerThread.nextRandomLong(this.range) + this.least;
        }
    }

    static final class LongBoundedRandomGenerator
    implements LongGenerator {
        final long bound;

        LongBoundedRandomGenerator(long bound) {
            this.bound = bound;
        }

        public long generate() {
            return ForkJoinWorkerThread.nextRandomLong(this.bound);
        }
    }

    static final class LongRandomGenerator
    implements LongGenerator {
        static final LongRandomGenerator generator = new LongRandomGenerator();

        LongRandomGenerator() {
        }

        public long generate() {
            return ForkJoinWorkerThread.nextRandomLong();
        }
    }

    static final class DoubleIntervalRandomGenerator
    implements DoubleGenerator {
        final double least;
        final double range;

        DoubleIntervalRandomGenerator(double least, double bound) {
            this.least = least;
            this.range = bound - least;
        }

        public double generate() {
            return ForkJoinWorkerThread.nextRandomDouble() * this.range + this.least;
        }
    }

    static final class DoubleBoundedRandomGenerator
    implements DoubleGenerator {
        final double bound;

        DoubleBoundedRandomGenerator(double bound) {
            this.bound = bound;
        }

        public double generate() {
            return ForkJoinWorkerThread.nextRandomDouble() * this.bound;
        }
    }

    static final class DoubleRandomGenerator
    implements DoubleGenerator {
        static final DoubleRandomGenerator generator = new DoubleRandomGenerator();

        DoubleRandomGenerator() {
        }

        public double generate() {
            return ForkJoinWorkerThread.nextRandomDouble();
        }
    }

    static final class IntAdder
    implements IntReducer {
        static final IntAdder adder = new IntAdder();

        IntAdder() {
        }

        public int combine(int a, int b) {
            return a + b;
        }
    }

    static final class LongAdder
    implements LongReducer {
        static final LongAdder adder = new LongAdder();

        LongAdder() {
        }

        public long combine(long a, long b) {
            return a + b;
        }
    }

    static final class DoubleAdder
    implements DoubleReducer {
        static final DoubleAdder adder = new DoubleAdder();

        DoubleAdder() {
        }

        public double combine(double a, double b) {
            return a + b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IsNullPredicate
    implements Predicate<Object> {
        static final IsNullPredicate predicate = new IsNullPredicate();

        IsNullPredicate() {
        }

        @Override
        public final boolean evaluate(Object x) {
            return x != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IsNonNullPredicate
    implements Predicate<Object> {
        static final IsNonNullPredicate predicate = new IsNonNullPredicate();

        IsNonNullPredicate() {
        }

        @Override
        public final boolean evaluate(Object x) {
            return x != null;
        }
    }

    static final class NaturalLongMinReducer
    implements LongReducer {
        public static final NaturalLongMinReducer min = new NaturalLongMinReducer();

        NaturalLongMinReducer() {
        }

        public long combine(long a, long b) {
            return a <= b ? a : b;
        }
    }

    static final class NaturalLongMaxReducer
    implements LongReducer {
        public static final NaturalLongMaxReducer max = new NaturalLongMaxReducer();

        NaturalLongMaxReducer() {
        }

        public long combine(long a, long b) {
            return a >= b ? a : b;
        }
    }

    static final class NaturalLongComparator
    implements LongComparator {
        static final NaturalLongComparator comparator = new NaturalLongComparator();

        NaturalLongComparator() {
        }

        public int compare(long a, long b) {
            return a < b ? -1 : (a > b ? 1 : 0);
        }
    }

    static final class NaturalDoubleMinReducer
    implements DoubleReducer {
        public static final NaturalDoubleMinReducer min = new NaturalDoubleMinReducer();

        NaturalDoubleMinReducer() {
        }

        public double combine(double a, double b) {
            return Math.min(a, b);
        }
    }

    static final class NaturalDoubleMaxReducer
    implements DoubleReducer {
        public static final NaturalDoubleMaxReducer max = new NaturalDoubleMaxReducer();

        NaturalDoubleMaxReducer() {
        }

        public double combine(double a, double b) {
            return Math.max(a, b);
        }
    }

    static final class NaturalDoubleComparator
    implements DoubleComparator {
        static final NaturalDoubleComparator comparator = new NaturalDoubleComparator();

        NaturalDoubleComparator() {
        }

        public int compare(double a, double b) {
            return Double.compare(a, b);
        }
    }

    static final class RawMinReducer
    implements Reducer {
        static final RawMinReducer min = new RawMinReducer();

        RawMinReducer() {
        }

        public Object combine(Object a, Object b) {
            return a != null && (b == null || ((Comparable)a).compareTo((Comparable)b) <= 0) ? a : b;
        }
    }

    static final class RawMaxReducer
    implements Reducer {
        static final RawMaxReducer max = new RawMaxReducer();

        RawMaxReducer() {
        }

        public Object combine(Object a, Object b) {
            return a != null && (b == null || ((Comparable)a).compareTo((Comparable)b) >= 0) ? a : b;
        }
    }

    static final class RawComparator
    implements Comparator {
        static final RawComparator cmp = new RawComparator();

        RawComparator() {
        }

        public int compare(Object a, Object b) {
            return ((Comparable)a).compareTo((Comparable)b);
        }
    }

    public static interface IntComparator {
        public int compare(int var1, int var2);
    }

    public static interface LongComparator {
        public int compare(long var1, long var3);
    }

    public static interface DoubleComparator {
        public int compare(double var1, double var3);
    }

    public static interface IntRelationalPredicate {
        public boolean evaluate(int var1, int var2);
    }

    public static interface IntPredicate {
        public boolean evaluate(int var1);
    }

    public static interface IntReducer {
        public int combine(int var1, int var2);
    }

    public static interface MapperFromIntToDouble {
        public double map(int var1);
    }

    public static interface MapperFromIntToLong {
        public long map(int var1);
    }

    public static interface IntMapper {
        public int map(int var1);
    }

    public static interface IntProcedure {
        public void apply(int var1);
    }

    public static interface IntGenerator {
        public int generate();
    }

    public static interface LongRelationalPredicate {
        public boolean evaluate(long var1, long var3);
    }

    public static interface LongPredicate {
        public boolean evaluate(long var1);
    }

    public static interface LongReducer {
        public long combine(long var1, long var3);
    }

    public static interface LongMapper {
        public long map(long var1);
    }

    public static interface MapperFromLongToDouble {
        public double map(long var1);
    }

    public static interface MapperFromLongToInt {
        public int map(long var1);
    }

    public static interface LongProcedure {
        public void apply(long var1);
    }

    public static interface LongGenerator {
        public long generate();
    }

    public static interface DoubleRelationalPredicate {
        public boolean evaluate(double var1, double var3);
    }

    public static interface DoublePredicate {
        public boolean evaluate(double var1);
    }

    public static interface DoubleReducer {
        public double combine(double var1, double var3);
    }

    public static interface DoubleMapper {
        public double map(double var1);
    }

    public static interface MapperFromDoubleToLong {
        public long map(double var1);
    }

    public static interface MapperFromDoubleToInt {
        public int map(double var1);
    }

    public static interface DoubleProcedure {
        public void apply(double var1);
    }

    public static interface DoubleGenerator {
        public double generate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapperFromLong<T> {
        public T map(long var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapperFromDouble<T> {
        public T map(double var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapperFromInt<T> {
        public T map(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapperToLong<T> {
        public long map(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapperToDouble<T> {
        public double map(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MapperToInt<T> {
        public int map(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RelationalPredicate<T, U> {
        public boolean evaluate(T var1, U var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Predicate<T> {
        public boolean evaluate(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Reducer<T>
    extends Combiner<T, T, T> {
        @Override
        public T combine(T var1, T var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Combiner<T, U, V> {
        public V combine(T var1, U var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mapper<T, U> {
        public U map(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Procedure<T> {
        public void apply(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Generator<T> {
        public T generate();
    }
}

