/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: MultipleSelectionFileHandler.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/widgets/MultipleSelectionFileHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.widgets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.ui.VradiMainUI;
import org.nuiton.wikitty.entities.BusinessEntity;

import javax.swing.JOptionPane;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/** @author sletellier */
public abstract class MultipleSelectionFileHandler<B extends BusinessEntity, H> extends MultipleSelectionHandler<File, B, H> {


    /** log. */
    private static final Log log = LogFactory.getLog(MultipleSelectionFileHandler.class);

    public MultipleSelectionFileHandler(MultipleSelectionPane ui, Class<H> handler, String lblKey) {
        super(ui, handler);
        ui.setLbl(_(lblKey));
    }

    @Override
    public void init() {
        Set<String> files = getFiles();
        fillList(files);
    }

    @Override
    public void add() {
        File file = addFiles(ui, getBean());
        if (file != null) {
            addToList(file, file.getName());
        }
    }

    @Override
    public void remove() {
        List<String> filesNames = removeFiles(getBean(), getSelectedInList());
        removeFromList(filesNames);
    }

    @Override
    public void openSelected(String selected) {
        try {
            File file = downloadFile(selected, getBean().getWikittyId());
            Desktop.getDesktop().open(file);
        } catch (Exception eee) {
            log.error("Error on download file : " + selected, eee);
            fileNotFound(selected);
        }
    }

    public void fileNotFound(String selected) {
        VradiMainUI ui = VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(VradiContext.get());
        JOptionPane.showConfirmDialog(ui, _("vradi.error.fileNotFound", selected),
                                      _("vradi.error.fileNotFound.title"), JOptionPane.OK_OPTION, JOptionPane.ERROR_MESSAGE);
    }

    public abstract File downloadFile(String selected, String wikittyId) throws VradiException;

    public abstract List<String> removeFiles(B bean, List<String> selectedInList);

    public abstract Set<String> getFiles();

    public abstract File addFiles(MultipleSelectionPane ui, B bean);
}
