/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class TextEditor extends VradiEditor<String, TextEditorModel> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CONVERT_TO_ISO_ENABLED = "convertToIso.enabled";
    public static final String BINDING_CONVERT_TO_UTF_ENABLED = "convertToUtf.enabled";
    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_TEXT = "editor.text";
    public static final String BINDING_REMOVE_END_LINE_BUTTON_ENABLED = "removeEndLineButton.enabled";
    public static final String BINDING_REMOVE_XML_ENABLED = "removeXML.enabled";
    public static final String BINDING_UNESCAPE_XML_ENABLED = "unescapeXML.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVTW/TQBCdBJIS0vLR0EIFiAAVQgI5BQmEVFRoCxUfKSASqkIubOJts9XGa9br4PaA+An8BLhzQeLGCXHgzIEL4i8gxIErYtZO4gSMMSQHJ5qZ92beeGby8gtkHAlHN4jnGdK1FGtR48b86urt+gZtqCvUaUhmKyEh+KTSkK5B3uzZHQXHa2UNL3XgpUXRsoVFrT70bBl2OmqTU6dJqVJweBDRcJxSpeee9WxXdll7RUWxPv/2Nf3MfPoiDeDZWN0oSin+DRUq2V6GNDMVjGOmNilxYq1jGZJZ61jvmLYtcuI4t0iLPoInMFKGrE0kkik4llyyz+HjPVvB2PSKJCa7ajKMmVFwWsh1o9EUkraMtvYYLjPE2hqVBvVjHKNKPRXE27ZPlFWQaQmTcgVn/gW+rDEhR65NODMJOhScGuhaz2E4j7EbRkU/V7rGkGEsyLEoLOV3ZVz3zOuAbtwhVn+6PUFwpSEF59qnYP9AfOjRiPEeMBsAFUwMhGtd85ISHTURBk+vLAhvxufuUxRgtGuQu4CNE2161TLLzKILrlKoBQoDiQKrBhzs4UYbwmpTqariuiO0rfgn/z21FuHPBXlXl8sRzrxr4RgR+1e3hIMDonBtjHBtwrlO1SAjXTQrOFD7fdPuoivYsQO/7Jgm9L0/Jgsf33x+vdRdrH2YeyIytO8u4MDbUtiomunUu4OtchXjpWViz9Yg51COR8U/GociCqt03Fgc5tur4YaGG9eI00SKzMint+8mH37YBukl2MkFMZeIjr8OOdWU2AXBTc++dNmvaPTxDnzu0bXhVHCyKfA1wq6LOMKkWGeWie92zsMmHIpoQq+Seu7990Ll1eVuI1JY2NQfw8NmZB5AllkcZ8q/MZ3zEXlT8rZDXVOEZyLqcKT0d8HubJPhP89GKZ3CW8C2cIgJD/Zpgcg7grPGpoac81z9dd5Xon9d8IknExCPUIvUOTVjaKYS0ORbzGItt1VhW3RIqu0KL8BQHNo8H8NwJBHDTTx8F4OXXSQK/z/qrqJz/8uILVJC8Cqzqx151WGKi5N3LJm8mBqSMdwfmiFOxfTQKpIxxKlIxhCn4sTQKpIxxKlIxhCn4uTQKpIxxKnQDD8BcMDMidcKAAA=";
    private static final Log log = LogFactory.getLog(TextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton convertToIso;
    protected JButton convertToUtf;
    @ValidatorField( validatorId = "validator",  propertyName = "value",  editorName = "editor")
    protected JTextArea editor;
    protected JScrollPane editorScrollPane;
    protected TextEditorModel model;
    protected JButton removeEndLineButton;
    protected JButton removeXML;
    protected JButton unescapeXML;
    @Validator( validatorId = "validator")
    protected SwingValidator<TextEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private TextEditor $VradiEditor0 = this;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void registerValidator() {
                validator.setBean(model);
                getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                        .registerValidator(validator);
            }
            void $afterCompleteSetup() {
                // scroll more efficiently
                editorScrollPane.getVerticalScrollBar().setBlockIncrement(100);
                editorScrollPane.getVerticalScrollBar().setUnitIncrement(50);
            }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public TextEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TextEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public TextEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public TextEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TextEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public TextEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public TextEditor() {
        $initialize();
    }

    public TextEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__convertToIso(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.convertToIso();
    }

    public void doActionPerformed__on__convertToUtf(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.convertToUtf();
    }

    public void doActionPerformed__on__removeEndLineButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.removeEndLine();
    }

    public void doActionPerformed__on__removeXML(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.removeXML();
    }

    public void doActionPerformed__on__unescapeXML(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.unescapeXML();
    }

    public void doKeyReleased__on__editor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setValue(editor.getText());revalidate();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getConvertToIso() {
        return convertToIso;
    }

    public JButton getConvertToUtf() {
        return convertToUtf;
    }

    public JTextArea getEditor() {
        return editor;
    }

    public JScrollPane getEditorScrollPane() {
        return editorScrollPane;
    }

    public TextEditorModel getModel() {
        return model;
    }

    public JButton getRemoveEndLineButton() {
        return removeEndLineButton;
    }

    public JButton getRemoveXML() {
        return removeXML;
    }

    public JButton getUnescapeXML() {
        return unescapeXML;
    }

    public SwingValidator<TextEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(editorScrollPane, BorderLayout.CENTER);
        editorContent.add($VBox0, BorderLayout.EAST);
    }

    protected void addChildrenToEditorScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        editorScrollPane.getViewport().add(SwingUtil.boxComponentWithJxLayer(editor));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createConvertToIso() {
        $objectMap.put("convertToIso", convertToIso = new JButton());
        
        convertToIso.setName("convertToIso");
        convertToIso.setText(_("vradi.editor.convertToIso"));
        convertToIso.setToolTipText(_("vradi.editor.convertToIsoToolTip"));
        convertToIso.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__convertToIso"));
    }

    protected void createConvertToUtf() {
        $objectMap.put("convertToUtf", convertToUtf = new JButton());
        
        convertToUtf.setName("convertToUtf");
        convertToUtf.setText(_("vradi.editor.convertToUtf"));
        convertToUtf.setToolTipText(_("vradi.editor.convertToUtfToolTip"));
        convertToUtf.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__convertToUtf"));
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JTextArea());
        
        editor.setName("editor");
        editor.setColumns(15);
        editor.setLineWrap(true);
        editor.setWrapStyleWord(true);
        editor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__editor"));
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        editorContent.setLayout(new BorderLayout());
    }

    protected void createEditorScrollPane() {
        $objectMap.put("editorScrollPane", editorScrollPane = new JScrollPane());
        
        editorScrollPane.setName("editorScrollPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = new TextEditorModel());
    }

    protected void createRemoveEndLineButton() {
        $objectMap.put("removeEndLineButton", removeEndLineButton = new JButton());
        
        removeEndLineButton.setName("removeEndLineButton");
        removeEndLineButton.setText(_("vradi.editor.removeEndLine"));
        removeEndLineButton.setToolTipText(_("vradi.editor.removeEndLineToolTip"));
        removeEndLineButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeEndLineButton"));
    }

    protected void createRemoveXML() {
        $objectMap.put("removeXML", removeXML = new JButton());
        
        removeXML.setName("removeXML");
        removeXML.setText(_("vradi.editor.removeXML"));
        removeXML.setToolTipText(_("vradi.editor.removeXMLToolTip"));
        removeXML.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeXML"));
    }

    protected void createUnescapeXML() {
        $objectMap.put("unescapeXML", unescapeXML = new JButton());
        
        unescapeXML.setName("unescapeXML");
        unescapeXML.setText(_("vradi.editor.unescapeXML"));
        unescapeXML.setToolTipText(_("vradi.editor.unescapeXMLToolTip"));
        unescapeXML.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__unescapeXML"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(TextEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToEditorContent();
        addChildrenToEditorScrollPane();
        // inline complete setup of $VBox0
        $VBox0.add(removeEndLineButton);
        $VBox0.add(convertToIso);
        $VBox0.add(convertToUtf);
        $VBox0.add(removeXML);
        $VBox0.add(unescapeXML);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        editorScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        editor.setMinimumSize(new Dimension(0,56));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$VradiEditor0", $VradiEditor0);
        createModel();
        createValidator();
        createEditorScrollPane();
        createEditor();
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        createRemoveEndLineButton();
        createConvertToIso();
        createConvertToUtf();
        createRemoveXML();
        createUnescapeXML();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(editor, model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_END_LINE_BUTTON_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    removeEndLineButton.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONVERT_TO_ISO_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    convertToIso.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CONVERT_TO_UTF_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    convertToUtf.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_XML_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    removeXML.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UNESCAPE_XML_ENABLED, true ,"enabled" ,"value") {
        
            @Override
            public void processDataBinding() {
                if (getValue() != null) {
                    unescapeXML.setEnabled(isEnabled() && getValue() != null && !getValue().isEmpty());
                }
            }
        });
    }

}