/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXTree;
import jaxx.runtime.swing.JAXXTree.JAXXTreeModel;
import jaxx.runtime.swing.Table;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.renderers.ThesaurusHighlighter;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusSelectionManager;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeHelper;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.jdesktop.swingx.JXTreeTable;
import static org.nuiton.i18n.I18n._;

public class ThesaurusUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_THESAURUS_MODEL = "thesaurus.model";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL0_TOOL_TIP_TEXT = "$JLabel0.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ThesaurusUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JTree thesaurus;
    protected JList thesaurusSelected;
    protected ThesaurusUI thesaurusUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JButton $JButton0;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected DefaultListModel thesaurusSelectedModel;
    protected ThesaurusSelectionManager manager;
    protected ThesaurusTreeHelper helper;
    protected boolean deletable;
    
    
    public OfferEditUI getParentUI(){
        return getParentContainer(OfferEditUI.class);
    }
    
    protected ThesaurusHandler getHandler() {
        return getContextValue(ThesaurusHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public ThesaurusTreeHelper getHelper() {
        return helper;
    }
    
    void $afterCompleteSetup() {
    
        // Remove on double click
        thesaurusSelected.addMouseListener(new MouseAdapter(){
    
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Thesaurus toUnselect = (Thesaurus)thesaurusSelected.getSelectedValue();
                    manager.tryToUnSelect(toUnselect);
                }
            }
        });
    
        // Adding ridht clic menu
        thesaurus.addMouseListener(new MouseAdapter() {
    
            @Override
            public void mouseClicked(final MouseEvent mouseEvent) {
                JTree tree = (JTree) mouseEvent.getSource();
                TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
                // If node is selected
                boolean isSelected = path != null;
                if (mouseEvent.getButton() == MouseEvent.BUTTON3){
                    JPopupMenu popup = new JPopupMenu();
    
    //                JMenuItem menuAddCriteria = new JMenuItem();
    //                menuAddCriteria.setText(_("vradi.menu.addCriteria"));
    //                menuAddCriteria.addActionListener(new ActionListener() {
    
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addCriteriaSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddCriteria);
    
    //                JMenuItem menuAddColumns = new JMenuItem();
    //                menuAddColumns.setText(_("vradi.menu.addColumns"));
    //                menuAddColumns.addActionListener(new ActionListener() {
    //
    //                    @Override
    //                    public void actionPerformed(ActionEvent actionEvent) {
    //                        addColumnSelected(getPathSelected(mouseEvent));
    //                    }
    //                });
    //                popup.add(menuAddColumns);
    
                    if (isSelected){
                        JMenuItem menuAddThesaurus = new JMenuItem();
                        menuAddThesaurus.setText(_("vradi.menu.addThesaurus"));
                        menuAddThesaurus.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                addThesaurusSelected(getPathSelected(mouseEvent));
                            }
                        });
                        popup.add(menuAddThesaurus);
                    }
                    
                    popup.show(thesaurus, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        UIHelper.addThesaurusExpandOnClickListener(thesaurus);
    
        TreeSelectionListener selectionListener = new TreeSelectionListener() {
    
            @Override
            public void valueChanged(TreeSelectionEvent e) {
                thsaurusSelected();
            }
        };
        thesaurus.addTreeSelectionListener(selectionListener);
    
        // Expends root
        thesaurus.expandRow(0);
    
        // Override default selection model to enable one click selection
        thesaurus.setSelectionModel(new DefaultTreeSelectionModel() {
    
            @Override
            public void setSelectionPath(TreePath path) {
                TreePath[] treePaths = getSelectionPaths();
                if (treePaths == null || !Arrays.asList(treePaths).contains(path)) {
                    addSelectionPath(path);
                } else {
                    removeSelectionPath(path);
                }
            }
        });
    
        // If not root thesaurusUI
        if (deletable) {
            manager.registerTreeHelper(helper, thesaurus);
        } else {
            manager.registerRootTreeHelper(helper, thesaurus);
        }
        
        // Tooltip is not active without this code...
        javax.swing.ToolTipManager.sharedInstance().registerComponent(thesaurus);
    }
    
    public DefaultListModel getThesaurusSelectedModel(){
        return thesaurusSelectedModel;
    }
    
    protected void thsaurusSelected(){
        TreePath[] treePaths = thesaurus.getSelectionPaths();
        thesaurusSelectedModel = new DefaultListModel();
        if (treePaths != null){
            for (TreePath path : treePaths){
                VradiTreeNode selected = (VradiTreeNode)path.getLastPathComponent();
                if (selected.getInternalClass().equals(Thesaurus.class)) {
                    Thesaurus thesaurusSelected = ThesaurusDataHelper.restoreThesaurus(selected.getId());
                    thesaurusSelectedModel.addElement(thesaurusSelected);
                }
    
            }
        }
        thesaurusSelected.setModel(thesaurusSelectedModel);
    }
    
    protected TreePath getPathSelected(MouseEvent mouseEvent){
        JTree tree = (JTree) mouseEvent.getSource();
    
        // Recuperation du path selectionne
        TreePath path = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
    
        return path;
    }
    
    protected void addCriteriaSelected(TreePath path){
        log.debug("addCriteriaSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().addCriteria(this, helper, path);
    }
    
    protected void addThesaurusSelected(TreePath path){
        log.debug("addThesaurusSelected " + path);
        // Ajout dun nouveau thesaurus
        getHandler().newThesaurusUI(this, manager, path);
    }
    
    protected void addColumnSelected(TreePath path){
        log.debug("addColumnSelected " + path);
        // Ajout dune nouvelle column
    //    getHandler().addColumn(this, helper, path);
    }
    
    protected String getRootNamePath(){
        String path = getHandler().getNamePath(helper.getRootNode());
        return StringUtils.abbreviate(path, path.length() - 20, 23);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ThesaurusUI(JAXXContext parentContext, ThesaurusSelectionManager manager, ThesaurusTreeHelper helper, boolean deletable) {
        SwingUtil.initContext(this, parentContext);
            this.deletable = deletable;
            this.helper = helper;
            this.manager = manager;
            $initialize();
    }

    public ThesaurusUI() {
        $initialize();
    }

    public ThesaurusUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().closeThesaurus(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JTree getThesaurus() {
        return thesaurus;
    }

    public JList getThesaurusSelected() {
        return thesaurusSelected;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToThesaurusUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        add($JButton0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        add($JScrollPane0, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JScrollPane1, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void create$JButton0() {
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setBorderPainted(false);
        $JButton0.setFocusPainted(false);
        $JButton0.setHorizontalTextPosition(0);
        $JButton0.setOpaque(true);
        $JButton0.setVerticalAlignment(0);
        $JButton0.setVerticalTextPosition(0);
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new JTree());
        
        thesaurus.setName("thesaurus");
        thesaurus.setRootVisible(false);
        thesaurus.setShowsRootHandles(true);
    }

    protected void createThesaurusSelected() {
        $objectMap.put("thesaurusSelected", thesaurusSelected = new JList());
        
        thesaurusSelected.setName("thesaurusSelected");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToThesaurusUI();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(thesaurusSelected);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(thesaurus);
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        $JLabel0.setText(_(getRootNamePath()));
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("closeTab"));
        $JButton0.setSize(new Dimension(16, 16));
        thesaurusSelected.setCellRenderer(new ThesaurusHighlighter());
        thesaurus.setCellRenderer(new ThesaurusHighlighter());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("thesaurusUI", thesaurusUI);
        thesaurusSelectedModel = new DefaultListModel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        create$JButton0();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createThesaurusSelected();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createThesaurus();
        // inline creation of thesaurusUI
        setName("thesaurusUI");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TOOL_TIP_TEXT, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    $JLabel0.setToolTipText(_(getHandler().getNamePath(helper.getRootNode())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"deletable") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(deletable);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_THESAURUS_MODEL, true ,"helper") {
        
            @Override
            public void processDataBinding() {
                if (helper != null) {
                    thesaurus.setModel(helper.createTreeModel());
                }
            }
        });
    }

}