/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.login;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.VradiUser;
import org.chorem.vradi.entities.VradiUserImpl;
import static org.nuiton.i18n.I18n._;

public class LoginUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_MAIN_UI_INITIALIZED = "mainUiInitialized";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHp5W2FBQFQgVFA0g8mS1G4wWCCKYRUoUIGGIvTHfHdsjszDozC4sH45/gn6B3LybePBkPnj14Mf4Lxnjwanyz2x+0LKWxHNruvPc+831f3tt3P1FKSTS9h4PAkj7X1CXW2r2dnfXyHrH1faJsST0tJIr+EkmULKFBp3GuNLpWKpryfK08vyJcT3DCj1TPF9GA0oeMqCohWqMrrRW2UvnNRng+8HxZpzZExVHf/P6VfO28eptEKPBA3SC0MnVaVbOTviJKUkejEbhpH+cZ5hWQISmvgN5z5myFYaUeYZc8Ry9RpojSHpYA02im+5ZDRlgfeBplmKhQvr2q0bSQFcuuCklca19ih1o+tcKoVYxyPC+sS2vUVyaYg9PHSuBKqilR1hPzuK2IbBYNuxgodJVDBmb0BYFWh01XlunUWhaCAbWZPxBevoE5YRqNt9ioDsAUawuXWehEtlHTP7tWxGXC5sBFgw5qqdGpSRpp5KZCvka5lsQtEugCJcxpTa6Db5rni20xDxw9EBL6udTC2qidx/DSNua2aWy0pWLZ11rwNrwkFao0keZ5pi22D046WJOjMYkut7gF42w1x7k5b4kSSkkfjsHe0vENeAyhaPbH22bfAMPo39zot48/PhTqAz8Ed4/Fph7ZVxhETwqPSDMoGp2Ppt3XlOUfYm++hLKKMFj2cJknY4Rt1sIgDu6LRsiUWw+wqgIilfn+6XNu9+sZlCyYKcJOAZv8VZTVVQkuCOYE3t2lUNHZg374vGC0aTTmkGfYZ3qFCUXWQSLWVMCIDC2Ax3iqTLkD/6bFADyZjPGkIayc/fJndPP9Ut2XBOicODG96U3qKUpTzign4augtuWxqz/oKeI7ornNcfudMN8DXm2nboSfc3GNpxk+FL428VuBb75uh7LNrztdU1KucDDM9MhC1MQU1vD6KvuaLPYAhTdKtOZL/w/p07DWHRi5LhgZWzDf5aoDZuJUjDle60CY7Iqw3oFwtWcN012Y0e9y4gpO7Z44pymZ7Yqw2zOhk4brPWswhH/bOXe/2QgAAA==";
    private static final Log log = LogFactory.getLog(LoginUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected VradiUser bean;
    protected JButton cancel;
    protected JTextField login;
    protected Table loginPanel;
    protected LoginUI loginUI = this;
    protected Boolean mainUiInitialized;
    protected JPasswordField password;
    protected JButton register;
    protected JButton validate;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected LoginHandler getHandler() {
        return getContextValue(LoginHandler.class);
    }
    
    void $afterCompleteSetup() {
        KeyAdapter keyAdapter = new KeyAdapter(){
                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if(keyEvent.getKeyCode() == KeyEvent.VK_ENTER) {
                        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
                        validate.doClick();
                    }
                }
        };
        login.addKeyListener(keyAdapter);
        password.addKeyListener(keyAdapter);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LoginUI() {
        $initialize();
    }

    public LoginUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0) {
        super(param0);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LoginUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public LoginUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        loginUI.dispose(); System.exit(0);
    }

    public void doActionPerformed__on__register(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().register(this);
    }

    public void doActionPerformed__on__validate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().logUser(this);
    }

    public void doWindowClosing__on__loginUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose(); System.exit(0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public VradiUser getBean() {
        return bean;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JTextField getLogin() {
        return login;
    }

    public Table getLoginPanel() {
        return loginPanel;
    }

    public Boolean getMainUiInitialized() {
        return mainUiInitialized;
    }

    public JPasswordField getPassword() {
        return password;
    }

    public JButton getRegister() {
        return register;
    }

    public JButton getValidate() {
        return validate;
    }

    public Boolean isMainUiInitialized() {
        return mainUiInitialized !=null && mainUiInitialized;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(VradiUser bean) {
        VradiUser oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setMainUiInitialized(Boolean mainUiInitialized) {
        Boolean oldValue = this.mainUiInitialized;
        this.mainUiInitialized = mainUiInitialized;
        firePropertyChange(PROPERTY_MAIN_UI_INITIALIZED, oldValue, mainUiInitialized);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToLoginPanel() {
        if (!allComponentsCreated) {
            return;
        }
        loginPanel.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(login, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(password, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(cancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(register, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        loginPanel.add(validate, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToLoginUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(loginPanel);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.login.cancel"));
        cancel.setMnemonic(65);
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createLogin() {
        $objectMap.put("login", login = new JTextField());
        
        login.setName("login");
        login.setColumns(15);
        login.setColumns(20);
    }

    protected void createLoginPanel() {
        $objectMap.put("loginPanel", loginPanel = new Table());
        
        loginPanel.setName("loginPanel");
    }

    protected void createMainUiInitialized() {
        $objectMap.put("mainUiInitialized", mainUiInitialized = false);
    }

    protected void createPassword() {
        $objectMap.put("password", password = new JPasswordField());
        
        password.setName("password");
        password.setColumns(15);
        password.setColumns(20);
    }

    protected void createRegister() {
        $objectMap.put("register", register = new JButton());
        
        register.setName("register");
        register.setText(_("vradi.login.register"));
        register.setMnemonic(69);
        register.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__register"));
    }

    protected void createValidate() {
        $objectMap.put("validate", validate = new JButton());
        
        validate.setName("validate");
        validate.setText(_("vradi.login.validate"));
        validate.setMnemonic(86);
        validate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__validate"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToLoginUI();
        addChildrenToLoginPanel();
        
        // apply 2 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        // late initializer
        loginUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("loginUI", loginUI);
        createBean();
        createMainUiInitialized();
        createLoginPanel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.login.login"));
        createLogin();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.login.password"));
        createPassword();
        createCancel();
        createRegister();
        createValidate();
        // inline creation of loginUI
        setName("loginUI");
        loginUI.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(_("vradi.login.title"));
        loginUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__loginUI"));
        
        $completeSetup();
    }

}