/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AttachmentSessionFileHandler.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/email/widgets/AttachmentSessionFileHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email.widgets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.email.EmailHandler;
import org.chorem.vradi.ui.widgets.MultipleSelectionFileHandler;
import org.chorem.vradi.ui.widgets.MultipleSelectionPane;

import java.io.File;
import java.util.List;
import java.util.Set;

import static org.nuiton.i18n.I18n.n_;

/** @author sletellier */
public class AttachmentSessionFileHandler extends MultipleSelectionFileHandler<Session, EmailHandler> {


    /** log. */
    private static final Log log = LogFactory.getLog(AttachmentSessionFileHandler.class);

    public AttachmentSessionFileHandler(MultipleSelectionPane ui) {
        super(ui, EmailHandler.class, n_("vradi.email.sessionAttachedfile"));
    }

    @Override
    public File downloadFile(String selected, String wikittyId) throws VradiException {
        return VradiService.getFileService().downloadSessionAttachment(selected, getBean().getWikittyId());
    }

    @Override
    public List<String> removeFiles(Session bean, List<String> selectedInList) {
        List<String> result = getHandler().removeAttachmentFile(getBean(), getSelectedInList());
        updateSession();
        return result;
    }

    @Override
    public Set<String> getFiles() {
        return getBean().getFiles();
    }

    @Override
    public File addFiles(MultipleSelectionPane ui, Session bean) {
        File result = getHandler().addAttachmentFile(ui, getBean());
        updateSession();
        return result;
    }

    protected void updateSession() {
        Session session = VradiService.getWikittyProxy().restore(Session.class, getBean().getWikittyId());
        setBean(session);
    }
}
