/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailFormNodeLoadors.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/email/loadors/EmailFormNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email.loadors;

import jaxx.runtime.swing.nav.NavDataProvider;
import org.chorem.vradi.beans.SendingHelper;
import org.chorem.vradi.entities.Form;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/** @author sletellier <letellier@codelutin.com> */
public class EmailFormNodeLoadors extends AbstractEmailNodeLoador<Form> {

    public EmailFormNodeLoadors() {
        super(Form.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();

        // Get sending of session
        List<Sending> sendings = getSendingList(dataProvider, parentId);

        // Extract clients ids
        List<String> formsIdsToDisplay = new ArrayList<String>();
        for (Sending sending : sendings) {
            if (sending != null) {
                Set<String> formsIds = SendingHelper.extractForms(wikittyProxy, sending.getGroupForms());
                if (formsIds != null) {
                    formsIdsToDisplay.addAll(formsIds);
                }
                Set<String> deletedFormsIds = SendingHelper.extractForms(wikittyProxy, sending.getDeletedGroupForms());
                if (deletedFormsIds != null) {
                    formsIdsToDisplay.addAll(deletedFormsIds);
                }
            }
        }

        // Sort
        List<Form> formSorted = wikittyProxy.restore(Form.class, formsIdsToDisplay);
        Collections.sort(formSorted, VradiComparators.FORM_COMPARATOR);

        // Return forms
        return extractIds(formSorted);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}
