/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AbstractEmailNodeLoador.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/email/loadors/AbstractEmailNodeLoador.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.email.loadors;

import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.Sending;
import org.chorem.vradi.entities.Session;
import org.chorem.vradi.ui.email.helpers.EmailDataHelper;
import org.chorem.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

import java.util.List;

/** @author sletellier <letellier@codelutin.com> */
public abstract class AbstractEmailNodeLoador<B extends BusinessEntity> extends AbstractVradiNodeLoadors<B> {

    static private final Log log = LogFactory.getLog(AbstractEmailNodeLoador.class);

    protected AbstractEmailNodeLoador(Class<B> beanType) {
        super(beanType);
    }

    public List<Sending> getSendingList(NavDataProvider dataProvider, String sessionId) {

        // Get proxy
        WikittyProxy proxy = getProxy(dataProvider);

        // Restore session
        Session session = proxy.restore(Session.class, sessionId);

        // Get all sending ids
        return EmailDataHelper.getAllSending(session);
    }
}
