/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: UserListSelectorHandler.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/admin/widget/UserListSelectorHandler.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.widget;

import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.services.VradiService;
import org.nuiton.wikitty.WikittyProxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UserListSelectorHandler extends AdminListSelectorHandler<User> {


    static private final Log log = LogFactory.getLog(UserListSelectorHandler.class);

    protected Group bean;

    protected VradiEntitiesListener<Group> groupVradiEntitiesListener;

    public UserListSelectorHandler(ListSelectorUI<User> listSelector) {
        super(listSelector);

        VradiContext.get().getVradiNotifier().addVradiListener(User.class, this);
        groupVradiEntitiesListener = new VradiEntitiesListener<Group>() {

            @Override
            public void entitiesAdded(Set<Group> added) {
                if (log.isDebugEnabled()) {
                    log.debug("[UserListSelectorHandler] group added");
                }
                if (added.contains(bean)) {
                    updateAll();
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
                if (log.isDebugEnabled()) {
                    log.debug("[UserListSelectorHandler] group removed");
                }
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(Group.class, groupVradiEntitiesListener);
    }

    public Group getBean() {
        return bean;
    }

    public void setBean(Group bean) {
        this.bean = bean;
    }

    protected void updateAll() {
        String wikittyId = bean.getWikittyId();

        // Update bean
        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        bean = wikittyProxy.restore(Group.class, wikittyId);

        List<User> users = updateList(wikittyProxy);
        updateCombo(users);
    }

    protected List<User> updateList(WikittyProxy wikittyProxy) {

        // Fill list with users
        Set<String> usersIds = bean.getUser();
        if (usersIds != null) {
            List<User> users = wikittyProxy.restore(User.class, new ArrayList<String>(usersIds));
            setListDatas(users);

            idsInList.clear();
            idsInList.addAll(VradiHelper.extractIds(users));
            return users;
        }
        return Collections.EMPTY_LIST;
    }

    protected void updateCombo(List<User> userInList) {

        // Fill list with groups
        VradiDataService vradiDataService = VradiService.getVradiDataService();
        List<User> allUsers = vradiDataService.findAllUsers();
        allUsers.removeAll(userInList);
        setComboDatas(allUsers);

        idsInCombo.clear();
        idsInCombo.addAll(VradiHelper.extractIds(allUsers));
    }

    @Override
    public void entitiesAdded(Set<User> usersAdded) {
        if (log.isDebugEnabled()) {
            log.debug("[UserListSelectorHandler] user added");
        }

        if (bean == null) {
            return;
        }

        for (User added : usersAdded) {
            String wikittyId = added.getWikittyId();
            if (bean.getUser() != null && bean.getUser().contains(wikittyId)) {
                if (!idsInList.contains(wikittyId)) {
                    updateAll();
                }
            } else {
                // Remove if is in list
                if (idsInList.contains(wikittyId)) {
                    updateAll();
                } else if (!idsInCombo.contains(wikittyId)) {
                    idsInCombo.add(wikittyId);
                    WikittyProxy proxy = VradiService.getWikittyProxy();
                    setComboDatas(proxy.restore(User.class, idsInCombo));
                }
            }
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        if (log.isDebugEnabled()) {
            log.info("[UserListSelectorHandler] user removed");
        }

        for (String wikittyId : removed) {
            WikittyProxy proxy = VradiService.getWikittyProxy();
            if (idsInCombo.contains(wikittyId)) {
                idsInCombo.remove(wikittyId);
                List<User> users = proxy.restore(User.class, idsInCombo);
                setComboDatas(users);
            }
            if (idsInList.contains(wikittyId)) {
                idsInList.remove(wikittyId);
                List<User> users = proxy.restore(User.class, idsInList);
                setListDatas(users);
            }
        }
    }
}
