/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.HidorButton;
import jaxx.runtime.swing.ListSelectorUI;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.User;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.AdminContentUI;
import org.chorem.vradi.ui.admin.helpers.AdminBeanConstant;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.admin.widget.GroupListSelectorHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.renderers.EntityRenderer;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class AdminUserUI extends AdminContentUI<User> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_IN_GROUP = "inGroup";
    public static final String PROPERTY_USER_GROUPS_HANDLER = "userGroupsHandler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CREATE_BUTTON_VISIBLE = "createButton.visible";
    public static final String BINDING_TITLE_TEXT = "title.text";
    public static final String BINDING_USER_ADDRESS_TEXT = "userAddress.text";
    public static final String BINDING_USER_BEGIN_SEARCH_DATE_DATE = "userBeginSearchDate.date";
    public static final String BINDING_USER_EMAIL_TEXT = "userEmail.text";
    public static final String BINDING_USER_ENABLE_SELECTED = "userEnable.selected";
    public static final String BINDING_USER_GROUPS_VISIBLE = "userGroups.visible";
    public static final String BINDING_USER_NAME_TEXT = "userName.text";
    public static final String BINDING_USER_PHONE_TEXT = "userPhone.text";
    public static final String BINDING_USER_SERVICE_TEXT = "userService.text";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$ADMIN_CONTENT_UI0_ENABLED = "$AdminContentUI0.enabled";
    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON0_VISIBLE = "$JButton0.visible";
    private static final String BINDING_$JLABEL7_VISIBLE = "$JLabel7.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(AdminUserUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table adminUserForm;
    protected User bean;
    protected JButton createButton;
    protected Boolean inGroup;
    protected JLabel title;
    protected JTextField userAddress;
    protected JXDatePicker userBeginSearchDate;
    @ValidatorField( validatorId = "validator",  propertyName = "email",  editorName = "userEmail")
    protected JTextField userEmail;
    protected JCheckBox userEnable;
    protected ListSelectorUI<Group> userGroups;
    protected GroupListSelectorHandler userGroupsHandler;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "userName")
    protected JTextField userName;
    protected JTextField userPhone;
    protected JTextField userService;
    @Validator( validatorId = "validator")
    protected SwingValidator<User> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminUserUI $AdminContentUI0 = this;
    private JPanel $JPanel0;
    private JButton $JButton0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JButton $JButton1;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private Table $Table0;
    private JLabel $JLabel7;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
    
        AutoCompleteDecorator.decorate(userGroups.getCombo(), EntityRenderer.getInstance());
    
        userGroups.addPropertyChangeListener("modified", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean b = (Boolean) evt.getNewValue();
                if (b != null && b) {
                    log.info("modified changed from groups");
                    setModified(true);
                }
            }
        });
        errorTable.registerValidator(validator);
    
        userGroupsHandler = new GroupListSelectorHandler(userGroups);
        userGroups.setHandler(userGroupsHandler);
    }
    
    @Override
    protected void postLoadBean() {
        VradiTreeNode parentNode = getHelper().getParentCategoryNode(getHelper().getSelectedNode(), AdminBeanConstant.GROUP.getCategoryName());
        setInGroup(parentNode != null);
    
        createButton.setEnabled(!isInCreation());
    
        userGroupsHandler.setBean(bean);
        if (bean == null) {
            // Clear all user
            userGroups.init(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    
            return;
        }
    
        java.util.List<Group> toCombo = getHandler().getAllGroups();
    
        java.util.List<Group> toList = new ArrayList<Group>();
        try {
            toList = VradiService.getVradiDataService().getGroupsForUser(bean.getWikittyId());
        } catch (VradiException eee){
            log.error("Could not retrieve groups for user : " + bean.getName(),
                    eee);
        }
        
        toCombo.removeAll(toList);
    
        userGroups.init(toCombo, toList);
        userGroupsHandler.setBean(bean);
    }
    
    @Override
    public void save() {
    
        // groups to save
        Map<String, Group> groups = new HashMap<String, Group>();
    
        if (log.isDebugEnabled()){
            log.debug("Will save user " + bean.getName());
        }
    
        String wikittyId = bean.getWikittyId();
    
        // FIXME EC20100628 move this code to handler
        //Remove the groups that were remove from the list.
        for (Group g : userGroups.getComboDatas()) {
        
            if (g != null && g.getUser() != null && g.getUser().contains(wikittyId)) {
    
                if (log.isDebugEnabled()){
                    log.debug("Removing user " + bean.getName() + " from group " + g.getName());
                }
    
                // group was containing user, but no more
                g.removeUser(wikittyId);
                
                // mark it for save
                groups.put(g.getWikittyId(), g);
            }
        }
    
        //Add groups that have been added to the list
        for (Group g : userGroups.getListDatas()) {
    
            if (g != null) {
    
                if (log.isDebugEnabled()){
                    log.debug("Adding user " + bean.getName() + " to group " +g.getName());
                }
    
                g.addUser(wikittyId);
                //mark group for save
                groups.put(g.getWikittyId(), g);
            }
    
        }
    
        //Effectively save bean
        User user = getHandler().saveUser(this, getHelper(), bean, groups.values());
    
        AdminNavigationTreeHelper helper = getHelper();
        VradiTreeNode userNode = helper.findNode(helper.getRootNode(), user.getWikittyId());
        helper.refresh(userNode);
    
        //FIXME JC 25/08/2010 bean is the same (because of cache ?) so no property change fired. Set bean to null before to force fire.
        setModified(false);
        setBean(null);
        setBean(user);
    
        userGroups.setModified(false);
    }
    
    @Override
    protected void clearUI() {
        title.setText(updateTitle(""));
        userName.setText("");
        userService.setText("");
        userAddress.setText("");
        userPhone.setText("");
        userEmail.setText("");
        userBeginSearchDate.setDate(null);
        userEnable.setSelected(false);
    }
    
    protected String updateTitle(String name) {
       return _("vradi.adminUser.title", getStringValue(name));
    }
    
    protected void openAddressInBrowser() {
        UIHelper.openAddressInBrowser(getBean().getAddress());
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminUserUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminUserUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AdminUserUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminUserUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminUserUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminUserUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminUserUI() {
        $initialize();
    }

    public AdminUserUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().delete(this, getHelper(), getBean());
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        openAddressInBrowser();
    }

    public void doActionPerformed__on__createButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().createUser(this, getHelper().getClientSelected());setModified(true);
    }

    public void doActionPerformed__on__userBeginSearchDate(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setBeginSearchDate(userBeginSearchDate.getDate());
    }

    public void doActionPerformed__on__userEnable(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setEnable(userEnable.isSelected());
    }

    public void doKeyReleased__on__userAddress(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setAddress(userAddress.getText());
    }

    public void doKeyReleased__on__userEmail(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setEmail(userEmail.getText());
    }

    public void doKeyReleased__on__userName(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setName(userName.getText());                                                title.setText(updateTitle(getBean().getName()));
    }

    public void doKeyReleased__on__userPhone(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setPhone(userPhone.getText());
    }

    public void doKeyReleased__on__userService(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getBean().setService(userService.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Table getAdminUserForm() {
        return adminUserForm;
    }

    public User getBean() {
        return bean;
    }

    public JButton getCreateButton() {
        return createButton;
    }

    public Boolean getInGroup() {
        return inGroup;
    }

    public JLabel getTitle() {
        return title;
    }

    public JTextField getUserAddress() {
        return userAddress;
    }

    public JXDatePicker getUserBeginSearchDate() {
        return userBeginSearchDate;
    }

    public JTextField getUserEmail() {
        return userEmail;
    }

    public JCheckBox getUserEnable() {
        return userEnable;
    }

    public ListSelectorUI<Group> getUserGroups() {
        return userGroups;
    }

    public GroupListSelectorHandler getUserGroupsHandler() {
        return userGroupsHandler;
    }

    public JTextField getUserName() {
        return userName;
    }

    public JTextField getUserPhone() {
        return userPhone;
    }

    public JTextField getUserService() {
        return userService;
    }

    public SwingValidator<User> getValidator() {
        return validator;
    }

    public Boolean isInGroup() {
        return inGroup !=null && inGroup;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(User bean) {
        User oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setInGroup(Boolean inGroup) {
        Boolean oldValue = this.inGroup;
        this.inGroup = inGroup;
        firePropertyChange(PROPERTY_IN_GROUP, oldValue, inGroup);
    }

    public void setUserGroupsHandler(GroupListSelectorHandler userGroupsHandler) {
        GroupListSelectorHandler oldValue = this.userGroupsHandler;
        this.userGroupsHandler = userGroupsHandler;
        firePropertyChange(PROPERTY_USER_GROUPS_HANDLER, oldValue, userGroupsHandler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected JLabel get$JLabel7() {
        return $JLabel7;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminUserForm() {
        if (!allComponentsCreated) {
            return;
        }
        adminUserForm.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userService, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userAddress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JButton1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userPhone, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel4, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(SwingUtil.boxComponentWithJxLayer(userEmail), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel5, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add(userBeginSearchDate, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JLabel6, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        adminUserForm.add($JPanel1, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(adminUserForm, BorderLayout.NORTH);
        body.add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(title, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        toolbar.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createAdminUserForm() {
        $objectMap.put("adminUserForm", adminUserForm = new Table());
        
        adminUserForm.setName("adminUserForm");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
    }

    protected void createCreateButton() {
        $objectMap.put("createButton", createButton = new JButton());
        
        createButton.setName("createButton");
        createButton.setText(_("vradi.adminUser.createUser"));
        createButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__createButton"));
    }

    protected void createInGroup() {
        $objectMap.put("inGroup", inGroup = false);
    }

    protected void createTitle() {
        $objectMap.put("title", title = new JLabel());
        
        title.setName("title");
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont((float) 20));
        }
        if (title.getFont() != null) {
            title.setFont(title.getFont().deriveFont(title.getFont().getStyle() | Font.BOLD));
        }
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        toolbar.setName("toolbar");
        toolbar.setLayout(
          new BoxLayout(toolbar, 0)
        );
        toolbar.putClientProperty("help", 
        "ui.main.toolbar"
        );
    }

    protected void createUserAddress() {
        $objectMap.put("userAddress", userAddress = new JTextField());
        
        userAddress.setName("userAddress");
        userAddress.setColumns(15);
        userAddress.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userAddress"));
    }

    protected void createUserBeginSearchDate() {
        $objectMap.put("userBeginSearchDate", userBeginSearchDate = new JXDatePicker());
        
        userBeginSearchDate.setName("userBeginSearchDate");
        userBeginSearchDate.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userBeginSearchDate"));
    }

    protected void createUserEmail() {
        $objectMap.put("userEmail", userEmail = new JTextField());
        
        userEmail.setName("userEmail");
        userEmail.setColumns(15);
        userEmail.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userEmail"));
    }

    protected void createUserEnable() {
        $objectMap.put("userEnable", userEnable = new JCheckBox());
        
        userEnable.setName("userEnable");
        userEnable.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__userEnable"));
    }

    protected void createUserGroups() {
        $objectMap.put("userGroups", userGroups = new ListSelectorUI<Group>());
        
        userGroups.setName("userGroups");
        userGroups.setShowHidor(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setOpaque(false);
        ((javax.swing.JToolBar) userGroups.getObjectById("actions")).setBorderPainted(false);
    }

    protected void createUserGroupsHandler() {
        $objectMap.put("userGroupsHandler", userGroupsHandler = null);
    }

    protected void createUserName() {
        $objectMap.put("userName", userName = new JTextField());
        
        userName.setName("userName");
        userName.setColumns(15);
        userName.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userName"));
    }

    protected void createUserPhone() {
        $objectMap.put("userPhone", userPhone = new JTextField());
        
        userPhone.setName("userPhone");
        userPhone.setColumns(15);
        userPhone.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userPhone"));
    }

    protected void createUserService() {
        $objectMap.put("userService", userService = new JTextField());
        
        userService.setName("userService");
        userService.setColumns(15);
        userService.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__userService"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(User.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToToolbar();
        // inline complete setup of $JPanel0
        $JPanel0.add(createButton);
        $JPanel0.add($JButton0);
        addChildrenToBody();
        addChildrenToAdminUserForm();
        // inline complete setup of $JPanel1
        $JPanel1.add(userEnable, BorderLayout.WEST);
        $JPanel1.add($JPanel2, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add($JLabel7, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(userGroups, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 15 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("client.delete"));
        adminUserForm.setMinimumSize(SwingUtil.newMinDimension());
        $JButton1.setIcon(SwingUtil.getUIManagerActionIcon("site"));
        userGroups.setAddToComboTip(_("vradi.adminUser.removeGroup"));
        userGroups.setAddToListTip(_("vradi.adminUser.addGroup"));
        userGroups.setHandler(userGroupsHandler);
        userGroups.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        title.setHorizontalAlignment(
          javax . swing . SwingConstants . LEFT
        );
        title.setHorizontalTextPosition(
          JLabel . LEFT
        );
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$AdminContentUI0", $AdminContentUI0);
        createBean();
        createInGroup();
        createValidator();
        createUserGroupsHandler();
        createTitle();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        createCreateButton();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setToolTipText(_("vradi.adminUser.deleteUser"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createAdminUserForm();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminUser.name"));
        createUserName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminUser.service"));
        createUserService();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.adminUser.adresse"));
        createUserAddress();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.adminUser.phone"));
        createUserPhone();
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.adminUser.mail"));
        createUserEmail();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.adminUser.beginSearchDate"));
        createUserBeginSearchDate();
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.admin.userEnable"));
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createUserEnable();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.adminClient.listGroup"));
        createUserGroups();
        // inline creation of $AdminContentUI0
        setName("$AdminContentUI0");
        ((jaxx.runtime.swing.Table) $AdminContentUI0.getObjectById("toolbar")).setLayout(
          new BoxLayout(toolbar, 0)
        );
        
        
        // registers 15 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 15 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$ADMIN_CONTENT_UI0_ENABLED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                setEnabled(getBean() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(isEnabled() ? bean : null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    title.setText(_(updateTitle(getBean().getName())));
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_BUTTON_VISIBLE, true ,"inGroup" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                createButton.setVisible(!isInGroup() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"enabled" ,"inCreation") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isEnabled() && !isInCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_NAME_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(userName, getBean().getName());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_SERVICE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(userService, getBean().getService());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_ADDRESS_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(userAddress, getBean().getAddress());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_PHONE_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(userPhone, getBean().getPhone());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_EMAIL_TEXT, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(userEmail, getBean().getEmail());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_BEGIN_SEARCH_DATE_DATE, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    userBeginSearchDate.setDate(getBean().getBeginSearchDate());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_ENABLE_SELECTED, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    userEnable.setSelected(getBean().getEnable());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL7_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                $JLabel7.setVisible(!isInGroup());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_USER_GROUPS_VISIBLE, true ,"inGroup") {
        
            @Override
            public void processDataBinding() {
                userGroups.setVisible(!isInGroup());
            }
        });
    }

}