/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.content.AdminStatusUI;
import org.chorem.vradi.ui.admin.content.AdminThesaurusHandler;
import org.chorem.vradi.ui.admin.content.AdminThesaurusUI;
import org.chorem.vradi.ui.admin.helpers.ClientNavigationTreeHelper;
import org.chorem.vradi.ui.admin.helpers.FormTypeNavigationTreeHelper;
import org.chorem.vradi.ui.admin.helpers.GroupNavigationTreeHelper;
import org.chorem.vradi.ui.admin.helpers.XmlStreamNavigationTreeHelper;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import static org.nuiton.i18n.I18n._;

public class AdminPopupUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1ZQXPbuBmlFcu25CR2rNheZ5Os4ro7zjShN9m202l22rUdybGrdTyW0snUBy8kQhI2FMGQoK3sznb6E/oT2nsvnemtp04PPfewl539C51OD712+gEQKYIiJYrezMSSgA8P7z0AH0DwT//S8q6jPfgC9fu641mM9LB+tPv69cvmF7jFnmO35RCbUUeT/2ZyWu5MWzSCcpdpPzir8eY7g+Y7+7RnUwtbodbPalrRZe9M7HYxZky7p7Zoue5OPah+1rc9x0cNSMWh/uE//8793vjdH3Oa1reB3TJIKU9qNVQyW9NyxGDaCvR0gXZMZHWAhkOsDvC9wcv2TeS6x6iH32q/1eZr2pyNHABj2mZ6yQJDtO/bTLuOjB6xTqjt2a8OmfYhdTp6q0sd3NMvHGQQ3SO6CNF3Q4G2LRDmmFbaqosODi3CCDLJl9j5CGCE6BawICZ2dMlBH4kcwhREHw3UhPFb50r7unsJwvUjKGti4wRZQnMhaLHcMgkIFKyO0QUnvzWBvAjjzZcClKWOQz1brb2thtxsU6c3NqLU75kwThiND1sUVOoMMQ9U7iSTbVGLgTRJWsZHed+UfnWxizyHwz1NCRc0iSIWto72PMaoBcNXUkZAFqvuF7ZgXA6tNoXoO8oMl40GtfZogye84MOYiqdJFR8nVfw4qeInfoWjva+Qg4WtDxf2cOXNnGl5x4Nipr13NpoLTqFKZoH3IlmAA4ra/62Vvvnrd3+p+kt/B/pejQ0NZS5YkrZDbewwwrtekuveY8Tc+QzZz860gotNSHsird2NIVYfVAM56O8Wb67z5voL5HYBIj//7d/+vvb5P69puapWNCkyqojHH2oF1nXABWoaffuXnwpG1y8XeM6C/9fAyzZEM9Q0waZ8G5kufM5RG731QgU3mtQxsHOCCMwwwy/vg093Y3wKyDYL//hvqf7nT32vZoD7RmL40K/8b7Q5YpnEwiJRDnJgbGJctF3sGXSY6+Kynwb5b+GoQam5h/xc9FPx9+dxlizzhUQsj3puDb2jsCq0WeZwP1Yg1zao1+pW+jayDOnaoG7RIBcETKpDwmNa7snTvsd72BO6+bfnnEbxqG6bhPE0N4HILCxPWObkSyCDzF2TdKye2AIef1Usl8XCLetlsQrhs84/96nlMmQxFwr2K8eNymnxaz7CgPDYlbSewjpeG8I2cJ+dUBcSNfzUVjnyUQ01sakgLAqES0w6Xe5Fk0+mOHFzsi18yzPCYJVl0vejVPpqlWpjOnUlRZ3ffnptBaGthtssm75HqfSdHh68mFLgbUVgADC9wqJQeMobjJWY8wcapMq9SPzSL7EJRwIoXTVwG3km2zepi19C/kODoTDouUVZFzSfU+u8xatHOYH2HmScqgPL3Z6wWmaAynlXsF/5qrgJeyJvqoPj3mbx6zjsWV43CfYaX95gMuRsKZA30tuES17oWbhHLdJi2kx12P16pHsRncBhgQdUoT49j40ID52229ipEZepjF4OGT2IYzRsl8CtxEPrXXr50g/kx8HxNPMBzTuSJmxCMOD8ZNImHc8f/jDPfZhuMuqQp11tTsbCtGWQrxvEbgi8+8l4MOnsodgfxopVGiQIXvUHYz8cnF7yWnRkTNpC0YkSlVtgDrJcEzEcVZwI5yu9H6tURiVIXPYl1uCRw0OdifMO1M1ji+9zsOsf8PzyoIxaLWyzmuhn+9ecpDTsBbCCZ4AO9uvgm6zZfvjwUXmz7ZxXTzcf8pSkOjYYVMlcbzsRi+bJk59Zj3mxatCd+NbqdIif+0Fwgk8rUZ+qp5OcmvsencLW+cHeZKe8N+rcehVrHI9KYZz3ZgrjvDdpjXv1qxTGDUSuK7zanmnC8yTGXMkFcYk4bK1LZ4n7yjJwi8Iaxca2cCrsxEnEiWIYTDXj/YROVTc2Y90YRk+yoxpEprdjQ2FmwcMpijEEzmyKGeXt8ogdxxE7lk2MLvDjZFPuJXat2rIdP0ki6Anm3PbNOQ7hp0+3txSOuE8iG+DriOhZGaIKXR0BUQXejRXI4xJEXfdFVSAm4+kC7FClfDbudAHRY08XUJ+ex0qIhzTFVansDqlsRKnIBglkFnnIroRMz2c5zIdfaySymebYVRBcOFx6JrdCTOSN1MjGns2YpYDMvoDNZo643lIZHWRldDNgdMBR0xMqRWZx452dfE6ejtONgNN0E/p2iFJwezeSKLJxWgk4vfaRs80nd3BVGGZVv/p8kjeK2bxiwxvHMKvG1b0KLiazTXQMHZoqqcoVskCFw6VnshZlEpeVMqeC4cKbktZ6iBbp2dRhlT7/q/I6zOaTeGg4DKGm53U/gRfsoKP0KlltK4qB/L6oyR+JzmWgJr1LT+2DJGoOJnDQ66vcTq+0I59KyGwnFdlrmAweM8V48biTCn8qynr8i2WiHv9kyLjjH4+YcPwTIWOEXPeFXEWMS1hk23SjYmTIODE8Io0YHjdJTB1i0otZUXigprhAj5zaFDX5QUzs/UcYRtVzL1aPCBx3iOCCdnlQiivFmP3HwE2vk7idPOe16YEj4w77dSJtgcx39BQPkIU2bXmu+k5HcXxB3Lg2UDNquvrM+dYj7EWwKJYcapr0AjsV/5pj/Ouh4UiVQyPVpMY7OVI+h6Sc4NdPEpxj2pw5eE/zAb8esPBleY/25bubba6viZxH5Y/Ec7HPaTXEaRCSQGR+UJ1iWJPuu29+YiCGyk3ItcTq/GKklxn+t5iig4FQqM9tZEfxL+1XPpFv2cqIMYc0PYavQC3fowY2xzBbTgGy7HbpZfiswfG24vFKE/F4Y30MwlqalUpa4p14kqrNtKt9DA+O8X/E9iJGESMAAA==";
    private static final Log log = LogFactory.getLog(AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected AdminStatusUI adminStatus;
    protected JTabbedPane adminTabs;
    protected AdminThesaurusUI adminThesaurus;
    protected AdminNavUI clientAdminNavUI;
    protected AdminNavUI formAdminNavUI;
    protected AdminNavUI groupAdminNavUI;
    protected AdminNavUI xmlStreamAdminNavUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JButton $JButton0;
    private TabInfo $TabInfo0;
    private TabInfo $TabInfo1;
    private TabInfo $TabInfo2;
    private TabInfo $TabInfo3;
    private TabInfo $TabInfo4;
    private TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    private VradiDataProvider dataProvider;
    
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void close(){
        Component selected = adminTabs.getSelectedComponent();
        AdminHandler handler = getHandler();
    
        // Nothing for thesaurus
        if (selected instanceof AdminThesaurusUI) {
            handler.close(this);
        }
        AdminContentUI currentContent;
    
        // Status ui is not nav ui
        if (selected instanceof AdminStatusUI) {
            currentContent = (AdminStatusUI) selected;
        } else {
            currentContent = getCurrentContent();
    
            // if is thesaurus selected
            if (currentContent == null){
                handler.close(this);
                return;
            }
        }
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminContentUI getCurrentContent() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminNavUI) {
            return ((AdminNavUI)selected).getCurrentContent();
        } else if (selected instanceof AdminStatusUI) {
            return (AdminContentUI) selected;
        }
        return null;
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI ||
            selected instanceof AdminStatusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminStatusUI getStatusTab(){
        return (AdminStatusUI)adminTabs.getComponentAt(4);
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(5);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI(JAXXContext parentContext, Window parent) {
        super();
            SwingUtil.initContext(this, parentContext);
            selectionModel = new DefaultSingleSelectionModel() {
                private static final long serialVersionUID = 1L;
        
                @Override
                public void setSelectedIndex(int index) {
                    int oldIndex = getSelectedIndex();
                    if (oldIndex != -1) {
                        // on verifie que l'onglet en cours n'est pas modifie
                        AdminContentUI<?> content = getCurrentContent();
        
                        // null if is thesaurus selected
                        if (content != null){
                            boolean canContinue = getHandler().answerToSave(content);
                            if (!canContinue) {
                                // l'utilisateur ne veut pas partir au final
                                return;
                            }
                        }
                    }
                    super.setSelectedIndex(index);
                }
            };
            contextInitialized = true;
            this.pack();
            $initialize();
    }

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminPopupUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminPopupUI(String param0) {
        super(param0);
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminPopupUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    public void doWindowClosing__on__adminPopupUI(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminStatusUI getAdminStatus() {
        return adminStatus;
    }

    public JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    public AdminNavUI getClientAdminNavUI() {
        return clientAdminNavUI;
    }

    public AdminNavUI getFormAdminNavUI() {
        return formAdminNavUI;
    }

    public AdminNavUI getGroupAdminNavUI() {
        return groupAdminNavUI;
    }

    public AdminNavUI getXmlStreamAdminNavUI() {
        return xmlStreamAdminNavUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add(clientAdminNavUI);
        adminTabs.add(groupAdminNavUI);
        adminTabs.add(formAdminNavUI);
        adminTabs.add(xmlStreamAdminNavUI);
        adminTabs.add(adminStatus);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.status"));
        $TabInfo5.addPropertyChangeListener(new TabInfoPropertyChangeListener(adminTabs, 5));
        adminTabs.setTitleAt(5, _("vradi.admin.thesaurus"));
    }

    protected void createAdminStatus() {
        $objectMap.put("adminStatus", adminStatus = new AdminStatusUI(this));
        
        adminStatus.setName("adminStatus");
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont((float) 20));
        }
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new JTabbedPane());
        
        adminTabs.setName("adminTabs");
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new AdminThesaurusUI(this, new ThesaurusTreeTableHelper()));
        
        adminThesaurus.setName("adminThesaurus");
    }

    protected void createClientAdminNavUI() {
        $objectMap.put("clientAdminNavUI", clientAdminNavUI = new AdminNavUI(this, new ClientNavigationTreeHelper(dataProvider)));
        
        clientAdminNavUI.setName("clientAdminNavUI");
        clientAdminNavUI.setShowImportExport(true);
    }

    protected void createFormAdminNavUI() {
        $objectMap.put("formAdminNavUI", formAdminNavUI = new AdminNavUI(this, new FormTypeNavigationTreeHelper(dataProvider)));
        
        formAdminNavUI.setName("formAdminNavUI");
    }

    protected void createGroupAdminNavUI() {
        $objectMap.put("groupAdminNavUI", groupAdminNavUI = new AdminNavUI(this, new GroupNavigationTreeHelper(dataProvider)));
        
        groupAdminNavUI.setName("groupAdminNavUI");
        groupAdminNavUI.setShowImportExport(true);
    }

    protected void createXmlStreamAdminNavUI() {
        $objectMap.put("xmlStreamAdminNavUI", xmlStreamAdminNavUI = new AdminNavUI(this, new XmlStreamNavigationTreeHelper(dataProvider)));
        
        xmlStreamAdminNavUI.setName("xmlStreamAdminNavUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(SwingUtil.getUIManagerActionIcon("close"));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalAlignment(
          javax . swing . SwingConstants . LEFT
        );
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalTextPosition(
          JLabel . LEFT
        );
        // late initializer
        adminPopupUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated|| !contextInitialized) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("adminPopupUI", adminPopupUI);
        dataProvider = new VradiDataProvider();
        createAdminTabs();
        createClientAdminNavUI();
        createGroupAdminNavUI();
        createFormAdminNavUI();
        createXmlStreamAdminNavUI();
        createAdminStatus();
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new TabInfo());
        
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new TabInfo());
        
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new TabInfo());
        
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new TabInfo());
        
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new TabInfo());
        
        $TabInfo4.setTitle(_("vradi.admin.status"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new TabInfo());
        
        $TabInfo5.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.admin.title"));
        adminPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}