/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.entities.ModificationTag;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyExtension;
import static org.nuiton.i18n.I18n._;

public abstract class AdminContentUI<B> extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_CREATION = "creation";
    public static final String PROPERTY_MODIFIED = "modified";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_LAYER_UI_BLOCK = "blockLayerUI.block";
    public static final String BINDING_CANCEL_ENABLED = "cancel.enabled";
    public static final String BINDING_COMMON_ACTIONS_VISIBLE = "commonActions.visible";
    public static final String BINDING_CREATE_ENABLED = "create.enabled";
    public static final String BINDING_CREATE_VISIBLE = "create.visible";
    public static final String BINDING_SAVE_ENABLED = "save.enabled";
    public static final String BINDING_SAVE_VISIBLE = "save.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTW8TRxieuLZDAklJwkcQHw0fUqOqWgOHqiURkARFCbWhIkmFaqnq7O7UHpid2c7MOpseqv6E/gS4c0Hixglx4MyBC+IvIMSBa9V3xmtvNmycVe3DePed93nmeZ/Z933yHlWUROcf4Dh2ZMQ1DYhze+n+/bvuA+LpW0R5koZaSNT9jZRQqYkO+/240uhis27gtQReWxFBKDjhu9ALdTSu9A4jqk2I1uhsFuEpVdvoby/EYSR7rH1ReayPPn4o/eP//biEUByCukkoZe4gVFpJuY5K1NdoGk7q4BrDvAUyJOUt0DthYisMK3UHB+QP9BcaraNqiCWQaXSheMmWw+LjUKNDl27/hDlhlzWaF7LleG0hSeB0JPapE1EH+wHlzpJZVwTXQLm1HoYWXwV0IHz6OyUgesroc4xmZ1kIRjDfleZJgjUV3LxPpvFqBzPqkz3RIy4T3sM63iFyax1Kyxiotqk5wWTAQ5KUYseJlEJuYpcRjRYzSHsWBicSjg2z/twLNohSuEUssiF8wlLOUQ31uFhqNJsjxSJM5lgfUHaFvwPXaByJk7Suy9m8CU8EgeBLnrHGBk9nE3qXc8W8nzPLV/29KbhG3Ujst1kanczRt7Ys4iyy6mHumfSZjMDlSOvuDaWpZYU7trj5vRTmQjM7Ep3OnA495KQ9lH7kI01UkRGEwc7m5213D7a6DTe7p+EMod3998TMm+fvnq32umwazj6em7prSMDXH0oREqmpOfrLbotFmrJaA4cLTTSmCIMJYyfImRxhG8k2iIPzul+7gTtrWLWBojL69sXLE7+9/gKVVtE4E9hfxSZ/HY3ptgQXBPPj8MZNq+jI9iFYjxptYCbDOwLMR5OL8CniOZdyH27kegwmnMkxoa/EHXv1aWbj6c2eESMg7NS+6akZlV9QlXJGObEDJ5kluQPmcKhI5It0ZuRNkRHzPx4mHXPVrt/lVVqxnW22f4gj83fNqjZPi5bkWAGSCTdp/hXBhBySbDRSZN2DwYamF7uWzGENI9eNNLn+f2lN+PsBws4WEdahiiaTZR+auQI0MzDO6Z9QH2ZLjLZ4AAPcJP+YT3mpAGWZet0xsY+sr4tUR7gZm/6QNGVN4kHlHMxhwr8OUPFNIQZvaIb2gCqKMWwOrWGQD98O7UMxhkE+FGMY5INh+A+DiqmoYgoAAA==";
    private static final Log log = LogFactory.getLog(AdminContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BlockingLayerUI blockLayerUI;
    protected JPanel body;
    protected JButton cancel;
    protected Table commonActions;
    protected JButton create;
    protected Boolean creation;
    protected SwingValidatorMessageTableModel errorTable;
    protected HBox lastModifiedPanel;
    protected Boolean modified;
    protected JButton save;
    protected Table toolbar;
    protected Boolean valide;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AdminContentUI<B> $JPanel0 = this;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    /**
     * @return the editing bean of the content
     */
    public abstract B getBean();
    
    /**
     * @param bean selected
     */
    public abstract void setBean(B bean);
    
    /**
     * Call after set bean
     */
    protected abstract void postLoadBean();
    
    /**
     * Save the editing bean
     */
    public abstract void save();
    
    /**
     * Save the editing bean and unmodify the form
     */
    public void postSave() {
        setModified(false);
        save();
    }
    
    public void cancel() {
        getHandler().cancel(this, getHelper().getSelectedNode(), true);
    }
    
    protected AdminNavigationTreeHelper getHelper() {
        return getContextValue(AdminNavigationTreeHelper.class);
    }
    
    public AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected Icon updateCollapseIcon(boolean c) {
        String key = c ? "collapseIcon" : "expandIcon";
        Icon i = (Icon) getClientProperty(key);
        return i;
    }
    
    protected void addBusinessEntityModifiedPCS(BusinessEntity bean) {
        if (bean != null) {
            bean.addPropertyChangeListener(new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (isEnabled()) {
                        setModified(true);
                    }
                }
            });
        }
    }
    
    protected void addBusinessEntityPCSLogger(BusinessEntity bean) {
        if (bean != null) {
            bean.addPropertyChangeListener(new PropertyChangeListener() {
    
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (log.isDebugEnabled()) {
                        log.debug("bean." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                    }
                }
            });
        }
    }
    
    protected void addPCSLogger() {
        addPropertyChangeListener(new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug("ui." + evt.getPropertyName() + " <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
                }
            }
        });
    }
                        
    void $afterCompleteSetup() {
        addPropertyChangeListener("bean", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getBean() != null) {
                    if (getBean() instanceof WikittyExtension) {
                        ((WikittyExtension)getBean()).addPropertyChangeListener(new PropertyChangeListener() {
    
                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if (isEnabled()) {
                                    setModified(true);
                                }
                            }
                        });
                    }
                    if (getBean() != null && getBean() instanceof BusinessEntity) {
                        BusinessEntity entity = (BusinessEntity)getBean();
                        lastModifiedPanel.removeAll();
    
                        // FIXME EC20100915 pour l'instant le test est fait car
                        // c'est la condition (hack) d'affichage des buttons
                        // sinon le cast rajoute l'extension est la condition est fausse
                        if (!isInCreation()) {
                            ModificationTag beanTag = VradiService.getWikittyProxy().cast(entity, ModificationTag.class);
                            Date lastModified = beanTag.getLastModified();
                            String lastModifier = beanTag.getLastModifier();
    
                            if (lastModified != null && lastModifier != null) {
                                String labelText = String.format(_("vradi.entity.lastModified.date.user"), lastModified, lastModifier);
                                lastModifiedPanel.add(new JLabel(labelText));
                            }
                            lastModifiedPanel.validate();
                        } else {
                            setModified(true);        
                        }
                        addBusinessEntityModifiedPCS((BusinessEntity)getBean());
                    }
                } else {
                    clearUI();
                }
                postLoadBean();
            }
        });
        setContextValue(errorTable, "errorTable");
        SwingUtil.getLayer(body).setUI(blockLayerUI);
    }
    
    /**
     * Renvoi vrai si le bean est en phase de creation.
     *
     * @return {@code true} si le bean est en phase de creation
     */
    protected boolean isInCreation() {
        B bean = getBean();
        if (bean == null || !(bean instanceof BusinessEntity)) {
            return false;
        }
        BusinessEntity entity = (BusinessEntity)bean;
        return !entity.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG);
    }
    
    protected abstract void clearUI();

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminContentUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AdminContentUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminContentUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AdminContentUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminContentUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public AdminContentUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AdminContentUI() {
        $initialize();
    }

    public AdminContentUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        cancel();
    }

    public void doActionPerformed__on__create(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        postSave();
    }

    public void doActionPerformed__on__save(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        postSave();
    }

    public void doTableChanged__on__errorTable(TableModelEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setValide(errorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BlockingLayerUI getBlockLayerUI() {
        return blockLayerUI;
    }

    public JPanel getBody() {
        return body;
    }

    public JButton getCancel() {
        return cancel;
    }

    public Table getCommonActions() {
        return commonActions;
    }

    public JButton getCreate() {
        return create;
    }

    public Boolean getCreation() {
        return creation;
    }

    public SwingValidatorMessageTableModel getErrorTable() {
        return errorTable;
    }

    public HBox getLastModifiedPanel() {
        return lastModifiedPanel;
    }

    public Boolean getModified() {
        return modified;
    }

    public JButton getSave() {
        return save;
    }

    public Table getToolbar() {
        return toolbar;
    }

    public Boolean getValide() {
        return valide;
    }

    public Boolean isCreation() {
        return creation !=null && creation;
    }

    public Boolean isModified() {
        return modified !=null && modified;
    }

    public Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setCreation(Boolean creation) {
        Boolean oldValue = this.creation;
        this.creation = creation;
        firePropertyChange(PROPERTY_CREATION, oldValue, creation);
    }

    public void setModified(Boolean modified) {
        Boolean oldValue = this.modified;
        this.modified = modified;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void setValide(Boolean valide) {
        Boolean oldValue = this.valide;
        this.valide = valide;
        firePropertyChange(PROPERTY_VALIDE, oldValue, valide);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommonActions() {
        if (!allComponentsCreated) {
            return;
        }
        commonActions.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(lastModifiedPanel, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(cancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(save, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        commonActions.add(create, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createBlockLayerUI() {
        $objectMap.put("blockLayerUI", blockLayerUI = new BlockingLayerUI());
        
        blockLayerUI.setUseIcon(false);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JPanel());
        
        body.setName("body");
        body.setLayout(new BorderLayout());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(_("vradi.common.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCommonActions() {
        $objectMap.put("commonActions", commonActions = new Table());
        
        commonActions.setName("commonActions");
    }

    protected void createCreate() {
        $objectMap.put("create", create = new JButton());
        
        create.setName("create");
        create.setText(_("vradi.common.create"));
        create.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__create"));
    }

    protected void createCreation() {
        $objectMap.put("creation", creation = false);
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new SwingValidatorMessageTableModel());
        
        errorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorTable"));
    }

    protected void createLastModifiedPanel() {
        $objectMap.put("lastModifiedPanel", lastModifiedPanel = new HBox());
        
        lastModifiedPanel.setName("lastModifiedPanel");
        lastModifiedPanel.setHorizontalAlignment(4);
    }

    protected void createModified() {
        $objectMap.put("modified", modified = false);
    }

    protected void createSave() {
        $objectMap.put("save", save = new JButton());
        
        save.setName("save");
        save.setText(_("vradi.common.save"));
        save.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__save"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new Table());
        
        toolbar.setName("toolbar");
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolbar, BorderLayout.NORTH);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(commonActions, BorderLayout.SOUTH);
        addChildrenToCommonActions();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        blockLayerUI.setBlockingColor(UIManager.getColor("BlockingLayerUI.blockingColor"));
        cancel.setIcon(SwingUtil.getUIManagerActionIcon("cancel"));
        save.setIcon(SwingUtil.getUIManagerActionIcon("save"));
        create.setIcon(SwingUtil.getUIManagerActionIcon("create"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createModified();
        createCreation();
        createValide();
        createBlockLayerUI();
        createErrorTable();
        createToolbar();
        createBody();
        createCommonActions();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createLastModifiedPanel();
        createCancel();
        createSave();
        createCreate();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        $JPanel0.putClientProperty("expandIcon", SwingUtil.createActionIcon("expand"));
        $JPanel0.putClientProperty("collapseIcon", SwingUtil.createActionIcon("collapse"));
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_LAYER_UI_BLOCK, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                blockLayerUI.setBlock(!isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMMON_ACTIONS_VISIBLE, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                commonActions.setVisible(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CANCEL_ENABLED, true ,"modified") {
        
            @Override
            public void processDataBinding() {
                cancel.setEnabled(isModified());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_ENABLED, true ,"modified" ,"valide") {
        
            @Override
            public void processDataBinding() {
                save.setEnabled(isModified() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAVE_VISIBLE, true ,"creation") {
        
            @Override
            public void processDataBinding() {
                save.setVisible(!isCreation());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_ENABLED, true ,"modified" ,"valide") {
        
            @Override
            public void processDataBinding() {
                create.setEnabled(isModified() && isValide());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREATE_VISIBLE, true ,"creation") {
        
            @Override
            public void processDataBinding() {
                create.setVisible(isCreation());
            }
        });
    }

}