/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import org.webharvest.exception.VariableException;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.ListVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;

public class CommonUtil {
    public static boolean isEmptyString(Object o) {
        return o == null || "".equals(o.toString().trim());
    }

    public static String nvl(Object value, String defaultValue) {
        return value != null ? value.toString() : defaultValue;
    }

    public static String adaptFilename(String filePath) {
        return filePath == null ? null : filePath.replace('\\', '/');
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static boolean isValidXmlIdentifier(String name) {
        if (!CommonUtil.isEmpty(name) && Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (Character.isJavaIdentifierPart(ch) || ch == '-') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isPathAbsolute(String path) {
        if (path == null) {
            return false;
        }
        int len = (path = CommonUtil.adaptFilename(path)).length();
        return len >= 1 && path.startsWith("/") || len >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':';
    }

    public static String getAbsoluteFilename(String workingPath, String filePath) {
        if (CommonUtil.isPathAbsolute(filePath = CommonUtil.adaptFilename(filePath))) {
            return filePath;
        }
        if ((workingPath = CommonUtil.adaptFilename(workingPath)).endsWith("/")) {
            workingPath = workingPath.substring(0, workingPath.length() - 1);
        }
        return workingPath + "/" + filePath;
    }

    public static String getDirectoryFromPath(String path) {
        path = CommonUtil.adaptFilename(path);
        int index = path.lastIndexOf("/");
        return path.substring(0, index);
    }

    public static String getFileFromPath(String path) {
        int i2;
        int i1 = path.lastIndexOf("/");
        if (i1 > (i2 = path.lastIndexOf("\\"))) {
            return path.substring(i1 + 1);
        }
        return path.substring(i2 + 1);
    }

    public static String getClassName(Object o) {
        if (o != null) {
            String processorClassName = o.getClass().getName();
            int dotIndex = processorClassName.lastIndexOf(46);
            if (dotIndex >= 0) {
                processorClassName = processorClassName.substring(dotIndex + 1);
            }
            return processorClassName;
        }
        return "null value";
    }

    public static String replicate(String s, int count) {
        String result = "";
        for (int i = 1; i <= count; ++i) {
            result = result + s;
        }
        return result;
    }

    private static String encodeUrlParam(String value, String charset) throws UnsupportedEncodingException {
        if (value == null) {
            return "";
        }
        try {
            String decoded = URLDecoder.decode(value, charset);
            String result = "";
            for (int i = 0; i < decoded.length(); ++i) {
                char ch = decoded.charAt(i);
                result = result + (ch == '#' ? "#" : URLEncoder.encode(String.valueOf(ch), charset));
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            return value;
        }
    }

    public static String encodeUrl(String url, String charset) {
        if (url == null) {
            return "";
        }
        int index = url.indexOf("?");
        if (index >= 0) {
            try {
                String result = url.substring(0, index + 1);
                String paramsPart = url.substring(index + 1);
                StringTokenizer tokenizer = new StringTokenizer(paramsPart, "&");
                while (tokenizer.hasMoreTokens()) {
                    String definition = tokenizer.nextToken();
                    int eqIndex = definition.indexOf("=");
                    if (eqIndex >= 0) {
                        String paramName = definition.substring(0, eqIndex);
                        String paramValue = definition.substring(eqIndex + 1);
                        result = result + paramName + "=" + CommonUtil.encodeUrlParam(paramValue, charset) + "&";
                        continue;
                    }
                    result = result + CommonUtil.encodeUrlParam(definition, charset) + "&";
                }
                if (result.endsWith("&")) {
                    result = result.substring(0, result.length() - 1);
                }
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new VariableException("Charset " + charset + " is not supported!", e);
            }
        }
        return url;
    }

    public static boolean isBooleanTrue(String value) {
        if (value != null) {
            return "1".equals(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
        }
        return false;
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        if ("1".equals(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("0".equals(value) || "false".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    public static int getIntValue(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double getDoubleValue(String value, double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String escapeXml(String s) {
        if (s != null) {
            StringBuffer result = new StringBuffer(s);
            int index = 0;
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '&') {
                    String sub = s.substring(i);
                    if (!(sub.startsWith("&amp;") || sub.startsWith("&apos;") || sub.startsWith("&gt;") || sub.startsWith("&lt;") || sub.startsWith("&quot;"))) {
                        result.replace(index, index + 1, "&amp;");
                        index += 5;
                        continue;
                    }
                    ++index;
                    continue;
                }
                if (ch == '\'') {
                    result.replace(index, index + 1, "&apos;");
                    index += 6;
                    continue;
                }
                if (ch == '>') {
                    result.replace(index, index + 1, "&gt;");
                    index += 4;
                    continue;
                }
                if (ch == '<') {
                    result.replace(index, index + 1, "&lt;");
                    index += 4;
                    continue;
                }
                if (ch == '\"') {
                    result.replace(index, index + 1, "&quot;");
                    index += 6;
                    continue;
                }
                ++index;
            }
            return result.toString();
        }
        return null;
    }

    public static String serializeItem(Item item) throws XPathException {
        int type;
        if (item instanceof NodeInfo && ((type = ((NodeInfo)item).getNodeKind()) == 9 || type == 1)) {
            Properties props = new Properties();
            props.setProperty("omit-xml-declaration", "yes");
            props.setProperty("indent", "yes");
            StringWriter stringWriter = new StringWriter();
            QueryResult.serialize((NodeInfo)((NodeInfo)item), (Result)new StreamResult(stringWriter), (Properties)props, null);
            stringWriter.flush();
            return stringWriter.toString().replaceAll(" xmlns=\"http\\://www.w3.org/1999/xhtml\"", "");
        }
        return item.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(File file, String encoding) throws IOException {
        if (!file.exists()) {
            throw new IOException("File doesn't exist!");
        }
        long fileLen = file.length();
        if (fileLen <= 0L) {
            if (file.exists()) {
                return "";
            }
            return null;
        }
        if (fileLen > Integer.MAX_VALUE) {
            throw new IOException("File too big for loading into a String!");
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader brin = null;
        int length = (int)fileLen;
        char[] buf = null;
        int realSize = 0;
        try {
            int c;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, encoding);
            brin = new BufferedReader(isr, 65536);
            buf = new char[length];
            while ((c = brin.read()) != -1) {
                buf[realSize] = (char)c;
                ++realSize;
            }
        }
        finally {
            if (brin != null) {
                brin.close();
                isr = null;
                fis = null;
            }
            if (isr != null) {
                isr.close();
                fis = null;
            }
            if (fis != null) {
                fis.close();
            }
        }
        return new String(buf, 0, realSize);
    }

    public static void saveStringToFile(File file, String content, String charset) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        byte[] data = content.getBytes(charset);
        out.write(data);
        out.flush();
        out.close();
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        int i;
        FileInputStream fileinputstream = new FileInputStream(file);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("File too big for loading into a byte array!");
        }
        byte[] byteArray = new byte[(int)l];
        int j = 0;
        for (i = 0; i < byteArray.length && (j = fileinputstream.read(byteArray, i, byteArray.length - i)) >= 0; i += j) {
        }
        if (i < byteArray.length) {
            throw new IOException("Could not completely read the file " + file.getName());
        }
        fileinputstream.close();
        return byteArray;
    }

    public static boolean isFullUrl(String link) {
        if (link == null) {
            return false;
        }
        return (link = link.trim().toLowerCase()).startsWith("http://") || link.startsWith("https://") || link.startsWith("file://");
    }

    public static String fullUrl(String pageUrl, String link) {
        if (CommonUtil.isFullUrl(link)) {
            return link;
        }
        if (link != null && link.startsWith("?")) {
            int qindex = pageUrl.indexOf(63);
            int len = pageUrl.length();
            if (qindex < 0) {
                return pageUrl + link;
            }
            if (qindex == len - 1) {
                return pageUrl.substring(0, len - 1) + link;
            }
            return pageUrl + "&" + link.substring(1);
        }
        boolean isLinkAbsolute = link.startsWith("/");
        if (!CommonUtil.isFullUrl(pageUrl)) {
            pageUrl = "http://" + pageUrl;
        }
        int slashIndex = isLinkAbsolute ? pageUrl.indexOf("/", 8) : pageUrl.lastIndexOf("/");
        pageUrl = slashIndex <= 8 ? pageUrl + "/" : pageUrl.substring(0, slashIndex + 1);
        return isLinkAbsolute ? pageUrl + link.substring(1) : pageUrl + link;
    }

    public static Variable createVariable(Object value) {
        if (value instanceof Variable) {
            return (Variable)value;
        }
        if (value == null) {
            return new EmptyVariable();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return new ListVariable(new ArrayList(collection));
        }
        if (value instanceof Object[]) {
            List<Object> list = Arrays.asList((Object[])value);
            return new ListVariable(list);
        }
        return new NodeVariable(value);
    }

    public static String readStringFromUrl(URL url) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((ch = in.read()) != -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    public static int countChars(String text, char ch, int from, int to) {
        int textLen = text.length();
        if (from < 0) {
            from = 0;
        }
        if (to >= textLen) {
            to = textLen - 1;
        }
        int count = 0;
        for (int i = from; i <= to; ++i) {
            if (text.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static boolean existsInStringArray(String[] array, String s, boolean caseSensitive) {
        if (s != null && array != null) {
            for (int i = 0; i < array.length; ++i) {
                if ((!caseSensitive || !s.equals(array[i])) && !s.equalsIgnoreCase(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String[] tokenize(String s, String delimiters) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
        String[] result = new String[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            result[index++] = tokenizer.nextToken();
        }
        return result;
    }

    public static String[] tokenize(String s, String delimiters, boolean trimTokens, boolean allowEmptyTokens) {
        if (s == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(s, delimiters, true);
        LinkedList<String> tokenList = new LinkedList<String>();
        boolean lastWasSeparator = false;
        while (tokenizer.hasMoreTokens()) {
            boolean isSeparator;
            String token = tokenizer.nextToken();
            boolean bl = isSeparator = delimiters.indexOf(token) >= 0;
            if (trimTokens) {
                token = token.trim();
            }
            if (isSeparator) {
                if (lastWasSeparator && allowEmptyTokens) {
                    tokenList.add("");
                }
            } else if (!"".equals(token) || allowEmptyTokens) {
                tokenList.add(token);
            }
            lastWasSeparator = isSeparator;
        }
        if (lastWasSeparator && allowEmptyTokens) {
            tokenList.add("");
        }
        return tokenList.toArray(new String[tokenList.size()]);
    }

    public static String getValidIdentifier(String value) {
        if (value == null) {
            return "_";
        }
        StringBuffer validIdentifier = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(ch) || !Character.isJavaIdentifierPart(ch)) {
                ch = '_';
            }
            validIdentifier.append(ch);
        }
        return validIdentifier.length() == 0 ? "_" : validIdentifier.toString();
    }

    public static int findValueInCollection(Collection c, Object value) {
        Iterator iterator = c.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object curr = iterator.next();
            if (value == curr || value != null && curr != null && value.equals(curr)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static class IntPair {
        public int x;
        public int y;

        public IntPair() {
        }

        public IntPair(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "x = " + this.x + ", y = " + this.y;
        }

        public void defineFromString(String s, char separator, int maxValue) {
            int columnIndex = s.indexOf(separator);
            if (columnIndex == -1) {
                this.y = this.x = Integer.parseInt(s);
            } else if (columnIndex == 0) {
                this.x = 1;
                String s2 = s.substring(1);
                this.y = "".equals(s2) ? maxValue : Integer.parseInt(s2);
            } else if (columnIndex == s.length() - 1) {
                this.x = Integer.parseInt(s.substring(0, s.length() - 1));
                this.y = maxValue;
            } else {
                String s1 = s.substring(0, columnIndex);
                String s2 = s.substring(columnIndex + 1);
                this.x = "".equals(s1) ? 1 : Integer.parseInt(s1);
                this.y = "".equals(s2) ? maxValue : Integer.parseInt(s2);
            }
        }
    }
}

