/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.helpers;

import au.com.bytecode.opencsv.CSVWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Group;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.models.EntityModel;
import org.chorem.vradi.ui.models.FormTypeModel;
import org.chorem.vradi.ui.offer.models.OfferListTableModel;
import org.chorem.vradi.ui.renderers.VradiI18nTableCellRenderer;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;
import org.nuiton.widget.SwingSession;

public class UIHelper
extends SwingUtil {
    private static final Log log = LogFactory.getLog(UIHelper.class);
    public static final String INFOGENE_KEY_PREFIX = "vradi.infogene.";
    public static final String FORM_KEY_PREFIX = "vradi.form.";

    private UIHelper() {
    }

    public static String getInfogeneTraduction(String key) {
        return I18n._((String)(INFOGENE_KEY_PREFIX + key), (Object[])new Object[0]);
    }

    public static String getFormTraduction(String key) {
        return I18n._((String)(FORM_KEY_PREFIX + key), (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateListSelection(JList list, Object value) {
        list.setValueIsAdjusting(true);
        list.clearSelection();
        try {
            if (value != null) {
                int size = list.getModel().getSize();
                Collection valuesToSelect = (Collection)value;
                int[] indexToSelect = new int[valuesToSelect.size()];
                int index = 0;
                block3: for (Object v : valuesToSelect) {
                    for (int i = 0; i < size; ++i) {
                        Object o = list.getModel().getElementAt(i);
                        if (!o.equals(v)) continue;
                        indexToSelect[index++] = i;
                        continue block3;
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("index to select = " + Arrays.toString(indexToSelect)));
                }
                list.setSelectedIndices(indexToSelect);
            }
        }
        finally {
            list.setValueIsAdjusting(false);
        }
    }

    public static void setI18nTableHeaderRenderer(JTable table, String ... libelles) {
        table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)new VradiI18nTableCellRenderer(table.getTableHeader().getDefaultRenderer(), libelles)));
    }

    public static void openAddressInBrowser(String address) {
        if (address != null) {
            try {
                UIHelper.browseURI("http://maps.google.fr/maps?f=q&source=s_q&hl=fr&geocode=&q=" + UIHelper.getStringValue((Object)address) + ",France");
            }
            catch (IOException eee) {
                log.error((Object)("Cant display page for address : " + UIHelper.getStringValue((Object)address)), (Throwable)eee);
                JOptionPane.showMessageDialog(null, I18n._((String)"vradi.message.cannot.display.address", (Object[])new Object[0]));
            }
        }
    }

    public static void browseURI(URI uri) throws IOException {
        if (uri != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Browse URI : " + uri.toString()));
            }
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(uri);
        }
    }

    public static void browseURI(String uri) throws IOException {
        if (uri != null) {
            try {
                UIHelper.browseURI(new URI(uri.replace(" ", "+")));
            }
            catch (URISyntaxException eee) {
                log.error((Object)("Cant display uri : " + uri), (Throwable)eee);
                ErrorDialogUI.showError((Exception)eee);
            }
        }
    }

    public static void browseURI(URL url) throws IOException {
        if (url != null) {
            String externalForm = url.toExternalForm();
            UIHelper.browseURI(externalForm);
        }
    }

    public static void createEmail(String emailAdress) throws IOException, URISyntaxException, UnsupportedOperationException {
        URI mailtoURI = new URI("mailto:" + emailAdress);
        Desktop.getDesktop().mail(mailtoURI);
    }

    public static void exportToCSV(File file, OfferListTableModel model) {
        try {
            int i;
            FileWriter fileWriter = new FileWriter(file);
            CSVWriter csvWriter = new CSVWriter((Writer)fileWriter);
            int columnCount = model.getColumnCount();
            String[] nextLine = new String[columnCount];
            for (i = 0; i < model.getColumnCount(); ++i) {
                nextLine[i] = I18n._((String)model.getColumnName(i), (Object[])new Object[0]);
            }
            csvWriter.writeNext(nextLine);
            for (i = 0; i < model.getRowCount(); ++i) {
                nextLine = new String[columnCount];
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    Object valueAt = model.getValueAt(i, j);
                    if (valueAt == null) continue;
                    String value = String.valueOf(valueAt);
                    if (valueAt instanceof Status) {
                        value = ((Status)valueAt).getName();
                    } else if (valueAt instanceof XmlStream) {
                        value = ((XmlStream)valueAt).getName();
                    }
                    nextLine[j] = value;
                }
                csvWriter.writeNext(nextLine);
            }
            csvWriter.close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
    }

    public static File openFileChooser(final String fileExtension, final String description, Component component, String validationLabel) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String ext = null;
                String fileName = file.getName();
                int dot = fileName.lastIndexOf(46);
                if (dot > 0 && dot < fileName.length() - 1) {
                    ext = fileName.substring(dot).toLowerCase();
                }
                return ext != null && ext.equals(fileExtension);
            }

            @Override
            public String getDescription() {
                return description;
            }
        });
        int returnVal = fileChooser.showDialog(component, validationLabel);
        if (returnVal == 0) {
            File file = fileChooser.getSelectedFile();
            if (!file.getName().endsWith(fileExtension)) {
                file = new File(file.getAbsolutePath() + fileExtension);
            }
            log.debug((Object)("saving : " + file.getName() + "."));
            return file;
        }
        log.debug((Object)"No file chosen by user.");
        return null;
    }

    public static ListCellRenderer getTranslationListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value != null) {
                    return super.getListCellRendererComponent((JList<?>)list, I18n._((String)value.toString(), (Object[])new Object[0]), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        };
    }

    public static <T> T getHandler(JAXXContext context, Class<T> handlerClass) {
        Object handler = context.getContextValue(handlerClass);
        if (handler != null) {
            return (T)handler;
        }
        try {
            handler = handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)("Cant create handler instance of type " + handlerClass.getName() + " : "), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Cant create handler instance of type " + handlerClass.getName() + " : "), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        if (context instanceof JAXXInitialContext) {
            ((JAXXInitialContext)context).add(handler);
        } else {
            context.setContextValue(handler);
        }
        return (T)handler;
    }

    public static ComboBoxModel getNumberComboBoxModel(int startIndex, int nbData) {
        Integer[] data = new Integer[nbData];
        for (int i = startIndex; i < data.length; ++i) {
            data[i] = i;
        }
        return new DefaultComboBoxModel<Integer>(data);
    }

    public static ComboBoxModel getNumberComboBoxModel(int nbData) {
        return UIHelper.getNumberComboBoxModel(0, nbData);
    }

    public static ComboBoxModel getHourModel() {
        return UIHelper.getNumberComboBoxModel(24);
    }

    public static ComboBoxModel getMinuteModel() {
        return UIHelper.getNumberComboBoxModel(60);
    }

    public static ListCellRenderer get2DigitsRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    stringValue = (Integer)value < 10 ? "0" + value.toString() : value.toString();
                }
                return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        };
    }

    public static ListCellRenderer getTranslationRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    stringValue = value.toString();
                }
                return super.getListCellRendererComponent((JList<?>)list, I18n._((String)stringValue, (Object[])new Object[0]), index, isSelected, cellHasFocus);
            }
        };
    }

    public static VradiDataService getDataService() {
        return VradiService.getVradiDataService();
    }

    public static EntityModel<Group> getGroupModel(boolean firstNull) {
        List<Group> groupList = UIHelper.getDataService().findAllGroups();
        Collections.sort(groupList, VradiComparators.GROUP_COMPARATOR);
        EntityModel<Group> entityModel = new EntityModel<Group>(Group.class, groupList, firstNull);
        return entityModel;
    }

    public static EntityModel<XmlStream> getXmlStreamsModel() {
        List<XmlStream> streamList = UIHelper.getDataService().findAllXmlStreams();
        Collections.sort(streamList, VradiComparators.XML_STREAM_COMPARATOR);
        EntityModel<XmlStream> entityModel = new EntityModel<XmlStream>(XmlStream.class, streamList);
        return entityModel;
    }

    public static ListModel getStatusesModel(boolean firstNull) {
        List<Status> status = AdminHandler.getAllStatuses();
        EntityModel<Status> entityModel = new EntityModel<Status>(Status.class, status, firstNull);
        return entityModel;
    }

    public static ListCellRenderer getStatusCellRenderer() {
        return new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Status status = (Status)value;
                return super.getListCellRendererComponent((JList<?>)list, I18n._((String)status.getName(), (Object[])new Object[0]), index, isSelected, cellHasFocus);
            }
        };
    }

    public static ComboBoxModel getFormTypesModel() {
        return new FormTypeModel(false);
    }

    public static ComboBoxModel getFormTypesModel(boolean firstNull) {
        return new FormTypeModel(firstNull);
    }

    public static <E extends Component> E getContentIfExist(CardLayout2 contentLayout, JPanel content, Class<E> uiClass) {
        String contentName = uiClass.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get content if exist " + contentName));
        }
        if (!contentLayout.contains((Serializable)((Object)contentName))) {
            return null;
        }
        return (E)contentLayout.getComponent((Container)content, contentName);
    }

    public static String crossOf(String text) {
        return "<html><strike>" + text + "</strike></html>";
    }

    public static Component crossOf(Component component) {
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setText(UIHelper.crossOf(label.getText()));
            return label;
        }
        return component;
    }

    public static void registerComponentToSaveDispositionConfig(Component c) {
        ((SwingSession)VradiContext.SWING_SESSION_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get())).add(c);
    }

    public static void saveComponentDispositionConfig() {
        SwingSession swingSession = (SwingSession)VradiContext.SWING_SESSION_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
        swingSession.save();
    }

    public static void addThesaurusExpandOnClickListener(final JTree tree) {
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                boolean isThesaurusExpanded = VradiHelper.isOnClickThesaurusExpanded();
                if (!isThesaurusExpanded) {
                    return;
                }
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || tree.isExpanded(path)) continue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("expand node [" + path + "]"));
                                }
                                tree.expandPath(path);
                            }
                        }
                    });
                }
            }
        });
    }

    public static void addThesaurusExpandOnClickListener(final JXTreeTable treeTable) {
        treeTable.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean isThesaurusExpanded = VradiHelper.isOnClickThesaurusExpanded();
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || treeTable.isExpanded(path)) continue;
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("expand node [" + path + "]"));
                                }
                                if (isThesaurusExpanded) {
                                    treeTable.expandPath(path);
                                }
                                treeTable.getTreeSelectionModel().setSelectionPath(path);
                            }
                        }
                    });
                }
            }
        });
    }

    public static class NumberFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
            numberFormatter.setAllowsInvalid(false);
            numberFormatter.setValueClass(Integer.class);
            return numberFormatter;
        }
    }
}

