package org.chorem.vradi.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class WebHarvestStreamHelper {

    /**
     * WebHarvestStreamHelper :
     * utility class all provided methods are accessible the static way
     */

    private WebHarvestStreamHelper() {// empty
}

    /**
     * getScriptUrl :
     * @param wikitty 
     * @return String 
     */

    public static String getScriptUrl(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(WebHarvestStream.EXT_WEBHARVESTSTREAM, WebHarvestStream.FIELD_WEBHARVESTSTREAM_SCRIPTURL);
        return value;
}

    /**
     * setScriptUrl :
     * @param wikitty 
     * @param scriptUrl 
     * @return String 
     */

    public static String setScriptUrl(Wikitty wikitty, String scriptUrl) {
        String oldValue = getScriptUrl(wikitty);
        wikitty.setField(WebHarvestStream.EXT_WEBHARVESTSTREAM, WebHarvestStream.FIELD_WEBHARVESTSTREAM_SCRIPTURL, scriptUrl);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(WebHarvestStream.EXT_WEBHARVESTSTREAM, WebHarvestStream.FIELD_WEBHARVESTSTREAM_SCRIPTURL);
            Object f2 = w2.getFieldAsObject(WebHarvestStream.EXT_WEBHARVESTSTREAM, WebHarvestStream.FIELD_WEBHARVESTSTREAM_SCRIPTURL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(WebHarvestStream.EXT_WEBHARVESTSTREAM);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : WebHarvestStreamAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //WebHarvestStreamHelper
