/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.export;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.CommentDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.PollExportDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.chorem.pollen.votecounting.services.ServiceExport;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * Implémentation du service d'export.
 *
 * @author boukhary
 * @version $Id: PollExportXML.java 2615 2009-07-01 13:47:45Z nrannou $
 */
@SuppressWarnings("unchecked")
public class PollExportXML implements ServiceExport {

    private PollDTO poll;

    private List<VoteCountingResultDTO> voteCountingResults;

    private static String PATH_FILE;

    private static Element racine;

    static org.jdom.Document document;

    /** log. */
    private static final Log log = LogFactory.getLog(PollExportXML.class);

    /**
     * Constructor
     */
    public PollExportXML() {

    }

    /**
     *
     * @return
     */
    private String process() {

        racine = new Element("pollExport");
        document = new Document(racine);
        // Creation des fils
        Element pollElm = new Element("poll");
        pollElm.setAttribute(new Attribute("idPoll", poll.getIdPoll()));
        pollElm.setAttribute(new Attribute("typePoll", poll.getTypePoll()
                .name()));
        pollElm.setAttribute("typeVoteCounting", poll.getTypeVoteCounting()
                .name());

        Element maxChoicesByPersonElm = new Element("maxChoicesByPerson");
        maxChoicesByPersonElm.setText(Integer.toString(poll
                .getMaxChoicesByPerson()));
        pollElm.addContent(maxChoicesByPersonElm);

        Element titleElm = new Element("title");
        titleElm.setText(poll.getTitle());
        pollElm.addContent(titleElm);

        Element descriptionElm = new Element("description");
        descriptionElm.setText(poll.getDescription());
        pollElm.addContent(descriptionElm);

        Element commentsElm = new Element("comments");

        Iterator iteratorComment = poll.getComments().listIterator();
        while (iteratorComment.hasNext()) {
            Element commentElm = new Element("comment");
            CommentDTO comment = (CommentDTO) iteratorComment.next();
            commentElm.setAttribute(new Attribute("votingKey", comment
                    .getVotingID()));
            commentElm.setText(comment.getText());
            commentsElm.addContent(commentElm);
        }

        pollElm.addContent(commentsElm);

        Element groupsElm = new Element("groups");

        Iterator iteratorGroup = poll.getVotingGroups().listIterator();
        while (iteratorGroup.hasNext()) {
            Element groupElm = save((VotingGroupDTO) iteratorGroup.next());
            groupsElm.addContent(groupElm);
        }
        pollElm.addContent(groupsElm);

        Element pollChoicesElm = new Element("pollChoices");

        Iterator iteratorpollChoices = poll.getChoices().listIterator();
        while (iteratorpollChoices.hasNext()) {
            Element pollChoiceElm = save((PollChoiceDTO) iteratorpollChoices
                    .next());
            pollChoicesElm.addContent(pollChoiceElm);
        }
        pollElm.addContent(pollChoicesElm);

        Element voteCountingResultsElm = new Element("voteCountingResults");

        Iterator iteratorvoteCountingResults = voteCountingResults
                .listIterator();
        while (iteratorvoteCountingResults.hasNext()) {
            Element voteCountingResult = save((VoteCountingResultDTO) iteratorvoteCountingResults
                    .next());
            voteCountingResultsElm.addContent(voteCountingResult);
        }

        racine.addContent(pollElm);
        racine.addContent(voteCountingResultsElm);

        affiche();
        enregistre();

        return PATH_FILE;
    }

    public Element save(VotingGroupDTO group) {

        Element groupElm = new Element("group");

        Attribute groupIdAtt = new Attribute("idGroup", group.getIdGroup());
        Attribute weightdAtt = new Attribute("weight", Double.toString(group
                .getWeight()));
        groupElm.setAttribute(groupIdAtt);
        groupElm.setAttribute(weightdAtt);

        Element votingPersonsElm = new Element("votingPersons");

        Iterator iteratorVotingPersons = group.getVotingPersons()
                .listIterator();
        while (iteratorVotingPersons.hasNext()) {
            Element votingPersonElm = save((VotingPersonDTO) iteratorVotingPersons
                    .next());
            votingPersonsElm.addContent(votingPersonElm);
        }
        groupElm.addContent(votingPersonsElm);

        return groupElm;
    }

    public Element save(VotingPersonDTO votingPerson) {

        Element votingPersonElm = new Element("votingPerson");

        Attribute votingKeyAtt = new Attribute("votingKey", votingPerson
                .getVotingKey());
        Attribute weightdAtt = new Attribute("weight", Double
                .toString(votingPerson.getWeight()));
        votingPersonElm.setAttribute(votingKeyAtt);
        votingPersonElm.setAttribute(weightdAtt);

        Element emailElm = new Element("email");
        emailElm.setText(votingPerson.getEmail());
        votingPersonElm.addContent(emailElm);

        Element commentElm = new Element("comment");
        commentElm.setText(votingPerson.getComment());
        votingPersonElm.addContent(commentElm);

        Element choicesElm = new Element("choices");

        Iterator iteratorChoices = votingPerson.getChoices().listIterator();
        while (iteratorChoices.hasNext()) {
            VoteToChoiceDTO voteToChoice = (VoteToChoiceDTO) iteratorChoices
                    .next();
            Element choiceElm = new Element("choice");
            choiceElm.setAttribute("idChoice", voteToChoice.getIdChoice());
            choiceElm.setAttribute("value", Double.toString(voteToChoice
                    .getValue()));
            choicesElm.addContent(choiceElm);
        }

        votingPersonElm.addContent(choicesElm);

        return votingPersonElm;
    }

    public Element save(VoteToChoiceDTO voteToChoice) {

        return null;
    }

    public Element save(PollChoiceDTO pollChoice) {

        Element pollChoiceElm = new Element("pollChoice");

        pollChoiceElm.setAttribute("idChoice", pollChoice.getIdChoice());

        Element nameElm = new Element("name");
        nameElm.setText(pollChoice.getName());
        pollChoiceElm.addContent(nameElm);

        Element descriptionElm = new Element("description");
        descriptionElm.setText(pollChoice.getDescription());
        pollChoiceElm.addContent(descriptionElm);

        return pollChoiceElm;
    }

    public Element save(VoteCountingResultDTO voteCountingResults) {

        Element voteCountingResultElm = new Element("voteCountingResult");

        voteCountingResultElm.setAttribute("idPoll", voteCountingResults
                .getIdPoll());

        Element nbVotesElm = new Element("nbVotes");
        nbVotesElm.setText(Integer.toString(voteCountingResults.getNbVotes()));
        voteCountingResultElm.addContent(nbVotesElm);

        Element choiceResultElm = new Element("choiceResult");
        choiceResultElm.setText(voteCountingResults.getChoiceResult());
        voteCountingResultElm.addContent(choiceResultElm);

        Element isByGroupElm = new Element("isByGroup");
        isByGroupElm.setText(Boolean.toString(voteCountingResults.isByGroup()));
        voteCountingResultElm.addContent(isByGroupElm);

        Element choicesElm = new Element("choices");

        Iterator iteratorChoices = voteCountingResults.getChoices()
                .listIterator();
        while (iteratorChoices.hasNext()) {
            Element choiceElm = save((ChoiceDTO) iteratorChoices.next());
            choicesElm.addContent(choiceElm);
        }

        voteCountingResultElm.addContent(choicesElm);

        return voteCountingResultElm;
    }

    public Element save(ChoiceDTO choice) {

        Element choiceElm = new Element("choice");

        choiceElm.setAttribute("idChoice", choice.getIdChoice());
        choiceElm.setAttribute("value", Double.toString(choice.getValue()));

        Element percentageElm = new Element("percentage");
        percentageElm.setText(Double.toString(choice.getPercentage()));
        choiceElm.addContent(percentageElm);

        Element nbVotesElm = new Element("nbVotes");
        nbVotesElm.setText(Integer.toString(choice.getNbVotes()));
        choiceElm.addContent(nbVotesElm);

        return choiceElm;
    }

    private void affiche() {
        try {
            // On utilise ici un affichage classique avec getPrettyFormat()
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(document, System.out);
        } catch (java.io.IOException e) {
        }
    }

    private void enregistre() {
        try {
            // ici on utilise un affichage classique avec getPrettyFormat()
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            // avec en argument le nom du fichier pour effectuer la
            // sérialisation.
            sortie.output(document, new FileOutputStream(PATH_FILE));
        } catch (java.io.IOException e) {
        }
    }

    private void fileName() {
        PATH_FILE = "edi" + poll.getIdPoll() + ".xml";
    }

    @Override
    public String executeExport(PollExportDTO pollExport) {

        this.poll = pollExport.getPoll();
        this.voteCountingResults = pollExport.getVoteCountingResults();
        fileName();
        return this.process();
    }

    @Override
    public PollExportDTO executeImport(String path) {
        // On crée une instance de SAXBuilder
        SAXBuilder sxb = new SAXBuilder();
        try {
            // On crée un nouveau document JDOM avec en argument le fichier XML
            document = sxb.build(new File(path));
        } catch (Exception e) {
        }

        // On initialise un nouvel élément racine avec l'élément racine du
        // document.
        racine = document.getRootElement();
        if (racine == null) {
            if (log.isErrorEnabled()) {
                log.error("racine null");
            }
        }

        return loadPoll();

    }

    /**
     *
     * @return
     */
    private PollExportDTO loadPoll() {

        Element pollElm = racine.getChild("poll");

        PollDTO poll = new PollDTO(pollElm.getAttributeValue("idPoll"), Integer
                .parseInt(pollElm.getChild("maxChoicesByPerson").getText()),
                PollType.valueOf(pollElm.getAttributeValue("typePoll")),
                VoteCountingType.valueOf(pollElm
                        .getAttributeValue("typeVoteCounting")));
        poll.setTitle(pollElm.getChild("title").getText());
        poll.setDescription(pollElm.getChild("description").getText());

        Element commentsElm = pollElm.getChild("comments");
        List<Element> listComments = commentsElm.getChildren("comment");
        List vectorComments = loadComments(listComments);

        Element groupsElm = pollElm.getChild("groups");
        List<Element> listGroups = groupsElm.getChildren("group");
        List vectorGroups = loadGroups(listGroups);

        Element pollChoicesElm = pollElm.getChild("pollChoices");
        List<Element> listPollChoices = pollChoicesElm
                .getChildren("pollChoice");
        List vectorPollChoices = loadPollChoices(listPollChoices);

        Element voteCountingResultsElm = racine.getChild("voteCountingResults");
        List<Element> listVoteCountingResults = voteCountingResultsElm
                .getChildren("voteCountingResult");
        List vectorVoteCountingResults = loadVoteCountingResults(listVoteCountingResults);

        poll.setComments(vectorComments);
        poll.setVotingGroups(vectorGroups);
        poll.setChoices(vectorPollChoices);

        PollExportDTO pollExport = new PollExportDTO();
        pollExport.setIdPoll(poll.getIdPoll());
        pollExport.setPoll(poll);
        pollExport.setVoteCountingResults(vectorVoteCountingResults);
        return pollExport;

    }

    /**
     *
     * @param listComments
     * @return
     */
    private List loadComments(List<Element> listComments) {

        List vectorComments = new ArrayList<CommentDTO>();
        Iterator i = listComments.listIterator();
        while (i.hasNext()) {
            Element commentElm = (Element) i.next();
            CommentDTO comment = new CommentDTO(commentElm
                    .getAttributeValue("votingKey"), commentElm.getText());
            vectorComments.add(comment);

        }

        return vectorComments;
    }

    /**
     *
     * @param listGroups
     * @return
     */
    private List loadGroups(List<Element> listGroups) {

        List vectorGroups = new ArrayList<VotingGroupDTO>();

        Iterator i = listGroups.listIterator();
        while (i.hasNext()) {
            Element groupElm = (Element) i.next();
            VotingGroupDTO group = new VotingGroupDTO(groupElm
                    .getAttributeValue("idGroup"), Double.parseDouble((groupElm
                    .getAttributeValue("weight"))));

            Element votingPersonsElm = groupElm.getChild("votingPersons");
            List<Element> listVotingPersons = votingPersonsElm
                    .getChildren("votingPerson");
            List vectorVotingPersons = loadVotingPersons(listVotingPersons);

            group.setVotingPersons(vectorVotingPersons);

            vectorGroups.add(group);

        }
        return vectorGroups;
    }

    /**
     *
     * @param listVotingPersons
     * @return
     */
    List loadVotingPersons(List<Element> listVotingPersons) {

        List vectorVotingPersons = new ArrayList<VotingPersonDTO>();

        Iterator i = listVotingPersons.listIterator();
        while (i.hasNext()) {
            Element votingPersonElm = (Element) i.next();
            VotingPersonDTO votingPerson = new VotingPersonDTO(votingPersonElm
                    .getAttributeValue("votingKey"), Double
                    .parseDouble((votingPersonElm.getAttributeValue("weight"))));

            votingPerson.setEmail(votingPersonElm.getChild("email").getValue());
            votingPerson.setComment(votingPersonElm.getChild("comment")
                    .getValue());
            Element choicesElm = votingPersonElm.getChild("choices");

            List<Element> listVoteTOChoices = choicesElm.getChildren("choice");
            List vectorVoteTOChoices = loadVoteTOChoices(listVoteTOChoices);

            votingPerson.setChoices(vectorVoteTOChoices);
            vectorVotingPersons.add(votingPerson);

        }
        return vectorVotingPersons;
    }

    /**
     *
     * @param listVoteToChoices
     * @return
     */
    List loadVoteTOChoices(List<Element> listVoteToChoices) {

        List vectorVoteToChoices = new ArrayList<VotingPersonDTO>();

        Iterator i = listVoteToChoices.listIterator();
        while (i.hasNext()) {
            Element voteToChoiceElm = (Element) i.next();

            VoteToChoiceDTO voteToChoice = new VoteToChoiceDTO(voteToChoiceElm
                    .getAttributeValue("idChoice"), Double
                    .parseDouble(voteToChoiceElm.getAttributeValue("value")));
            vectorVoteToChoices.add(voteToChoice);
        }
        return vectorVoteToChoices;
    }

    /**
     *
     * @param listPollChoices
     * @return
     */
    List loadPollChoices(List<Element> listPollChoices) {

        List vectorPollChoices = new ArrayList<PollChoiceDTO>();

        Iterator i = listPollChoices.listIterator();
        while (i.hasNext()) {
            Element pollChoiceElm = (Element) i.next();
            PollChoiceDTO pollChoice = new PollChoiceDTO(pollChoiceElm
                    .getAttributeValue("idChoice"));
            pollChoice.setName(pollChoiceElm.getChild("name").getValue());
            pollChoice.setDescription(pollChoiceElm.getChild("description")
                    .getValue());

            vectorPollChoices.add(pollChoice);
        }
        return vectorPollChoices;
    }

    /**
     *
     * @param listVoteCountingResults
     * @return
     */
    List loadVoteCountingResults(List<Element> listVoteCountingResults) {

        List vectorVoteCountingResults = new ArrayList<VoteCountingResultDTO>();

        Iterator i = listVoteCountingResults.listIterator();
        while (i.hasNext()) {
            Element voteCountingResultElm = (Element) i.next();
            VoteCountingResultDTO voteCountingResult = new VoteCountingResultDTO();
            voteCountingResult.setIdPoll(voteCountingResultElm
                    .getAttributeValue("idPoll"));
            voteCountingResult.setNbVotes(Integer
                    .parseInt(voteCountingResultElm.getChild("nbVotes")
                            .getValue()));
            voteCountingResult.setChoiceResult(voteCountingResultElm.getChild(
                    "choiceResult").getValue());
            voteCountingResult.setByGroup(Boolean
                    .parseBoolean((voteCountingResultElm.getChild("isByGroup")
                            .getValue())));

            Element choicesElm = voteCountingResultElm.getChild("choices");
            List<Element> listChoices = choicesElm.getChildren("choice");
            List vectorChoices = loadChoices(listChoices);
            voteCountingResult.setChoices(vectorChoices);
            vectorVoteCountingResults.add(voteCountingResult);
        }
        return vectorVoteCountingResults;
    }

    /**
     *
     * @param listVoteCountingResults
     * @return
     */
    List loadChoices(List<Element> listChoices) {

        List vectorChoices = new ArrayList<ChoiceDTO>();

        Iterator i = listChoices.listIterator();
        while (i.hasNext()) {
            Element choiceElm = (Element) i.next();
            ChoiceDTO choice = new ChoiceDTO(choiceElm.getAttribute("idChoice")
                    .getName(), Double.parseDouble(choiceElm.getAttribute(
                    "value").getValue()), Double.parseDouble(choiceElm
                    .getChild("percentage").getValue()), Integer
                    .parseInt((choiceElm.getChild("nbVotes").getValue())));
            vectorChoices.add(choice);
        }
        return vectorChoices;
    }

}