/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chorem.pollen.votecounting.VoteCountingStrategy;
import org.chorem.pollen.votecounting.model.ChoiceIdAble;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.GroupVoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

public abstract class AbstractVoteCountingStrategy
implements VoteCountingStrategy {
    public static final BigDecimal ZERO_D = BigDecimal.valueOf(0.0);
    protected final Comparator<VoteForChoice> voteValueComparator = new Comparator<VoteForChoice>(){

        @Override
        public int compare(VoteForChoice o1, VoteForChoice o2) {
            Double v1 = o1.getVoteValue();
            Double v2 = o2.getVoteValue();
            if (v1 == null) {
                v1 = Double.MAX_VALUE;
            }
            if (v2 == null) {
                v2 = Double.MAX_VALUE;
            }
            return v1.intValue() - v2.intValue();
        }
    };

    @Override
    public final GroupVoteCountingResult votecount(GroupOfVoter group) {
        HashSet groups = Sets.newHashSet();
        this.voteCount(group, groups);
        GroupVoteCountingResult result = GroupVoteCountingResult.newResult(group, groups);
        return result;
    }

    public Map<String, ChoiceScore> newEmptyChoiceScoreMap(Set<Voter> voters) {
        Set<String> choiceIds = this.getAllChoiceIds(voters);
        HashMap resultByChoice = Maps.newHashMap();
        for (String choiceId : choiceIds) {
            ChoiceScore choiceScore = ChoiceScore.newScore(choiceId, null);
            resultByChoice.put(choiceId, choiceScore);
        }
        return resultByChoice;
    }

    protected VoteCountingResult orderByValues(Collection<ChoiceScore> scores) {
        ImmutableListMultimap map = Multimaps.index(scores, ChoiceScore.SCORE_BY_VALUE);
        ArrayList values = Lists.newArrayList(map.asMap().keySet());
        Collections.sort(values);
        Collections.reverse(values);
        int rank = 0;
        for (BigDecimal value : values) {
            Collection scoresForValue = map.get((Object)value);
            for (ChoiceScore score : scoresForValue) {
                score.setScoreOrder(rank);
            }
            ++rank;
        }
        ArrayList orderedScores = Lists.newArrayList((Iterable)map.values());
        Collections.sort(orderedScores);
        VoteCountingResult result = VoteCountingResult.newResult(orderedScores);
        return result;
    }

    public Set<String> getAllChoiceIds(Set<Voter> voters) {
        ChoiceIdAble.ChoiceIdAbleById function = new ChoiceIdAble.ChoiceIdAbleById();
        HashSet result = Sets.newHashSet();
        for (Voter voter : voters) {
            Iterable transform = Iterables.transform(voter.getVoteForChoices(), (Function)function);
            Iterables.addAll((Collection)result, (Iterable)transform);
        }
        return result;
    }

    public Map<Voter, List<Set<String>>> buildVoterSortedChoices(Set<Voter> voters) {
        HashMap voterSortedChoices = Maps.newHashMap();
        for (Voter voter : voters) {
            List<Set<String>> sortedChoices = this.sortVoteForChoices(voter.getVoteForChoices());
            voterSortedChoices.put(voter, sortedChoices);
        }
        return voterSortedChoices;
    }

    public List<Set<String>> sortVoteForChoices(Set<VoteForChoice> voteForChoices) {
        ArrayList sortedChoices = Lists.newArrayList(voteForChoices);
        Collections.sort(sortedChoices, this.voteValueComparator);
        ArrayList result = Lists.newArrayList();
        HashSet set = Sets.newHashSet();
        result.add(set);
        VoteForChoice lastVoteForChoice = null;
        for (VoteForChoice voteForChoice : sortedChoices) {
            if (lastVoteForChoice != null && this.voteValueComparator.compare(lastVoteForChoice, voteForChoice) != 0) {
                set = Sets.newHashSet();
                result.add(set);
            }
            set.add(voteForChoice.getChoiceId());
            lastVoteForChoice = voteForChoice;
        }
        return result;
    }

    protected void voteCount(GroupOfVoter group, Set<GroupOfVoter> groups) {
        groups.add(group);
        Set<Voter> voters = group.getVoters();
        for (Voter voter : voters) {
            if (!(voter instanceof GroupOfVoter)) continue;
            this.voteCount((GroupOfVoter)voter, groups);
        }
        VoteCountingResult voteCountingResult = this.votecount(voters);
        group.setResult(voteCountingResult);
    }
}

