/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.util.List;
import org.chorem.pollen.votecounting.model.ChoiceScore;

public class VoteCountingResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ChoiceScore> scores;
    private transient ArrayListMultimap<Integer, ChoiceScore> scoresByRank;

    public static VoteCountingResult newResult(List<ChoiceScore> scores) {
        VoteCountingResult result = new VoteCountingResult();
        result.setScores(scores);
        return result;
    }

    public List<ChoiceScore> getScores() {
        return this.scores;
    }

    public ChoiceScore getScore(String choiceId) {
        ChoiceScore result = null;
        for (ChoiceScore score : this.scores) {
            if (!choiceId.equals(score.getChoiceId())) continue;
            result = score;
            break;
        }
        return result;
    }

    public void setScores(List<ChoiceScore> scores) {
        this.scores = Lists.newArrayList(scores);
    }

    public List<ChoiceScore> getTopRanking() {
        return this.getScoresByRank().get((Object)0);
    }

    public ArrayListMultimap<Integer, ChoiceScore> getScoresByRank() {
        if (this.scoresByRank == null) {
            this.scoresByRank = ArrayListMultimap.create((Multimap)Multimaps.index(this.scores, ChoiceScore.SCORE_BY_ORDER));
        }
        return this.scoresByRank;
    }
}

