/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.VoteCountingNotFound;

public class VoteCountingFactory
implements Iterable<VoteCounting> {
    private static final Log log = LogFactory.getLog(VoteCountingFactory.class);
    private final Map<Integer, VoteCounting> voteCountings = Maps.newHashMap();

    public VoteCountingFactory() {
        ServiceLoader<VoteCounting> loader = ServiceLoader.load(VoteCounting.class);
        Locale l = Locale.getDefault();
        for (VoteCounting strategy : loader) {
            int id = strategy.getId();
            String voteCountingName = strategy.getName(l);
            if (this.voteCountings.containsKey(id)) {
                throw new IllegalStateException("Strategy [" + voteCountingName + "] with id " + id + ", can not be used since the id is already used " + "by strategy [" + this.voteCountings.get(id).getName(l) + "] ");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Detected strategy [" + id + "-" + voteCountingName + "] : " + strategy.getClass().getName()));
            }
            this.voteCountings.put(id, strategy);
        }
    }

    public VoteCounting getVoteCounting(int strategyId) throws VoteCountingNotFound {
        VoteCounting type = this.voteCountings.get(strategyId);
        if (type == null) {
            throw new VoteCountingNotFound("Could not find strategy with id " + strategyId);
        }
        return type;
    }

    @Override
    public Iterator<VoteCounting> iterator() {
        return this.voteCountings.values().iterator();
    }
}

