/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.services;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.util.CaseInsensitiveMap;
import org.chorem.pollen.business.utils.PropertiesLoader;
import org.slf4j.Logger;

public class PropertiesFileSymbolProvider
implements SymbolProvider {
    private final Map<String, String> propertiesMap = new CaseInsensitiveMap();

    public PropertiesFileSymbolProvider(Logger logger, String resourceName, boolean classPath) {
        try {
            InputStream in;
            if (classPath) {
                in = ClassLoader.getSystemResourceAsStream(resourceName);
                if (in == null) {
                    throw new FileNotFoundException();
                }
            } else {
                in = new FileInputStream(resourceName);
            }
            this.initialize(logger, in);
        }
        catch (FileNotFoundException e) {
            String msg = "Could not find '" + resourceName + "'";
            logger.error(msg);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public PropertiesFileSymbolProvider(Logger logger, String resourceName) {
        Properties conf = PropertiesLoader.loadPropertiesFile((String)resourceName);
        this.initializeProperties(conf);
    }

    public PropertiesFileSymbolProvider(Logger logger, InputStream in) {
        this.initialize(logger, in);
    }

    public PropertiesFileSymbolProvider(Logger logger, URL url) {
        try {
            this.initialize(logger, url.openStream());
        }
        catch (IOException e) {
            String msg = "IOException while opening URL '" + url + "': " + e.getMessage();
            logger.error(msg);
            throw new IllegalArgumentException(msg, e);
        }
    }

    public PropertiesFileSymbolProvider(Logger logger, Properties properties) {
        this.initializeProperties(properties);
    }

    private void initialize(Logger logger, InputStream in) {
        Properties properties = new Properties();
        try {
            properties.load(in);
            for (Object key : properties.keySet()) {
                this.propertiesMap.put((String)key, properties.getProperty((String)key));
            }
        }
        catch (IOException e) {
            String msg = "IOEception while loading properties: " + e.getMessage();
            logger.error(msg);
            throw new IllegalArgumentException(msg, e);
        }
    }

    private void initializeProperties(Properties properties) {
        for (Object key : properties.keySet()) {
            this.propertiesMap.put((String)key, properties.getProperty((String)key));
        }
    }

    public String valueForSymbol(String arg0) {
        return (String)this.propertiesMap.get(arg0);
    }
}

