/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.Retain;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.TextField;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.chenillekit.tapestry.core.components.DateTimeField;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.CommentDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.dto.ResultListDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.dto.VoteDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.services.ServiceChoice;
import org.chorem.pollen.business.services.ServiceComment;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.business.services.ServiceVote;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.components.ImageContextLink;
import org.chorem.pollen.ui.data.EvenOdd;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollAction;
import org.chorem.pollen.ui.data.uio.DateChoiceUIO;
import org.chorem.pollen.ui.data.uio.ImageChoiceUIO;
import org.chorem.pollen.ui.pages.poll.VoteForPoll;
import org.chorem.pollen.ui.services.Configuration;
import org.chorem.pollen.ui.utils.FeedUtil;
import org.chorem.pollen.ui.utils.ImageUtil;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/vote.css", "context:css/lightbox.css"})
@IncludeJavaScriptLibrary(value={"${tapestry.scriptaculous}/builder.js", "context:js/lightbox.js"})
public class VoteForPoll {
    @Inject
    private Logger log;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    private String param;
    @Component(id="feedback")
    private FeedBack feedback;
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @SessionState
    @Property
    private String siteURL;
    @Component
    private Form voteForm;
    @Component(id="pollAccountName")
    private TextField nameField;
    @Component(parameters={"timePicker=true", "timePickerAdjacent=true"})
    private DateTimeField dateDTF;
    @Persist
    @Property
    private DateFormat dateFormat;
    @Inject
    private Locale currentLocale;
    @Inject
    private Logger logger;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Property
    @Persist
    private PollDTO poll;
    @Property
    private VoteDTO vote;
    @Property
    private ChoiceDTO choiceOfPoll;
    @Property
    private ChoiceDTO choiceOfVote;
    @Persist
    private List<ResultDTO> results;
    @Property
    @Retain
    private BeanModel voteModel;
    @InjectComponent
    private Zone pollZone;
    @InjectComponent
    private Zone commentZone;
    @Property
    private EvenOdd evenOdd = new EvenOdd();
    private boolean addChoice;
    private boolean alreadyVoted;
    @Property
    private boolean anonymousVote = false;
    private List<ChoiceDTO> voteChoices = new ArrayList();
    private String pollAccountId;
    @Property
    private PollAccountDTO pollAccount;
    @Property
    @Persist
    private ChoiceDTO newChoice;
    @Property
    @Persist
    private DateChoiceUIO newDateChoice;
    @Property
    @Persist
    private ImageChoiceUIO newImageChoice;
    @Property
    @Persist
    private CommentDTO comment;
    @Property
    @Persist
    private CommentDTO newComment;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServiceVote serviceVote;
    @Inject
    private ServiceComment serviceComment;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceResults serviceResults;
    @Inject
    private ServiceChoice serviceChoice;
    @InjectComponent
    private ContextLink feedContext;
    @InjectComponent
    private ImageContextLink imgContext;
    @Property(write=false)
    private ChoiceDTO currentVoteChoice;

    public ContextLink getFeedContext() {
        return this.feedContext;
    }

    public ImageContextLink getImgContext() {
        return this.imgContext;
    }

    @Log
    Object onSuccessFromVoteForm() {
        if (this.initPollAccount()) {
            ArrayList<ChoiceDTO> choiceDTOs = new ArrayList<ChoiceDTO>();
            if (this.poll.getVoteCounting() == VoteCountingType.NORMAL) {
                int nbChoices = 0;
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    if (choice.getValue() == 1) {
                        ++nbChoices;
                    }
                    choiceDTOs.add(choice);
                }
                if (nbChoices > this.poll.getMaxChoiceNb()) {
                    this.voteForm.recordError(this.messages.format("tooManyChoices", new Object[]{this.poll.getMaxChoiceNb()}));
                    return this.pollZone.getBody();
                }
            } else if (this.poll.getVoteCounting() == VoteCountingType.PERCENTAGE) {
                int total = 0;
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    total += choice.getValue();
                    choiceDTOs.add(choice);
                }
                if (total != 100) {
                    this.voteForm.recordError(this.messages.get("not100percent"));
                    return this.pollZone.getBody();
                }
            } else if (this.poll.getVoteCounting() == VoteCountingType.CONDORCET) {
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    if (choice.getValue() == 0) {
                        choice.setValue(100);
                    }
                    choiceDTOs.add(choice);
                }
            } else if (this.poll.getVoteCounting() == VoteCountingType.NUMBER) {
                String votingId = this.pollAccount.getVotingId();
                if (this.anonymousVote) {
                    votingId = "anonymous" + UUID.randomUUID().toString().replaceAll("-", "");
                }
                for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
                    if (choice.isHidden()) continue;
                    choiceDTOs.add(choice);
                    ChoiceDTO hiddenChoice = new ChoiceDTO();
                    hiddenChoice.setName("HIDDEN_" + choice.getName() + "#" + votingId);
                    hiddenChoice.setHidden(true);
                    hiddenChoice.setValue(choice.getValue());
                    hiddenChoice.setPollId(choice.getPollId());
                    hiddenChoice.setVoteId(choice.getVoteId());
                    hiddenChoice.setValidate(false);
                    String choiceId = this.serviceChoice.createChoice(hiddenChoice);
                    hiddenChoice.setId(choiceId);
                    choiceDTOs.add(hiddenChoice);
                }
            }
            VoteDTO vote = new VoteDTO(null, this.poll.getId(), null);
            vote.setChoiceDTOs(choiceDTOs);
            vote.setWeight(this.pollAccount.getWeight());
            vote.setAnonymous(this.anonymousVote);
            if (this.alreadyVoted) {
                for (VoteDTO v : this.poll.getVoteDTOs()) {
                    PollAccountDTO voteAccount = this.servicePollAccount.findPollAccountById(v.getPollAccountId());
                    if (!voteAccount.getVotingId().equals(this.pollAccount.getVotingId())) continue;
                    vote.setId(v.getId());
                    this.deleteVote(vote.getId());
                    this.serviceVote.createVote(vote, this.pollAccount);
                }
            } else {
                this.serviceVote.createVote(vote, this.pollAccount);
            }
            this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
            this.countPoll();
            this.addFeedEntry(PollAction.ADDVOTE, this.pollAccount.getVotingId(), this.getResultsAsString());
            this.sendMailNotification();
        }
        this.voteChoices.clear();
        return this.pollZone.getBody();
    }

    private void deleteVote(String voteId) {
        for (VoteDTO vote : this.poll.getVoteDTOs()) {
            if (!vote.getId().equals(voteId)) continue;
            List choiceDTOs = vote.getChoiceDTOs();
            for (ChoiceDTO choiceDTO : choiceDTOs) {
                if (!choiceDTO.isHidden()) continue;
                this.serviceChoice.deleteChoice(choiceDTO.getId());
            }
        }
        this.serviceVote.deleteVote(voteId);
    }

    Object onActionFromDeleteVote(String voteId) {
        this.deleteVote(voteId);
        this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
        this.countPoll();
        return this.pollZone.getBody();
    }

    Object onActionFromEditVote(String votingId) {
        this.pollAccount.setVotingId(votingId);
        return this.pollZone.getBody();
    }

    private boolean initPollAccount() {
        this.alreadyVoted = false;
        boolean modifAllowed = false;
        boolean restrictedListsForbidden = false;
        String votingId = this.pollAccount.getVotingId().trim();
        this.pollAccount.setVotingId(votingId);
        if (!this.isFreePoll()) {
            restrictedListsForbidden = true;
            for (VotingListDTO list : this.poll.getVotingListDTOs()) {
                for (PollAccountDTO account : list.getPollAccountDTOs()) {
                    if (!this.pollAccount.getVotingId().equals(account.getVotingId())) continue;
                    restrictedListsForbidden = false;
                    this.pollAccount = this.servicePollAccount.findPollAccountById(account.getId());
                    this.pollAccount.setVotingListId(list.getId());
                    this.pollAccount.setWeight(account.getWeight());
                    this.logger.debug("Compte \"" + account.getVotingId() + "\" pr\u00e9sent dans la liste \"" + list.getName() + "\" (poids=" + account.getWeight() + ")");
                }
            }
            if (restrictedListsForbidden) {
                this.voteForm.recordError((Field)this.nameField, this.messages.format("restrictedListsForbidden", new Object[]{this.pollAccount.getVotingId()}));
            }
        }
        if (this.poll.isAnonymous()) {
            this.anonymousVote = true;
            if (this.isFreePoll()) {
                this.pollAccount.setVotingId("anonymous" + UUID.randomUUID().toString().replaceAll("-", ""));
            }
        }
        if (this.userExists) {
            this.pollAccount.setUserId(this.user.getId());
        } else {
            this.pollAccount.setUserId("");
        }
        this.alreadyVoted = this.hasAlreadyVoted(this.pollAccount.getVotingId());
        modifAllowed = this.isModifAllowed(this.pollAccount.getVotingId());
        if (this.alreadyVoted && !modifAllowed) {
            this.voteForm.recordError((Field)this.nameField, this.messages.format("alreadyVoted", new Object[]{this.pollAccount.getVotingId()}));
        }
        this.logger.debug("votingId: " + this.pollAccount.getVotingId());
        this.logger.debug("alreadyVoted: " + this.alreadyVoted);
        this.logger.debug("modifAllowed: " + modifAllowed);
        this.logger.debug("restrictedListsForbidden: " + restrictedListsForbidden);
        return (!this.alreadyVoted || modifAllowed) && !restrictedListsForbidden;
    }

    private boolean hasAlreadyVoted(String votingId) {
        for (VoteDTO vote : this.poll.getVoteDTOs()) {
            PollAccountDTO account = this.servicePollAccount.findPollAccountById(vote.getPollAccountId());
            if (!account.getVotingId().equals(votingId)) continue;
            return true;
        }
        return false;
    }

    public boolean isModifAllowed(String votingId) {
        boolean modifAllowed = false;
        for (int i = 0; i < this.poll.getVoteDTOs().size() && !modifAllowed; ++i) {
            String id = ((VoteDTO)this.poll.getVoteDTOs().get(i)).getPollAccountId();
            PollAccountDTO account = this.servicePollAccount.findPollAccountById(id);
            if (!account.getVotingId().equals(votingId)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("vote account: " + account.getId());
                this.logger.debug("voting account: " + this.pollAccountId);
            }
            if (this.pollAccountId != null && this.pollAccountId.equals(account.getId())) {
                modifAllowed = true;
            }
            if (!this.userExists || this.user.getId().length() <= 0) continue;
            modifAllowed = this.user.getId().equals(account.getUserId());
        }
        return modifAllowed;
    }

    private void addFeedEntry(PollAction pollAction, String titleStr, String contentStr) {
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        File feedFile = this.getFeedContext().getFile(this.poll.getPollId());
        String title = null;
        String content = null;
        switch (1.$SwitchMap$org$chorem$pollen$ui$data$PollAction[pollAction.ordinal()]) {
            case 1: {
                if (this.isVoteAnonymous()) {
                    titleStr = this.messages.get("anonymous");
                }
                title = this.messages.format("pollFeed_voteTitle", new Object[]{titleStr});
                content = this.messages.format("pollFeed_voteContent", new Object[]{contentStr});
                break;
            }
            case 2: {
                title = this.messages.format("pollFeed_choiceTitle", new Object[]{titleStr});
                content = this.messages.format("pollFeed_choiceContent", new Object[]{contentStr});
                break;
            }
            case 3: {
                title = this.messages.format("pollFeed_commentTitle", new Object[]{titleStr});
                content = this.messages.format("pollFeed_commentContent", new Object[]{contentStr});
            }
        }
        if (!feedFile.exists()) {
            FeedUtil.createFeed((File)feedFile, (String)"atom_1.0", (String)this.messages.format("pollFeed_title", new Object[]{this.poll.getTitle()}), (String)this.siteURL, (String)this.messages.format("pollFeed_desc", new Object[]{this.poll.getDescription()}));
        }
        FeedUtil.feedFeed((File)feedFile, title, (String)voteURL, content);
    }

    private void sendMailNotification() {
        String voteURL = this.siteURL + "poll/VoteFor/" + this.poll.getPollId();
        String modifURL = this.siteURL + "poll/Modification/" + this.poll.getPollId() + ":" + MD5.encode((String)this.poll.getCreatorId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        data.put("to", this.poll.getCreatorEmail());
        data.put("title", this.messages.format("voteEmail_subject", new Object[]{this.poll.getTitle()}));
        data.put("msg", this.messages.format("voteEmail_msg", new Object[]{this.poll.getTitle(), this.poll.getVoteDTOs().size(), voteURL, modifURL}));
        for (PreventRuleDTO rule : this.poll.getPreventRuleDTOs()) {
            PreventRuleManager manager = new PreventRuleManager(rule);
            manager.execute("vote", Integer.valueOf(this.poll.getVoteDTOs().size()), data);
        }
    }

    public boolean isAddChoice() {
        return this.addChoice;
    }

    public void setAddChoice(boolean addChoice) {
        this.choiceOfVote.setValue(addChoice ? 1 : 0);
    }

    public void setAddNumberVote(Integer value) {
        if (value != null) {
            this.choiceOfVote.setValue(value.intValue());
        } else {
            this.choiceOfVote.setValue(-1);
        }
    }

    public Integer getAddNumberVote() {
        return null;
    }

    public Boolean isChoiceInVote(ChoiceDTO choice) {
        if (choice != null) {
            switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCounting().ordinal()]) {
                case 1: {
                    return choice.getValue() > 0;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return choice.getValue() < 100;
                }
                case 4: {
                    return choice.getValue() >= 0;
                }
            }
        }
        return null;
    }

    public boolean isChoiceHidden() {
        return this.choiceOfPoll.isHidden();
    }

    public char setCurrentVoteChoice() {
        this.currentVoteChoice = null;
        for (ChoiceDTO choice : this.vote.getChoiceDTOs()) {
            if (!choice.getId().equals(this.choiceOfPoll.getId())) continue;
            this.currentVoteChoice = choice;
            break;
        }
        return '\u0000';
    }

    public String getCurrentChoiceResult() {
        String val = "";
        for (ResultDTO result : this.results) {
            if (!result.getName().equals(this.choiceOfPoll.getName())) continue;
            val = this.removeTrailing0(result.getValue());
        }
        return val;
    }

    @Log
    public boolean isFeedFileExisting() {
        File feedFile = this.getFeedContext().getFile(this.poll.getPollId());
        if (this.log.isDebugEnabled()) {
            this.log.debug("feed context path : " + this.getFeedContext().getContextPath());
            this.log.debug("feed absolute path : " + feedFile.getAbsolutePath());
        }
        return feedFile.exists();
    }

    private String removeTrailing0(String val) {
        if (val.endsWith(".0")) {
            val = val.substring(0, val.indexOf(46));
        }
        return val;
    }

    public String getResultsAsString() {
        StringBuffer res = new StringBuffer("");
        Iterator it = this.results.iterator();
        while (it.hasNext()) {
            ResultDTO result = (ResultDTO)it.next();
            if (this.isDateType()) {
                Date date = new Date(Long.parseLong(result.getName()));
                res.append(this.dateFormat.format(date));
            } else {
                res.append(result.getName());
            }
            res.append("=" + this.removeTrailing0(result.getValue()));
            if (!it.hasNext()) continue;
            res.append(", ");
        }
        return res.toString();
    }

    public boolean isVoteAnonymous() {
        return this.poll.isAnonymous() || this.anonymousVote;
    }

    public boolean isCurrentVoteAnonymous() {
        return this.poll.isAnonymous() || this.vote.isAnonymous();
    }

    public boolean isAnonymousVoteDisplayed() {
        return this.poll.isAnonymousVoteAllowed() && !this.poll.isAnonymous();
    }

    public String getCurrentVotingId() {
        String id = this.vote.getPollAccountId();
        String votingId = this.servicePollAccount.findPollAccountById(id).getVotingId();
        return votingId;
    }

    void onValidateFromTextName(String value) throws ValidationException {
        this.validateNewChoice(value);
    }

    void onValidateFromDateDTF(Date value) throws ValidationException {
        this.validateNewChoice(String.valueOf(value.getTime()));
    }

    void onValidateFromImgFile(UploadedFile value) throws ValidationException {
        this.validateNewChoice(value.getFileName().replace(' ', '_'));
    }

    private void validateNewChoice(String value) throws ValidationException {
        for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
            if (!value.equals(choice.getName())) continue;
            throw new ValidationException(this.messages.format("choiceExists", new Object[]{value}));
        }
    }

    Object onSuccessFromChoiceForm() {
        String choiceName = null;
        String choiceDesc = null;
        if (this.isTextType()) {
            if (this.newChoice.getName() != null) {
                this.newChoice.setValidate(true);
                this.newChoice.setPollId(this.poll.getId());
                this.poll.getChoiceDTOs().add(this.newChoice);
                choiceName = this.newChoice.getName();
                choiceDesc = this.newChoice.getDescription();
            }
        } else if (this.isDateType()) {
            if (this.newDateChoice.getDate() != null) {
                this.newDateChoice.setValidate(true);
                this.newDateChoice.setPollId(this.poll.getId());
                this.newDateChoice.setName(String.valueOf(this.newDateChoice.getDate().getTime()));
                this.poll.getChoiceDTOs().add(this.newDateChoice);
                Date date = new Date(Long.parseLong(this.newDateChoice.getName()));
                choiceName = this.dateFormat.format(date);
                choiceDesc = this.newDateChoice.getDescription();
            }
        } else if (this.isImageType() && this.newImageChoice.getImg() != null) {
            this.newImageChoice.setValidate(true);
            this.newImageChoice.setPollId(this.poll.getId());
            this.newImageChoice.setName(this.newImageChoice.getImg().getFileName().replace(' ', '_'));
            this.poll.getChoiceDTOs().add(this.newImageChoice);
            File imgFile = this.getImgContext().getImageDir();
            ImageUtil.saveImage((ImageChoiceUIO)this.newImageChoice, (File)imgFile);
            choiceName = this.newImageChoice.getName();
            choiceDesc = this.newImageChoice.getDescription();
        }
        this.servicePoll.updatePoll(this.poll);
        this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
        this.addFeedEntry(PollAction.ADDCHOICE, choiceName, choiceDesc);
        this.newChoice = new ChoiceDTO();
        this.newDateChoice = new DateChoiceUIO();
        this.newImageChoice = new ImageChoiceUIO();
        return this;
    }

    Object onActionFromDeleteChoice(String choiceId) {
        Iterator itChoice = this.poll.getChoiceDTOs().iterator();
        while (itChoice.hasNext()) {
            ChoiceDTO choice = (ChoiceDTO)itChoice.next();
            if (!choiceId.equals(choice.getId())) continue;
            itChoice.remove();
        }
        this.servicePoll.updatePoll(this.poll);
        this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
        return this.pollZone.getBody();
    }

    Object onSuccessFromCommentForm() {
        this.newComment.setPollId(this.poll.getId());
        this.newComment.setPostDate(new Date());
        this.serviceComment.createComment(this.newComment);
        this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
        this.addFeedEntry(PollAction.ADDCOMMENT, this.newComment.getPollAccountId(), this.newComment.getText());
        this.newComment = new CommentDTO();
        return this.commentZone.getBody();
    }

    Object onActionFromDeleteComment(String commentId) {
        this.serviceComment.deleteComment(commentId);
        this.poll = this.servicePoll.findPollByPollId(this.poll.getPollId());
        return this.commentZone.getBody();
    }

    public boolean isPollNull() {
        return this.poll == null;
    }

    public boolean isPollChoiceStarted() {
        Date now = new Date();
        boolean started = this.poll.getBeginChoiceDate() == null || this.poll.getBeginChoiceDate().before(now);
        boolean ended = this.poll.getEndChoiceDate() != null && this.poll.getEndChoiceDate().before(now);
        return started && !ended;
    }

    public boolean isPollStarted() {
        Date now = new Date();
        return this.poll.getBeginDate() == null || this.poll.getBeginDate().before(now);
    }

    public boolean isPollFinished() {
        Date now = new Date();
        return this.poll.getEndDate() != null && this.poll.getEndDate().before(now);
    }

    public boolean isPollChoiceOrVoteStarted() {
        return this.isPollChoiceStarted() || this.isPollStarted();
    }

    public boolean isPollChoiceRunning() {
        return this.poll.isChoiceAddAllowed() && this.isPollChoiceStarted();
    }

    public boolean isPollRunning() {
        return this.isPollStarted() && !this.isPollFinished() && !this.poll.isClosed();
    }

    public boolean isDescNull() {
        return this.choiceOfPoll.getDescription() == null || "".equals(this.choiceOfPoll.getDescription());
    }

    public boolean isAccountFieldDisplayed() {
        return !this.poll.isAnonymous() || this.isRestrictedPoll() || this.isGroupPoll();
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isNormalVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.NORMAL;
    }

    public boolean isPercentageVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.PERCENTAGE;
    }

    public boolean isCondorcetVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.CONDORCET;
    }

    public boolean isNumberVoteCounting() {
        return this.poll.getVoteCounting() == VoteCountingType.NUMBER;
    }

    public boolean isCreatorUser() {
        PollAccountDTO creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
        return this.userExists && this.user.getId().equals(creator.getUserId());
    }

    public String getCreatorName() {
        PollAccountDTO pollAccount = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
        return pollAccount.getVotingId();
    }

    public String getHelpMessage() {
        switch (1.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCounting().ordinal()]) {
            case 1: {
                return this.messages.get("normalVote-help");
            }
            case 2: {
                return this.messages.get("percentageVote-help");
            }
            case 3: {
                return this.messages.get("condorcetVote-help");
            }
            case 4: {
                return this.messages.get("numberVote-help");
            }
        }
        return "";
    }

    public Date getChoiceNameAsDate() {
        return new Date(Long.valueOf(this.choiceOfPoll.getName()));
    }

    private void countPoll() {
        ResultListDTO resultListDTO = null;
        resultListDTO = this.isGroupPoll() ? this.serviceResults.getGroupResults(this.poll.getPollId()) : this.serviceResults.getNormalResults(this.poll.getPollId());
        this.results = resultListDTO.getResultDTOs();
        if (this.logger.isDebugEnabled()) {
            for (ResultDTO res : this.results) {
                this.logger.debug(res.getName() + ": " + res.getValue() + ", (voteCounting=" + res.getVoteCounting() + ", byGroup=" + res.isByGroup() + ")");
            }
        }
    }

    void onActivate(String id) {
        this.param = id;
        if (id != null && !"".equals(id)) {
            String pollId = id.split(":", 2)[0];
            this.poll = this.servicePoll.findPollByPollId(pollId);
            if (this.poll != null) {
                if (id.split(":", 2).length == 2) {
                    String accountId = id.split(":", 2)[1];
                    this.pollAccount = this.servicePollAccount.findPollAccountByAccountId(accountId);
                    this.pollAccountId = this.pollAccount.getId();
                }
                if (this.pollAccount == null) {
                    this.pollAccount = new PollAccountDTO();
                    if (this.userExists) {
                        if (this.user.getFirstName() != null && this.user.getLastName() != null) {
                            this.pollAccount.setVotingId(this.user.getFirstName() + " " + this.user.getLastName());
                        } else if (this.user.getFirstName() != null) {
                            this.pollAccount.setVotingId(this.user.getFirstName());
                        } else if (this.user.getLastName() != null) {
                            this.pollAccount.setVotingId(this.user.getLastName());
                        }
                    }
                }
                this.newChoice = new ChoiceDTO();
                this.newDateChoice = new DateChoiceUIO();
                this.newImageChoice = new ImageChoiceUIO();
                this.newComment = new CommentDTO();
                this.newComment.setPollId(this.poll.getId());
            }
        }
        if (this.poll == null) {
            this.feedback.addError(this.messages.get("pollNotFound"));
        } else {
            if (this.poll.isClosed()) {
                this.feedback.addInfo(this.messages.get("pollClosed"));
            } else if (!this.isPollStarted()) {
                this.feedback.addInfo(this.messages.get("pollNotStarted"));
            } else if (this.isPollFinished()) {
                this.feedback.addInfo(this.messages.get("pollFinished"));
            }
            if (this.isPollChoiceRunning()) {
                this.feedback.addInfo(this.messages.get("pollChoiceRunning"));
            }
        }
    }

    String onPassivate() {
        return this.param;
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.dateFormat = DateFormat.getDateTimeInstance(3, 3, this.currentLocale);
        this.countPoll();
    }
}

