/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import java.util.List;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.ui.base.Polls;

@IncludeStylesheet(value={"context:css/pollsCreated.css"})
public class UserPollsCreated
extends Polls {
    @SessionState
    private UserDTO user;
    private boolean userExists;
    @Property
    private List<PollDTO> polls;
    @Property
    private UploadedFile pollFile;
    private Form importPollForm;
    @Inject
    private Messages messages;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServiceResults serviceResults;

    Object onSuccessFromImportPollForm() {
        if (this.pollFile != null) {
            if (!this.pollFile.getContentType().equals("text/xml")) {
                this.importPollForm.recordError(this.messages.format("invalidFile", new Object[]{this.pollFile.getFileName()}));
                return this;
            }
            this.serviceResults.importPoll(this.pollFile.getFilePath(), this.user);
        }
        return this;
    }

    public void onActivate() {
        super.onActivate();
        if (this.userExists) {
            this.polls = this.servicePoll.findPollsByUser(this.user.getId());
        }
    }
}

