/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.poll;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePollAccount;
import org.chorem.pollen.business.services.ServiceResults;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.pages.poll.ImageDisplay;
import org.chorem.pollen.ui.pages.poll.Results;
import org.chorem.pollen.ui.services.Configuration;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/results.css"})
public class Results {
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    private String param;
    @Component(id="feedback")
    private FeedBack feedback;
    @InjectComponent
    private Zone resultZone;
    @Persist
    @Property
    private boolean byGroup;
    @Property
    private boolean userAllowed = false;
    @Persist
    @Property
    private int type;
    @Property
    @Persist
    private PollDTO poll;
    @Property
    private PollAccountDTO creator;
    @Persist
    @Property
    private List<ResultDTO> results;
    @Property
    private ResultDTO result;
    @Property
    private List<String> choice;
    @Inject
    private Messages messages;
    @InjectPage
    private ImageDisplay imageDisplay;
    @Persist
    @Property
    private DateFormat dateFormat;
    @Inject
    private Locale currentLocale;
    @Inject
    private Configuration conf;
    @Inject
    private Logger logger;
    @Inject
    private ServicePoll servicePoll;
    @Inject
    private ServicePollAccount servicePollAccount;
    @Inject
    private ServiceResults serviceResults;

    public ArrayList<ArrayList<String>> getChoices() {
        ArrayList<ArrayList<String>> choices = new ArrayList<ArrayList<String>>();
        ArrayList<String> choiceValues = new ArrayList<String>();
        this.countPoll();
        for (ResultDTO result : this.results) {
            String name = String.valueOf(result.getName());
            String value = String.valueOf(result.getValue());
            if (this.poll.getChoiceType() == ChoiceType.DATE) {
                Date date = new Date(Long.parseLong(result.getName()));
                name = this.dateFormat.format(date);
            }
            choiceValues.add(name);
            choiceValues.add(value);
        }
        choices.add(choiceValues);
        return choices;
    }

    public List<ResultDTO> getRanking() {
        this.countPoll();
        List ranking = this.results;
        Collections.sort(ranking, new /* Unavailable Anonymous Inner Class!! */);
        return ranking;
    }

    public List<ResultDTO> getTopRanking() {
        List ranking = this.getRanking();
        ArrayList<ResultDTO> winners = new ArrayList<ResultDTO>();
        String winValue = null;
        if (ranking.size() <= 0) {
            return winners;
        }
        winValue = ((ResultDTO)ranking.get(0)).getValue();
        for (ResultDTO r : ranking) {
            if (!winValue.equals(r.getValue())) continue;
            winners.add(r);
        }
        return winners;
    }

    Object onType(int type) {
        this.type = type;
        return this.resultZone.getBody();
    }

    Object onDisplayType() {
        this.byGroup = !this.byGroup;
        return this.resultZone.getBody();
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public boolean isFreePoll() {
        return this.poll.getPollType() == PollType.FREE;
    }

    public boolean isRestrictedPoll() {
        return this.poll.getPollType() == PollType.RESTRICTED;
    }

    public boolean isGroupPoll() {
        return this.poll.getPollType() == PollType.GROUP;
    }

    public String getHelpMessage() {
        switch (2.$SwitchMap$org$chorem$pollen$common$VoteCountingType[this.poll.getVoteCounting().ordinal()]) {
            case 1: {
                return this.messages.get("normalVote-help");
            }
            case 2: {
                return this.messages.get("percentageVote-help");
            }
            case 3: {
                return this.messages.get("condorcetVote-help");
            }
        }
        return "";
    }

    public String getVictoryMessage() {
        List winners = this.getTopRanking();
        if (winners.size() == 0) {
            return "";
        }
        if (winners.size() == 1) {
            return this.messages.format("victory", new Object[0]);
        }
        return this.messages.format("victories", new Object[0]);
    }

    public String getTrimValue() {
        String value = this.result.getValue();
        if (value.endsWith(".0")) {
            value = value.substring(0, value.indexOf(46));
        }
        return value;
    }

    public Date getResultNameAsDate() {
        return new Date(Long.valueOf(this.result.getName()));
    }

    public String getResultThumbSrc() {
        File dir = new File(this.conf.getProperty("upImgDir"), this.poll.getPollId());
        File file = new File(dir, "thumb_" + this.result.getName());
        return file.getAbsolutePath();
    }

    Object onDisplayImage(String resultName) {
        String choiceId = "";
        for (ChoiceDTO choice : this.poll.getChoiceDTOs()) {
            if (!resultName.equals(choice.getName())) continue;
            choiceId = choice.getId();
        }
        this.imageDisplay.setPoll(this.poll);
        this.imageDisplay.setChoiceId(choiceId);
        this.imageDisplay.setPageStyle("VoteCounting");
        return this.imageDisplay;
    }

    private void countPoll() {
        this.results = this.byGroup ? this.serviceResults.getGroupResults(this.poll.getPollId()) : this.serviceResults.getNormalResults(this.poll.getPollId());
        for (ResultDTO res : this.results) {
            this.logger.debug(res.getName() + ": " + res.getValue() + ", (voteCounting=" + res.getVoteCounting() + ", byGroup=" + res.isByGroup() + ")");
        }
    }

    void onActivate(String id) {
        this.param = id;
        String pollId = null;
        if (id != null && !"".equals(id)) {
            pollId = id.split(":", 2)[0];
            this.poll = this.servicePoll.findPollByPollId(pollId);
            if (this.poll != null) {
                String creatorId;
                this.creator = this.servicePollAccount.findPollAccountById(this.poll.getCreatorId());
                if (this.poll.isPublicResults()) {
                    this.userAllowed = true;
                } else if (id.split(":", 2).length == 2 && (creatorId = id.split(":", 2)[1]).equals(this.creator.getAccountId())) {
                    this.userAllowed = true;
                }
            }
        }
        if (this.poll == null) {
            this.feedback.addError(this.messages.get("pollNotFound"));
        } else if (!this.userAllowed) {
            this.feedback.addError(this.messages.get("userNotAllowed"));
        } else if (!this.poll.isClosed()) {
            this.feedback.addError(this.messages.get("pollNotClosed"));
        }
    }

    String onPassivate() {
        return this.param;
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.dateFormat = DateFormat.getDateTimeInstance(3, 3, this.currentLocale);
        this.type = 1;
        this.byGroup = this.isGroupPoll();
    }
}

