/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.pages.poll;

import java.util.Date;

import org.apache.tapestry5.BindingConstants;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.data.PollAction;

/**
 * Classe de la page de confirmation d'une action sur un sondage.
 *
 * @author kmorin
 * @author rannou
 * @version $Id: ConfirmPoll.java 2762 2009-08-27 15:51:09Z nrannou $
 */
public class ConfirmPoll {

    @Persist
    private PollDTO poll;

    @Parameter(defaultPrefix = BindingConstants.MESSAGE, value = "title")
    @Property
    private String title;

    @SuppressWarnings("unused")
    @Property
    private Lien[] address;

    /** Page précédente */
    @Persist
    private String backPage;

    /** Action courante */
    @Persist
    private PollAction pollAction;

    @InjectPage
    private CloseValidation closeValidation;

    /**
     * Messages.
     */
    @Inject
    private Messages messages;

    /** Injection des services */
    @Inject
    private ServicePoll servicePoll;

    public PollDTO getPoll() {
        return poll;
    }

    public void setPoll(PollDTO poll) {
        this.poll = poll;
    }

    public String getBackPage() {
        return backPage;
    }

    public void setBackPage(String backPage) {
        this.backPage = backPage;
    }

    public void setAction(PollAction pollAction) {
        this.pollAction = pollAction;
    }

    /**
     * Méthode appelée quand l'utilisateur valide la confirmation.
     *
     * @return la page de validation de cloture
     */
    public Object onActionFromValidateButton() {
        switch (pollAction) {
        case CLOSE:
            return closePoll();
        case DELETE:
            return deletePoll();
        default:
            return backPage;
        }
    }

    /**
     * Cloture du sondage.
     *
     * @return la page de validation de cloture
     */
    private Object closePoll() {
        for (ChoiceDTO choice : poll.getChoiceDTOs()) {
            choice.setValidate(true);
        }
        Date now = new Date();
        if (poll.getEndDate() == null || now.before(poll.getEndDate())) {
            poll.setEndDate(now);
        }
        poll.setClosed(true);
        servicePoll.updatePoll(poll);
        closeValidation.setPoll(poll);
        return closeValidation;
    }

    /**
     * Suppression du sondage.
     *
     * @return la page des sondages
     */
    private Object deletePoll() {
        servicePoll.deletePoll(poll.getId());
        return backPage;
    }

    public String getConfirmMessage() {
        switch (pollAction) {
        case CLOSE:
            return messages.get("confirmClose");
        case DELETE:
            return messages.get("confirmDelete");
        default:
            return "";
        }
    }

    /**
     * Initialisation de l'affichage
     */
    void setupRender() {
        address = new Lien[] { new Lien("Pollen", "Index"),
                new Lien(title, null) };
    }
}
