/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.Retain;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.chorem.pollen.business.ServiceList;
import org.chorem.pollen.business.ServicePollAccount;
import org.chorem.pollen.business.dto.PersonListDTO;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.ui.data.EvenOdd;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.utils.CSVAccountUtil;

@IncludeStylesheet(value={"context:css/lists.css"})
public class UserLists {
    @SessionState
    private UserDTO user;
    @Property
    private boolean userExists;
    @Property
    private List<PersonListDTO> lists;
    @Persist
    @Property
    private PersonListDTO selectedList;
    @Property
    private PersonListDTO newList;
    @Property
    private PollAccountDTO account;
    @Property
    private PollAccountDTO newAccount;
    @Property
    private UploadedFile accountsFile;
    @InjectComponent
    private Zone listsZone;
    @Component
    private Form createListForm;
    @Component
    private Form createAccountForm;
    @Inject
    private Messages messages;
    @Property
    private EvenOdd evenOdd;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources componentResources;
    @Property
    @Retain
    private BeanModel listModel;
    @Inject
    private ServiceList serviceList;
    @Inject
    private ServicePollAccount servicePollAccount;

    Object onSuccessFromCreateListForm() {
        for (PersonListDTO list : this.lists) {
            if (!list.getName().equals(this.newList.getName())) continue;
            this.createListForm.recordError(this.messages.format("listExists", new Object[]{this.newList.getName()}));
            return this;
        }
        if (this.accountsFile != null) {
            if (!this.accountsFile.getContentType().equals("text/csv")) {
                this.createListForm.recordError(this.messages.format("invalidFile", new Object[]{this.accountsFile.getFileName()}));
                return this;
            }
            List accounts = CSVAccountUtil.importList((UploadedFile)this.accountsFile);
            this.newList.setPollAccountDTOs(accounts);
        }
        this.newList.setUserId(this.user.getId());
        this.newList.setId(this.serviceList.createPersonList(this.newList));
        this.lists = this.serviceList.findPersonListByUser(this.user.getId());
        for (PersonListDTO list : this.lists) {
            if (!list.getId().equals(this.newList.getId())) continue;
            this.selectedList = list;
        }
        return this;
    }

    Object onActionFromDeleteList() {
        if (this.selectedList != null) {
            for (PersonListDTO dto : this.lists) {
                if (!dto.getId().equals(this.selectedList.getId())) continue;
                this.serviceList.deletePersonList(this.selectedList.getId());
            }
        }
        this.selectedList = null;
        return this;
    }

    Object onSuccessFromCreateAccountForm() {
        for (PollAccountDTO dto : this.selectedList.getPollAccountDTOs()) {
            if (!dto.getVotingId().equals(this.newAccount.getVotingId())) continue;
            this.createAccountForm.recordError(this.messages.format("accountExists", new Object[]{this.newAccount.getVotingId()}));
        }
        if (!this.createAccountForm.getHasErrors()) {
            this.newAccount.setPersonListId(this.selectedList.getId());
            this.selectedList.getPollAccountDTOs().add(this.newAccount);
            this.serviceList.updatePersonList(this.selectedList);
            this.selectedList = this.serviceList.findPersonListById(this.selectedList.getId());
        }
        return this.listsZone.getBody();
    }

    Object onActionFromDeleteAccount(String accountId) {
        Iterator it = this.selectedList.getPollAccountDTOs().iterator();
        while (it.hasNext()) {
            if (!accountId.equals(((PollAccountDTO)it.next()).getId())) continue;
            it.remove();
        }
        this.serviceList.updatePersonList(this.selectedList);
        this.servicePollAccount.deletePollAccount(accountId);
        this.selectedList = this.serviceList.findPersonListById(this.selectedList.getId());
        return this.listsZone.getBody();
    }

    Object onUploadException(FileUploadException ex) {
        this.createListForm.recordError("Upload exception: " + ex.getMessage());
        return this;
    }

    public boolean isSelectedListNull() {
        return this.selectedList == null;
    }

    void onActivate() {
        this.evenOdd = new EvenOdd();
        if (this.userExists) {
            this.lists = this.serviceList.findPersonListByUser(this.user.getId());
        }
        this.newList = new PersonListDTO();
        this.newAccount = new PollAccountDTO();
    }

    void setupRender() {
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
        this.listModel = this.beanModelSource.createDisplayModel(PollAccountDTO.class, this.componentResources.getMessages());
        this.listModel.add("functions", null);
        this.listModel.include(new String[]{"votingId", "email", "functions"});
    }
}

