/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.pages.user;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.PasswordField;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.business.ServiceAuth;
import org.chorem.pollen.business.ServiceUser;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.data.Lien;

@IncludeStylesheet(value={"context:css/myAccount.css"})
public class MyAccount {
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;
    @Property
    @Persist
    private UserDTO newUser;
    @Component
    private Zone myAccountZone;
    @Component
    private Form myAccountForm;
    @Component(id="password")
    private PasswordField passwordField;
    @Component(id="newPassword1")
    private PasswordField newPasswordField;
    @Property
    private String password;
    @Property
    private String newPassword1;
    @Property
    private String newPassword2;
    @Inject
    private Messages messages;
    @Parameter(defaultPrefix="message", value="title")
    @Property
    private String title;
    @Property
    private Lien[] address;
    @Property
    private boolean modify = false;
    @Inject
    private ServiceUser serviceManagerUser;
    @Inject
    private ServiceAuth serviceAuth;

    Object onSuccessFromMyAccountForm() {
        if (this.serviceAuth.isLoginRight(this.newUser.getLogin(), MD5.encode((String)this.password)) != null) {
            if (this.serviceManagerUser.updateUser(this.newUser) && this.newPassword1 != null && !this.newPassword1.equals("")) {
                if (this.newPassword1.equals(this.newPassword2)) {
                    this.serviceManagerUser.updatePasswordUser(this.newUser, MD5.encode((String)this.newPassword1));
                    this.modify = false;
                } else {
                    this.myAccountForm.recordError((Field)this.newPasswordField, this.messages.get("passwords-dont-match"));
                    this.modify = true;
                }
            }
        } else {
            this.myAccountForm.recordError((Field)this.passwordField, "Mauvais password");
            this.modify = true;
        }
        return this.myAccountZone.getBody();
    }

    Object onActionFromModifyButton() {
        this.modify = true;
        return this.myAccountZone.getBody();
    }

    void setupRender() {
        this.newUser = this.user;
        this.address = new Lien[]{new Lien("Pollen", "Index"), new Lien(this.title, null)};
    }
}

