/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.exceptions.FavoriteListAlreadyExistException;
import org.chorem.pollen.services.exceptions.FavoriteListImportException;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.ui.actions.FileUploadAware;
import org.chorem.pollen.ui.actions.PollenActionSupportForEdition;

public class CreateFavoriteList
extends PollenActionSupportForEdition
implements FileUploadAware {
    private static final long serialVersionUID = 1L;
    protected PersonList createFavoriteList;
    protected File csvImport;
    protected String csvImportContentType;
    protected String csvImportFileName;
    protected String ldapImport;

    public void addFile(int index, File file) {
        this.csvImport = file;
    }

    public void addFileContentType(int index, String contentType) {
        this.csvImportContentType = contentType;
    }

    public void addFileName(int index, String fileName) {
        this.csvImportFileName = fileName;
    }

    public void setLdapImport(String ldapImport) {
        this.ldapImport = ldapImport;
    }

    public PersonList getCreateFavoriteList() {
        if (this.createFavoriteList == null) {
            this.createFavoriteList = this.getFavoriteService().newFavoriteList();
        }
        return this.createFavoriteList;
    }

    public String getLdapImport() {
        return this.ldapImport;
    }

    public String getAction() {
        return "create";
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getCreateFavoriteList().getName())) {
            this.addFieldError("createFavoriteList.name", this._("pollen.error.favoriteListName.required", new Object[0]));
        }
    }

    public String execute() throws Exception {
        String result;
        Preconditions.checkNotNull((Object)this.createFavoriteList);
        Preconditions.checkNotNull((Object)this.createFavoriteList.getName());
        int nbImports = 0;
        try {
            PersonList personList = this.getFavoriteService().createFavoriteList(this.getPollenUserAccount(), this.createFavoriteList.getName());
            if (this.csvImportFileName != null) {
                nbImports = this.addImportFromCsv(personList);
            }
            if (StringUtils.isNotBlank((CharSequence)this.ldapImport)) {
                nbImports = this.addImportFromLDAP(personList);
            }
        }
        catch (FavoriteListAlreadyExistException ex) {
            this.addFieldError("createFavoriteList.name", this._("pollen.error.favoriteList.already.used", new Object[0]));
        }
        if (this.hasAnyErrors()) {
            result = "input";
        } else {
            this.getTransaction().commitTransaction();
            if (nbImports > 0) {
                this.addFlashMessage(this._("pollen.information.favoriteList.imported", new Object[]{this.createFavoriteList.getName(), nbImports}));
            } else {
                this.addFlashMessage(this._("pollen.information.favoriteList.created", new Object[]{this.createFavoriteList.getName()}));
            }
            this.createFavoriteList = null;
            result = "success";
        }
        return result;
    }

    protected int addImportFromCsv(PersonList personList) throws FavoriteListNotFoundException {
        int nbImports = 0;
        try {
            List importedAccounts = this.getFavoriteService().importFromCsvfile(this.csvImportFileName, this.csvImport);
            nbImports = this.addImport(importedAccounts, personList);
        }
        catch (FavoriteListImportException ex) {
            String message = ex.getLocalizedMessage(this.getLocale());
            this.addFlashError(message);
        }
        return nbImports;
    }

    protected int addImportFromLDAP(PersonList personList) throws FavoriteListNotFoundException {
        int nbImports = 0;
        try {
            List importedAccounts = this.getFavoriteService().importFromLDAP(this.ldapImport);
            nbImports = this.addImport(importedAccounts, personList);
        }
        catch (FavoriteListImportException ex) {
            String message = ex.getLocalizedMessage(this.getLocale());
            this.addFlashError(message);
        }
        return nbImports;
    }

    protected int addImport(List<PollAccount> importedAccounts, PersonList list) throws FavoriteListNotFoundException {
        FavoriteService favoriteService = this.getFavoriteService();
        for (PollAccount importedAccount : importedAccounts) {
            try {
                favoriteService.addPollAccountToFavoriteList(list, importedAccount);
            }
            catch (ParticipantAlreadyFoundInListException ex) {
                this.addFlashError(this._("pollen.error.favoriteList.import.participantExists", new Object[]{importedAccount.getEmail()}));
            }
        }
        return importedAccounts.size();
    }
}

