/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.I18nAble;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.poll.AbstractPollForm;

public abstract class AbstractPollForm
extends PollenActionSupport {
    private static final long serialVersionUID = 1L;
    protected Poll poll;
    private Map<String, String> pollTypes;
    private Map<String, String> voteCountingTypes;
    private Map<String, String> choiceTypes;
    private List<Choice> textChoices;
    private List<Choice> imageChoices;
    private List<Choice> dateChoices;
    private List<VotingList> restrictedVotingList;
    private List<VotingList> groupVotingList;
    private boolean notification;
    private boolean reminder;
    private boolean limitChoice;
    private int reminderHourCountdown = 2;
    private transient PollService pollService;
    private transient Function<PersonToList, PersonToList> persontoListCreator;
    private transient Function<VotingList, VotingList> votingListCreator;
    private transient Function<Choice, Choice> textChoiceCreator;
    private transient Function<Choice, Choice> dateChoiceCreator;
    private transient Function<Choice, Choice> imageChoiceCreator;

    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    protected PollService getPollService() {
        if (this.pollService == null) {
            this.pollService = (PollService)this.newService(PollService.class);
        }
        return this.pollService;
    }

    public Poll getPoll() {
        return this.poll;
    }

    public boolean isInformationsError() {
        return false;
    }

    public boolean isOptionsError() {
        return false;
    }

    public Map<String, String> getPollTypes() {
        return this.pollTypes;
    }

    public Map<String, String> getVoteCountingTypes() {
        return this.voteCountingTypes;
    }

    public Map<String, String> getChoiceTypes() {
        return this.choiceTypes;
    }

    public List<Choice> getTextChoices() {
        return this.textChoices;
    }

    public List<Choice> getImageChoices() {
        return this.imageChoices;
    }

    public List<Choice> getDateChoices() {
        return this.dateChoices;
    }

    public List<VotingList> getRestrictedVotingList() {
        return this.restrictedVotingList;
    }

    public List<VotingList> getGroupVotingList() {
        return this.groupVotingList;
    }

    public boolean isNotification() {
        return this.notification;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    public boolean isReminder() {
        return this.reminder;
    }

    public void setReminder(boolean reminder) {
        this.reminder = reminder;
    }

    public boolean isLimitChoice() {
        return this.limitChoice;
    }

    public void setLimitChoice(boolean limitChoice) {
        this.limitChoice = limitChoice;
    }

    public int getReminderHourCountdown() {
        return this.reminderHourCountdown;
    }

    public void setReminderHourCountdown(int reminderHourCountdown) {
        this.reminderHourCountdown = reminderHourCountdown;
    }

    public boolean isFreePoll() {
        PollType pollType = this.poll.getPollType();
        return pollType == PollType.FREE;
    }

    public boolean isGroupPoll() {
        PollType pollType = this.poll.getPollType();
        return pollType == PollType.GROUP;
    }

    public String getPollVoteUrl() {
        return this.getPollService().getPollVoteUrl(this.poll, false).getUrl();
    }

    public String getPollModerateUrl() {
        return this.getPollService().getPollVoteUrl(this.poll, true).getUrl();
    }

    public String getPollEditUrl() {
        return this.getPollService().getPollEditUrl(this.poll).getUrl();
    }

    public int getSelectedTab() {
        int result = 0;
        return result;
    }

    public String getActionLabel() {
        return this.isEdit() ? this._("pollen.action.editPoll", new Object[0]) : this._("pollen.action.createPoll", new Object[0]);
    }

    public String getPageTitle() {
        return this.isEdit() ? this.getPoll().getTitle() : this._("pollen.title.createPoll", new Object[0]);
    }

    public boolean isVoteStarted() {
        return this.isEdit() && this.poll.sizeVote() > 0;
    }

    public boolean isCreatorUserAccountDefined() {
        PollAccount creator = this.poll.getCreator();
        return creator.getUserAccount() != null;
    }

    public boolean isEdit() {
        return StringUtils.isNotEmpty((CharSequence)this.getPoll().getTopiaId());
    }

    public void prepareFormPage() throws Exception {
        this.pollTypes = this.decorateToName((Enum[])PollType.values());
        this.choiceTypes = this.decorateToName((Enum[])ChoiceType.values());
        this.voteCountingTypes = this.decorateToName((Enum[])VoteCountingType.values());
        this.textChoices = Lists.newArrayList();
        this.imageChoices = Lists.newArrayList();
        this.dateChoices = Lists.newArrayList();
        this.restrictedVotingList = Lists.newArrayList();
        this.groupVotingList = Lists.newArrayList();
    }

    public Function<PersonToList, PersonToList> getPersontoListCreator() {
        if (this.persontoListCreator == null) {
            this.persontoListCreator = PollenServiceFunctions.newPersonToListCreator();
        }
        return this.persontoListCreator;
    }

    public Function<VotingList, VotingList> getVotingListCreator() {
        if (this.votingListCreator == null) {
            this.votingListCreator = PollenServiceFunctions.newVotingListCreator((Function)this.getPersontoListCreator());
        }
        return this.votingListCreator;
    }

    public Function<Choice, Choice> getTextChoiceCreator() {
        if (this.textChoiceCreator == null) {
            this.textChoiceCreator = PollenServiceFunctions.newTextChoiceCreator();
        }
        return this.textChoiceCreator;
    }

    public Function<Choice, Choice> getDateChoiceCreator() {
        if (this.dateChoiceCreator == null) {
            this.dateChoiceCreator = PollenServiceFunctions.newDateChoiceCreator();
        }
        return this.dateChoiceCreator;
    }

    public Function<Choice, Choice> getImageChoiceCreator() {
        if (this.imageChoiceCreator == null) {
            this.imageChoiceCreator = PollenServiceFunctions.newImageChoiceCreator();
        }
        return this.imageChoiceCreator;
    }

    private <E extends Enum<E>> Map<String, String> decorateToName(E ... values) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (E value : values) {
            result.put(((Enum)value).name(), this.getText(((I18nAble)value).getI18nKey()));
        }
        return result;
    }

    protected void loadChoicesAndvotingLists(Poll poll, Collection<Choice> pollChoices, Collection<VotingList> pollVotinLists, boolean fillLists) {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)poll.getChoiceType());
        Preconditions.checkNotNull((Object)poll.getPollType());
        if (CollectionUtils.isNotEmpty(pollChoices)) {
            switch (1.$SwitchMap$org$chorem$pollen$common$ChoiceType[poll.getChoiceType().ordinal()]) {
                case 1: {
                    this.getTextChoices().addAll(pollChoices);
                    break;
                }
                case 2: {
                    this.getDateChoices().addAll(pollChoices);
                    break;
                }
                case 3: {
                    this.getImageChoices().addAll(pollChoices);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(pollVotinLists)) {
            switch (1.$SwitchMap$org$chorem$pollen$common$PollType[poll.getPollType().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.getRestrictedVotingList().addAll(pollVotinLists);
                    break;
                }
                case 3: {
                    this.getGroupVotingList().addAll(pollVotinLists);
                }
            }
        }
        if (fillLists) {
            int defaultMaxChoices = 5;
            int defaultMaxVoting = 5;
            this.fillLists(defaultMaxChoices, defaultMaxVoting);
        }
    }

    protected void fillLists(int defaultMaxChoices, int defaultMaxVoting) {
        PollenServiceFunctions.fillChoiceList((List)this.textChoices, (int)defaultMaxChoices, (Function)this.getTextChoiceCreator());
        PollenServiceFunctions.fillChoiceList((List)this.dateChoices, (int)defaultMaxChoices, (Function)this.getDateChoiceCreator());
        PollenServiceFunctions.fillChoiceList((List)this.imageChoices, (int)defaultMaxChoices, (Function)this.getImageChoiceCreator());
        if (CollectionUtils.isEmpty((Collection)this.restrictedVotingList)) {
            this.restrictedVotingList.add(this.getVotingListCreator().apply(null));
        }
        for (VotingList votingList : this.restrictedVotingList) {
            PollenServiceFunctions.fillVotingList((VotingList)votingList, (Function)this.getPersontoListCreator(), (int)defaultMaxVoting);
        }
        if (CollectionUtils.isEmpty((Collection)this.groupVotingList)) {
            this.groupVotingList.add(this.getVotingListCreator().apply(null));
        }
        for (VotingList votingList : this.groupVotingList) {
            PollenServiceFunctions.fillVotingList((VotingList)votingList, (Function)this.getPersontoListCreator(), (int)defaultMaxVoting);
        }
    }
}

