/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: Login.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/Login.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.services.impl.UserService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * Login user to pollen.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class Login extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    private static final String HOME = "home";

    protected String login;

    protected String password;

    protected String redirectUrl;

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public String execute() throws Exception {

        UserService service = newService(UserService.class);

        if (StringUtils.isBlank(login) || StringUtils.isBlank(password)) {
            addFlashError(_("pollen.error.user.bad.login.or.password"));

        } else {
            try {
                UserAccount userAccount = service.connect(login, password);

                getPollenSession().setUserAccount(userAccount);
                addFlashMessage(_("pollen.information.your.are.loggued"));

            } catch (UserNotFoundException e) {
                addFlashError(_("pollen.error.user.bad.login.or.password"));
            } catch (UserInvalidPasswordException e) {
                addFlashError(_("pollen.error.user.bad.login.or.password"));
            }
        }

        String result;
        if (redirectUrl == null || redirectUrl.contains("/security")) {

            // After security problem, redirect to home
            result = HOME;

        } else {

            // Stay on the same page identified by redirectUrl
            result = SUCCESS;
        }
        return result;
    }
}
