/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.chorem.pollen.services.bean.VoteCountingTypeBean;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.votecounting.api.VoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountingFactory;
import org.chorem.pollen.votecounting.api.VoteCountingNotFound;
import org.chorem.pollen.votecounting.api.VoteCountings;

public class VoteCountingTypeService
extends PollenServiceSupport {
    public List<VoteCountingTypeBean> getVoteCountingTypes() {
        this.checkIsConnectedRequired();
        VoteCountingFactory factory = this.serviceContext.getVoteCountingFactory();
        ArrayList<VoteCountingTypeBean> voteCountingTypes = new ArrayList<VoteCountingTypeBean>();
        for (VoteCountings voteCountingId : factory.availableVoteCountingIds()) {
            VoteCountingTypeBean voteCountingTypeBean = this.idToVoteCountingType(voteCountingId);
            voteCountingTypes.add(voteCountingTypeBean);
        }
        return voteCountingTypes;
    }

    public VoteCountingTypeBean getVoteCountingType(VoteCountings id) {
        this.checkIsConnectedRequired();
        try {
            return this.idToVoteCountingType(id);
        }
        catch (VoteCountingNotFound e) {
            return null;
        }
    }

    protected VoteCountingTypeBean idToVoteCountingType(VoteCountings id) throws VoteCountingNotFound {
        VoteCountingFactory factory = this.serviceContext.getVoteCountingFactory();
        Locale l = this.serviceContext.getLocale();
        VoteCountingTypeBean newVoteCountingType = new VoteCountingTypeBean();
        VoteCounting voteCounting = factory.getVoteCounting(id);
        newVoteCountingType.setId(voteCounting.getLegacyId());
        newVoteCountingType.setName(voteCounting.getName(l));
        newVoteCountingType.setHelper(voteCounting.getHelp(l));
        newVoteCountingType.setShortHelper(voteCounting.getShortHelp(l));
        newVoteCountingType.setRenderType(voteCounting.getVoteValueEditorType());
        newVoteCountingType.setMinimumValue(voteCounting.getMinimumValue().orElse(null));
        return newVoteCountingType;
    }
}

