/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.Polls;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.VoteCountingFactory;
import org.chorem.pollen.votecounting.VoteCountingStrategy;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.GroupVoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.nuiton.topia.persistence.TopiaId;

public class PollVoteCountingService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(PollVoteCountingService.class);

    public VoteCountingResult getMainResult(Poll poll) {
        VoteCountingResult mainResult;
        if (poll.isPollGroup()) {
            GroupVoteCountingResult groupResult = this.getGroupResult(poll);
            mainResult = groupResult.getMainResult();
        } else {
            mainResult = this.getSimpleResult(poll);
        }
        return mainResult;
    }

    public VoteCountingResult getSimpleResult(Poll poll) {
        Preconditions.checkNotNull((Object)poll);
        VoteCounting voteCounting = Polls.getVoteCounting((VoteCountingFactory)this.serviceContext.getVoteCountingFactory(), (Poll)poll);
        Preconditions.checkNotNull((Object)voteCounting);
        VoteCountingStrategy strategy = voteCounting.newStrategy();
        GroupOfVoter group = Polls.toSimpleVotersGroup((Poll)poll);
        GroupVoteCountingResult result = strategy.votecount(group);
        return result.getMainResult();
    }

    public GroupVoteCountingResult getGroupResult(Poll poll) {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)poll);
        VoteCounting voteCounting = Polls.getVoteCounting((VoteCountingFactory)this.serviceContext.getVoteCountingFactory(), (Poll)poll);
        Preconditions.checkNotNull((Object)voteCounting);
        VoteCountingStrategy strategy = voteCounting.newStrategy();
        GroupOfVoter group = Polls.toGroupOfVoters((Poll)poll);
        GroupVoteCountingResult result = strategy.votecount(group);
        return result;
    }

    public String getResultValue(Choice choice, List<ChoiceScore> results) {
        String val = "";
        for (ChoiceScore result : results) {
            if (!result.getChoiceId().equals(choice.getTopiaId())) continue;
            val = this.getResultValue(result);
            break;
        }
        return val;
    }

    public String getResultValue(ChoiceScore result) {
        BigDecimal scoreValue = result.getScoreValue();
        String val = this.removeTrailing0(scoreValue == null ? "" : String.valueOf(scoreValue));
        return val;
    }

    public String getResultsAsString(Poll poll) {
        VoteCountingResult mainResult = this.getMainResult(poll);
        List results = mainResult.getTopRanking();
        ImmutableMap choicesById = Maps.uniqueIndex((Iterable)poll.getChoice(), (Function)TopiaId.GET_TOPIA_ID);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getDateTimePattern());
        ArrayList resultsAsString = Lists.newArrayList();
        for (ChoiceScore result : results) {
            String choiceResult;
            Choice choice = (Choice)choicesById.get((Object)result.getChoiceId());
            if (poll.getChoiceType() == ChoiceType.DATE) {
                Date date = new Date(Long.parseLong(choice.getName()));
                choiceResult = dateFormat.format(date);
            } else {
                choiceResult = choice.getName();
            }
            choiceResult = choiceResult + "=" + this.removeTrailing0(this.getResultValue(result));
            resultsAsString.add(choiceResult);
        }
        String result = Joiner.on((String)",").join((Iterable)resultsAsString);
        return result;
    }

    protected String removeTrailing0(String val) {
        if (val.endsWith(".0")) {
            val = val.substring(0, val.indexOf(46));
        }
        return val;
    }
}

