/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollCommentNotFound;
import org.chorem.pollen.services.impl.PollFeedService;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

public class PollCommentService
extends PollenServiceSupport {
    public Comment getExistingPollComment(String commentId) throws PollCommentNotFound {
        Comment result = this.getEntityById(Comment.class, commentId);
        if (result == null) {
            throw new PollCommentNotFound();
        }
        return result;
    }

    public Comment createComment(Poll poll, Comment comment) {
        Preconditions.checkNotNull((Object)poll);
        PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
        CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
        try {
            Poll pollToUpdate = (Poll)pollDAO.findByTopiaId(poll.getTopiaId());
            Comment commentCreated = (Comment)dao.create(new Object[]{"postDate", comment.getPostDate(), "author", comment.getAuthor(), "text", comment.getText()});
            pollToUpdate.addComment(commentCreated);
            PollAccount pollAccount = comment.getPollAccount();
            if (pollAccount.getTopiaId() != null) {
                PollAccount pollAccountLoaded = this.getEntityById(PollAccount.class, pollAccount.getTopiaId());
                if (pollAccountLoaded.getUserAccount() == null && pollAccount.getUserAccount() != null) {
                    String userId = pollAccount.getUserAccount().getTopiaId();
                    UserAccount userAccountLoaded = this.getEntityById(UserAccount.class, userId);
                    pollAccountLoaded.setUserAccount(userAccountLoaded);
                }
                commentCreated.setPollAccount(pollAccountLoaded);
            }
            PollFeedService pollFeedService = this.newService(PollFeedService.class);
            pollFeedService.onCommentAdded(poll, commentCreated);
            this.commitTransaction("Could not create comment (" + comment.getAuthor() + ") " + comment.getText());
            return commentCreated;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void deleteComment(Poll poll, String commentId, String reason) throws PollCommentNotFound {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)commentId);
        Comment comment = this.getExistingPollComment(commentId);
        CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
        try {
            dao.delete((TopiaEntity)comment);
            PollFeedService pollFeedService = this.newService(PollFeedService.class);
            pollFeedService.onCommentDeleted(poll, comment, reason);
            this.commitTransaction("Could not delete comment " + comment.getText());
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public Comment getNewComment(PollAccount account, String author, String text) {
        CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
        Comment result = (Comment)this.newInstance(dao);
        if (account != null) {
            result.setPollAccount(account);
        }
        result.setAuthor(author);
        result.setText(text);
        result.setPostDate(this.serviceContext.getCurrentTime());
        return result;
    }

    public List<Comment> getComments(TopiaPagerBean pager, String pollId) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)pollId);
        try {
            CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
            List result = dao.findComments(pager, pollId);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain comments", (Throwable)e);
        }
    }

    public List<Comment> getAllComments(String pollId) {
        Preconditions.checkNotNull((Object)pollId);
        try {
            CommentDAO dao = (CommentDAO)this.getDAO(Comment.class);
            List result = dao.findAllComments(pollId);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain comments", (Throwable)e);
        }
    }
}

