/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.DateUtil;

public class PollenServiceSupport
implements PollenService {
    protected PollenServiceContext serviceContext;

    @Override
    public void setServiceContext(PollenServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public <E extends TopiaEntity> List<E> getEntities(PollenDAOHelper.PollenEntityEnum entityType) {
        Class contract = entityType.getContract();
        return this.getEntities(contract);
    }

    public <E extends TopiaEntity> List<E> getEntities(Class<E> entityType) {
        Preconditions.checkNotNull(entityType);
        try {
            Object dao = this.getDAO(entityType);
            List result = dao.findAll();
            return result;
        }
        catch (TopiaException eee) {
            throw new PollenTechnicalException("Could not obtain data for type " + entityType, (Throwable)eee);
        }
    }

    public <E extends TopiaEntity> E getEntityById(Class<E> entityType, String id) {
        Preconditions.checkNotNull(entityType);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)id), (Object)("The " + entityType.getSimpleName() + " id is undefined"));
        try {
            Object dao = this.getDAO(entityType);
            TopiaEntity result = dao.findByTopiaId(id);
            return (E)result;
        }
        catch (TopiaException eee) {
            throw new PollenTechnicalException("Could not obtain data of id [" + id + "] for type " + entityType, (Throwable)eee);
        }
    }

    public <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(Class<T> entityType) {
        Preconditions.checkNotNull(entityType);
        try {
            TopiaDAO dao = PollenDAOHelper.getDAO((TopiaContext)this.getTransaction(), entityType);
            return (D)dao;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain dao of type " + entityType.getName(), (Throwable)e);
        }
    }

    public String decorateDateTime(Date date) {
        String result = null;
        if (date != null) {
            result = DateUtil.formatDate((Date)date, (String)this.getDateTimePattern());
        }
        return result;
    }

    public String decorateDate(Date date) {
        String result = null;
        if (date != null) {
            result = DateUtil.formatDate((Date)date, (String)this.getDatePattern());
        }
        return result;
    }

    public String getDateTimePattern() {
        String result = I18n.l_((Locale)this.serviceContext.getLocale(), (String)"pollen.common.dateTimePattern", (Object[])new Object[0]);
        return result;
    }

    public String getDatePattern() {
        String result = I18n.l_((Locale)this.serviceContext.getLocale(), (String)"pollen.common.datePattern", (Object[])new Object[0]);
        return result;
    }

    public <E extends PollenService> E newService(Class<E> serviceClass) {
        E service = this.serviceContext.newService(serviceClass);
        return service;
    }

    protected <T extends TopiaEntity, D extends TopiaDAO<? super T>> T newInstance(D dao) {
        try {
            return (T)dao.newInstance();
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain new instance from dao " + dao, (Throwable)e);
        }
    }

    protected <T extends TopiaEntity, D extends TopiaDAO<? super T>> void delete(D dao, T entity) {
        try {
            dao.delete(entity);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not delete entity " + entity.getTopiaId(), (Throwable)e);
        }
    }

    protected <T extends TopiaEntity, D extends TopiaDAO<? super T>> T create(D dao) {
        try {
            return (T)dao.create(new Object[0]);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not create entity ", (Throwable)e);
        }
    }

    protected <T extends TopiaEntity, D extends TopiaDAO<? super T>> T createWithProperties(D dao, Object ... properties) {
        try {
            return (T)dao.create(properties);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not create entity ", (Throwable)e);
        }
    }

    protected <T extends TopiaEntity, D extends TopiaDAO<? super T>> T update(D dao, T entity) {
        try {
            return (T)dao.update(entity);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not update entity ", (Throwable)e);
        }
    }

    protected TopiaContext getTransaction() {
        return this.serviceContext.getTransaction();
    }

    protected Locale getLocale() {
        return this.serviceContext.getLocale();
    }

    protected PollenConfiguration getConfiguration() {
        return this.serviceContext.getConfiguration();
    }

    protected void commitTransaction(String errorMessage) {
        try {
            this.getTransaction().commitTransaction();
        }
        catch (TopiaException eee) {
            throw new PollenTechnicalException(errorMessage, (Throwable)eee);
        }
    }

    protected void flushTransaction() throws TopiaException {
        TopiaContextImplementor tx = (TopiaContextImplementor)this.getTransaction();
        tx.getHibernate().flush();
    }
}

