/*
 * #%L
 * Pollen :: Services
 * $Id: PollUrlService.java 3513 2012-06-18 11:38:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-services/src/main/java/org/chorem/pollen/services/impl/PollUrlService.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollActions;
import org.chorem.pollen.services.PollenServiceSupport;

/**
 * Service to deal with url used by application.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class PollUrlService extends PollenServiceSupport {

    public PollUrl getPollSummaryUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.SUMMARY, poll, true);
        return result;
    }

    public PollUrl getPollCloneUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.CLONE, poll, true);
        return result;
    }

    public PollUrl getPollExportUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.EXPORT, poll, true);
        return result;
    }

    public PollUrl getPollVoteUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.VOTE, poll, false);
        return result;
    }

    public PollUrl getPollVoteUrl(Poll poll, PollAccount pollAccount) {
        PollUrl result = newPollUrl(PollActions.VOTE, poll, pollAccount);
        return result;
    }

    public PollUrl getPollModerateUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.MODERATE, poll, true);
        return result;
    }

    public PollUrl getPollEditUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.EDIT, poll, true);
        return result;
    }

    public PollUrl getPollResultUrl(Poll poll) {
        PollUrl result = newPollUrl(PollActions.RESULT, poll,
                                    !poll.isPublicResults());
        return result;
    }

    protected PollUrl newPollUrl(PollActions action, Poll poll, boolean admin) {
        Preconditions.checkNotNull(poll);
        return newPollUrl(action, poll, admin ? poll.getCreator() : null);
    }

    protected PollUrl newPollUrl(PollActions action,
                                 Poll poll,
                                 PollAccount pollAccount) {

        Preconditions.checkNotNull(poll);
        Preconditions.checkNotNull(action);

        String prefix = action.getActionPrefix() + '/';

        String applicationUrl = serviceContext.getApplicationURL().toString();
        if (!applicationUrl.endsWith("/")) {
            applicationUrl += '/';
        }
        String baseUrl = applicationUrl + prefix;
        PollUri pollUri;
        if (pollAccount == null) {

            // no account id
            pollUri = PollUri.newPollUri(poll.getPollId());
        } else {

            // add account id
            pollUri = PollUri.newPollUri(poll.getPollId(),
                                         pollAccount.getAccountId());
        }
        PollUrl result = PollUrl.newPollUrl(baseUrl, pollUri);
        return result;
    }
}
