/*
 * #%L
 * Pollen :: Services
 * $Id: FavoriteListImportException.java 3576 2012-07-31 16:17:34Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-services/src/main/java/org/chorem/pollen/services/exceptions/FavoriteListImportException.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.services.exceptions;

import java.util.Locale;

import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.l_;
import static org.nuiton.i18n.I18n.n_;

/**
 * Exception during favorite list import. There is
 * always a cause from librairies used for import.
 *
 * @author fdesbois <desbois@codelutin.com>
 */
public class FavoriteListImportException extends Exception {

    private static final long serialVersionUID = 1L;

    private static final String I18N_KEY = n_("pollen.error.import");

    private String importName;

    private String causeMessage;

    public FavoriteListImportException(String importName, String causeMessage, Throwable cause) {
        super(_(I18N_KEY, importName, causeMessage), cause);
        this.importName = importName;
        this.causeMessage = causeMessage;
    }

    public FavoriteListImportException(String importName, Throwable cause) {
        this(importName, cause.getMessage(), cause);
    }

    /** @return the name of import (CSV, LDAP, ...) */
    public String getImportName() {
        return importName;
    }

    /** @return the error message source from import execution. */
    public String getCauseMessage() {
        return causeMessage;
    }

    /**
     * Get the message depends on {@code locale}.
     *
     * @param locale Locale to translate the message
     * @return the localized message or default one if locale is null
     */
    public String getLocalizedMessage(Locale locale) {
        String result;
        if (locale == null) {
            result = getMessage();

        } else {
            result = l_(locale, I18N_KEY, getImportName(), getCauseMessage());
        }
        return result;
    }
}
