/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.InvalidEmailException;
import org.chorem.pollen.services.exceptions.UserEmailAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserInvalidPasswordException;
import org.chorem.pollen.services.exceptions.UserLoginAlreadyUsedException;
import org.chorem.pollen.services.exceptions.UserNotFoundException;
import org.chorem.pollen.services.impl.EmailService;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.StringUtil;

public class UserService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(UserService.class);

    public UserAccount connect(String login, String password) throws UserNotFoundException, UserInvalidPasswordException {
        Preconditions.checkNotNull((Object)login);
        Preconditions.checkNotNull((Object)password);
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        try {
            UserAccount user = dao.findByLogin(login);
            if (user == null) {
                throw new UserNotFoundException();
            }
            String encodedPassword = this.encodePassword(password);
            if (!encodedPassword.equals(user.getPassword())) {
                throw new UserInvalidPasswordException();
            }
            return user;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public UserAccount createUser(UserAccount user, boolean byAdmin) throws UserLoginAlreadyUsedException, UserEmailAlreadyUsedException {
        UserAccount userAccount;
        Preconditions.checkNotNull((Object)user);
        String password = user.getPassword();
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        try {
            UserAccount userByLogin = dao.findByLogin(user.getLogin());
            if (userByLogin != null) {
                throw new UserLoginAlreadyUsedException();
            }
            UserAccount userByEmail = dao.findByEmail(user.getEmail());
            if (userByEmail != null) {
                throw new UserEmailAlreadyUsedException();
            }
            if (byAdmin) {
                password = this.generatePassword();
                user.setPassword(password);
            }
            String encodedPassword = this.encodePassword(password);
            userAccount = (UserAccount)dao.create(new Object[]{"login", user.getLogin(), "password", encodedPassword});
            user.setTopiaId(userAccount.getTopiaId());
            this.copyUserAccount(user, userAccount);
            this.commitTransaction("Could not create user");
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
        EmailService emailService = this.newService(EmailService.class);
        emailService.onUserCreated(user);
        return userAccount;
    }

    public UserAccount updateUser(UserAccount user, String newPassword, boolean byAdmin) throws UserEmailAlreadyUsedException, UserInvalidPasswordException {
        Preconditions.checkNotNull((Object)user);
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        try {
            UserAccount userToUpdate = (UserAccount)dao.findByTopiaId(user.getTopiaId());
            if (!byAdmin) {
                String encodedPassword = this.encodePassword(user.getPassword());
                if (!encodedPassword.equals(userToUpdate.getPassword())) {
                    throw new UserInvalidPasswordException();
                }
                if (StringUtils.isNotEmpty((CharSequence)newPassword)) {
                    String newEncodedPassword = this.encodePassword(newPassword);
                    userToUpdate.setPassword(newEncodedPassword);
                }
            }
            if (dao.isUserExist(user)) {
                throw new UserEmailAlreadyUsedException();
            }
            this.copyUserAccount(user, userToUpdate);
            return userToUpdate;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void lostPassword(String email) throws UserNotFoundException, InvalidEmailException {
        UserAccount user;
        Preconditions.checkNotNull((Object)email);
        if (!StringUtil.isEmail((String)email)) {
            throw new InvalidEmailException();
        }
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        try {
            user = dao.findByEmail(email);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
        if (user == null) {
            throw new UserNotFoundException();
        }
        String newPassword = this.generatePassword();
        String encodedPassword = this.encodePassword(newPassword);
        user.setPassword(encodedPassword);
        EmailService emailService = this.newService(EmailService.class);
        emailService.onLostPassword(user, newPassword);
        this.commitTransaction("Can't update lost user password");
    }

    public UserAccount getNewUser() {
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        UserAccount result = (UserAccount)this.newInstance(dao);
        return result;
    }

    public void deleteUser(String id) throws UserNotFoundException {
        Preconditions.checkNotNull((Object)id);
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        try {
            UserAccount user = (UserAccount)dao.findByTopiaId(id);
            if (user == null) {
                throw new UserNotFoundException();
            }
            dao.delete(user);
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public List<UserAccount> getUsers(TopiaFilterPagerUtil.FilterPagerBean pager) {
        Preconditions.checkNotNull((Object)pager);
        try {
            UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
            List result = dao.getUsers(pager);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public int getNbUsers() {
        UserAccountDAO dao = (UserAccountDAO)this.getDAO(UserAccount.class);
        try {
            Long result = dao.count();
            return result.intValue();
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException((Throwable)e);
        }
    }

    public void createDefaultUsers() {
        block3: {
            UserAccount user = this.getNewUser();
            user.setAdministrator(true);
            String login = this.getConfiguration().getAdminLogin();
            user.setLogin(login);
            user.setEmail(this.getConfiguration().getAdminEmail());
            user.setPassword(this.getConfiguration().getAdminPassword());
            try {
                this.createUser(user, false);
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n._((String)"pollen.info.admin.created", (Object[])new Object[]{login}));
                }
            }
            catch (Exception eee) {
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)(I18n._((String)"pollen.info.admin.exists", (Object[])new Object[0]) + " : " + I18n._((String)eee.getMessage(), (Object[])new Object[0])));
            }
        }
    }

    protected String generatePassword() {
        return RandomStringUtils.randomAlphanumeric((int)8);
    }

    protected String encodePassword(String password) {
        return StringUtil.encodeMD5((String)password);
    }

    protected void copyUserAccount(UserAccount source, UserAccount destination) {
        TopiaEntityBinder binder = PollenBinderHelper.getSimpleTopiaBinder(UserAccount.class);
        binder.copy((Object)source, (Object)destination, new String[]{"administrator", "firstName", "lastName"});
        destination.setEmail(StringUtils.lowerCase((String)source.getEmail()));
    }
}

