/*
 * #%L
 * Pollen :: Services
 * 
 * $Id: PollImageChoice.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-services/src/main/java/org/chorem/pollen/bean/PollImageChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;

import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceImpl;

/**
 * Extends the basic choice to keep location of uploaded image
 * (during poll creation).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollImageChoice extends ChoiceImpl {

    private static final long serialVersionUID = 1L;
    
    public static final String PROPERTY_LOCATION = "location";

    protected String location;

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void fromChoice(Choice choice) {
        setName(choice.getName());
        setDescription(choice.getDescription());
        setTopiaId(choice.getTopiaId());
        setValidate(choice.isValidate());
        setPoll(choice.getPoll());
    }
    
    public void toChoice(Choice choice) {
        choice.setName(getName());
        choice.setDescription(getDescription());
        choice.setValidate(isValidate());
    }
}
