/*
 * #%L
 * Pollen :: Services
 * 
 * $Id: PollUri.java 3395 2012-05-28 15:34:46Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-services/src/main/java/org/chorem/pollen/bean/PollUri.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.bean;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollUri implements Serializable {

    private static final long serialVersionUID = 1L;

    public static PollUri newPollUri(String uri) {

        PollUri result = new PollUri();

        String[] split = uri.split(":", 2);
        if (split.length > 0) {
            result.setPollId(split[0]);
            if (split.length > 1) {
                result.setAccountId(split[1]);
            }
        }
        return result;
    }

    public static PollUri newPollUri(String pollId, String accountId) {
        Preconditions.checkNotNull(pollId);

        PollUri result = new PollUri();

        result.pollId = pollId;
        result.accountId = accountId;
        return result;
    }

    protected String pollId;

    protected String accountId;

    private PollUri() {
    }

    public String getPollId() {
        return pollId;
    }

    public String getAccountId() {
        return accountId;
    }

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getUri() {
        String result = pollId;
        if (StringUtils.isNotEmpty(accountId)) {
            result += ":" + accountId;
        }
        return result;
    }
}
